/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.RocksDBRangeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.rocksdb.RocksIterator;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class RocksDBRangeIteratorTest {
    private final String storeName = "store";
    private final String key1 = "a";
    private final String key2 = "b";
    private final String key3 = "c";
    private final String key4 = "d";
    private final String value = "value";
    private final Bytes key1Bytes = Bytes.wrap((byte[])"a".getBytes());
    private final Bytes key2Bytes = Bytes.wrap((byte[])"b".getBytes());
    private final Bytes key3Bytes = Bytes.wrap((byte[])"c".getBytes());
    private final Bytes key4Bytes = Bytes.wrap((byte[])"d".getBytes());
    private final byte[] valueBytes = "value".getBytes();

    @Test
    public void shouldReturnAllKeysInTheRangeInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key1Bytes.get()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).next();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)3))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)3))).next();
    }

    @Test
    public void shouldReturnAllKeysInTheRangeReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seekForPrev(this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key3Bytes.get()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).prev();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)3))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)3))).prev();
    }

    @Test
    public void shouldReturnAllKeysWhenLastKeyIsGreaterThanLargestKeyInStateStoreInForwardDirection() {
        Bytes toBytes = Bytes.increment((Bytes)this.key4Bytes);
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key1Bytes.get()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key3Bytes.get()).thenReturn((Object)this.key4Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).next();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, toBytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)4))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)4))).next();
    }

    @Test
    public void shouldReturnAllKeysWhenLastKeyIsSmallerThanSmallestKeyInStateStoreInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seekForPrev(this.key4Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key4Bytes.get()).thenReturn((Object)this.key3Bytes.get()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).prev();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key4Bytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)4))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)4))).prev();
    }

    @Test
    public void shouldReturnNoKeysWhenLastKeyIsSmallerThanSmallestKeyInStateStoreForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)false);
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnNoKeysWhenLastKeyIsLargerThanLargestKeyInStateStoreReverseDirection() {
        String from = "g";
        String to = "h";
        Bytes fromBytes = Bytes.wrap((byte[])"g".getBytes());
        Bytes toBytes = Bytes.wrap((byte[])"h".getBytes());
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seekForPrev(toBytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)false);
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, fromBytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnAllKeysInPartiallyOverlappingRangeInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).next();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).next();
    }

    @Test
    public void shouldReturnAllKeysInPartiallyOverlappingRangeInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        String to = "e";
        Bytes toBytes = Bytes.wrap((byte[])"e".getBytes());
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seekForPrev(toBytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key4Bytes.get()).thenReturn((Object)this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).prev();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key3Bytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).prev();
    }

    @Test
    public void shouldReturnTheCurrentKeyOnInvokingPeekNextKeyInForwardDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key2Bytes.get()).thenReturn((Object)this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).next();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key3Bytes, true, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key2Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThrows(NoSuchElementException.class, () -> ((RocksDBRangeIterator)rocksDBRangeIterator).peekNextKey());
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).next();
    }

    @Test
    public void shouldReturnTheCurrentKeyOnInvokingPeekNextKeyInReverseDirection() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        Bytes toBytes = Bytes.increment((Bytes)this.key4Bytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seekForPrev(toBytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key4Bytes.get()).thenReturn((Object)this.key3Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).prev();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key3Bytes, toBytes, false, true);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key4Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.peekNextKey(), (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key3Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThrows(NoSuchElementException.class, () -> ((RocksDBRangeIterator)rocksDBRangeIterator).peekNextKey());
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).prev();
    }

    @Test
    public void shouldCloseIterator() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).close();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        rocksDBRangeIterator.onClose(() -> {});
        rocksDBRangeIterator.close();
        ((RocksIterator)Mockito.verify((Object)rocksIterator)).close();
    }

    @Test
    public void shouldCallCloseCallbackOnClose() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, true);
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        rocksDBRangeIterator.onClose(() -> callbackCalled.set(true));
        rocksDBRangeIterator.close();
        MatcherAssert.assertThat((Object)callbackCalled.get(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExcludeEndOfRange() {
        RocksIterator rocksIterator = (RocksIterator)Mockito.mock(RocksIterator.class);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).seek(this.key1Bytes.get());
        Mockito.when((Object)rocksIterator.isValid()).thenReturn((Object)true);
        Mockito.when((Object)rocksIterator.key()).thenReturn((Object)this.key1Bytes.get()).thenReturn((Object)this.key2Bytes.get());
        Mockito.when((Object)rocksIterator.value()).thenReturn((Object)this.valueBytes);
        ((RocksIterator)Mockito.doNothing().when((Object)rocksIterator)).next();
        RocksDBRangeIterator rocksDBRangeIterator = new RocksDBRangeIterator("store", rocksIterator, this.key1Bytes, this.key2Bytes, true, false);
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((KeyValue)rocksDBRangeIterator.next()).key, (Matcher)Is.is((Object)this.key1Bytes));
        MatcherAssert.assertThat((Object)rocksDBRangeIterator.hasNext(), (Matcher)Is.is((Object)false));
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).value();
        ((RocksIterator)Mockito.verify((Object)rocksIterator, (VerificationMode)Mockito.times((int)2))).next();
    }
}

