/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class MeteredKeyValueStoreTest {
    private static final String APPLICATION_ID = "test-app";
    private static final String STORE_NAME = "store-name";
    private static final String STORE_TYPE = "scope";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final KeyValue<Bytes, byte[]> BYTE_KEY_VALUE_PAIR = KeyValue.pair((Object)KEY_BYTES, (Object)VALUE_BYTES);
    private final String threadId = Thread.currentThread().getName();
    private final TaskId taskId = new TaskId(0, 0, "My-Topology");
    @Mock
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock
    private InternalProcessorContext context;
    private MeteredKeyValueStore<String, String> metered;
    private final Metrics metrics = new Metrics();
    private Map<String, String> tags;

    @Before
    public void before() {
        MockTime mockTime = new MockTime();
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)mockTime, Serdes.String(), Serdes.String());
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        Mockito.when((Object)this.context.applicationId()).thenReturn((Object)APPLICATION_ID);
        Mockito.when((Object)this.context.metrics()).thenReturn((Object)new StreamsMetricsImpl(this.metrics, "test", "latest", (Time)mockTime));
        Mockito.when((Object)this.context.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn((Object)CHANGELOG_TOPIC);
        Mockito.when((Object)this.inner.name()).thenReturn((Object)STORE_NAME);
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)THREAD_ID_TAG_KEY, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    private void init() {
        this.metered.init((StateStoreContext)this.context, this.metered);
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        MeteredKeyValueStore outer = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).init((ProcessorContext)this.context, (StateStore)outer);
        outer.init((ProcessorContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldDelegateInit() {
        MeteredKeyValueStore outer = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).init((StateStoreContext)this.context, (StateStore)outer);
        outer.init((StateStoreContext)this.context, (StateStore)outer);
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)STORE_NAME, (String)this.taskId.topologyName());
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn(null);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)Mockito.mock(Serde.class);
        Serializer keySerializer = (Serializer)Mockito.mock(Serializer.class);
        Serde valueSerde = (Serde)Mockito.mock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)Mockito.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)Mockito.mock(Serializer.class);
        Mockito.when((Object)keySerde.serializer()).thenReturn((Object)keySerializer);
        Mockito.when((Object)keySerializer.serialize(topic, (Object)KEY)).thenReturn((Object)KEY.getBytes());
        Mockito.when((Object)valueSerde.deserializer()).thenReturn((Object)valueDeserializer);
        Mockito.when((Object)valueDeserializer.deserialize(topic, VALUE_BYTES)).thenReturn((Object)VALUE);
        Mockito.when((Object)valueSerde.serializer()).thenReturn((Object)valueSerializer);
        Mockito.when((Object)valueSerializer.serialize(topic, (Object)VALUE)).thenReturn((Object)VALUE_BYTES);
        Mockito.when((Object)this.inner.get((Object)KEY_BYTES)).thenReturn((Object)VALUE_BYTES);
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), keySerde, valueSerde);
        this.metered.init((StateStoreContext)this.context, this.metered);
        this.metered.get((Object)KEY);
        this.metered.put((Object)KEY, (Object)VALUE);
    }

    @Test
    public void testMetrics() {
        this.init();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", STORE_LEVEL_GROUP, THREAD_ID_TAG_KEY, this.threadId, this.taskId, STORE_TYPE, STORE_NAME)));
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() {
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).init((StateStoreContext)this.context, this.metered);
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        MatcherAssert.assertThat((Object)((Double)metric.metricValue()), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).put((Object)KEY_BYTES, (Object)VALUE_BYTES);
        this.init();
        this.metered.put((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        Mockito.when((Object)this.inner.get((Object)KEY_BYTES)).thenReturn((Object)VALUE_BYTES);
        this.init();
        MatcherAssert.assertThat((Object)this.metered.get((Object)KEY), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        KafkaMetric metric = this.metric("get-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        Mockito.when((Object)this.inner.putIfAbsent((Object)KEY_BYTES, (Object)VALUE_BYTES)).thenReturn(null);
        this.init();
        this.metered.putIfAbsent((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).putAll((List)ArgumentMatchers.any(List.class));
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair((Object)KEY, (Object)VALUE)));
        KafkaMetric metric = this.metric("put-all-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        Mockito.when((Object)this.inner.delete((Object)KEY_BYTES)).thenReturn((Object)VALUE_BYTES);
        this.init();
        this.metered.delete((Object)KEY);
        KafkaMetric metric = this.metric("delete-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        Mockito.when((Object)this.inner.range((Object)KEY_BYTES, (Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.range((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        Mockito.when((Object)this.inner.all()).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.all();
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFlushInnerWhenFlushTimeRecords() {
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).flush();
        this.init();
        this.metered.flush();
        KafkaMetric metric = this.metric("flush-rate");
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedKeyValueStore cachedKeyValueStore = (CachedKeyValueStore)Mockito.mock(CachedKeyValueStore.class);
        Mockito.when((Object)cachedKeyValueStore.setFlushListener((CacheFlushListener)ArgumentMatchers.any(CacheFlushListener.class), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)true);
        this.metered = new MeteredKeyValueStore((KeyValueStore)cachedKeyValueStore, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        Assert.assertTrue((boolean)this.metered.setFlushListener(null, false));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfGetReturnsNull() {
        Mockito.when((Object)this.inner.get((Object)Bytes.wrap((byte[])"a".getBytes()))).thenReturn(null);
        this.init();
        Assert.assertNull((Object)this.metered.get((Object)"a"));
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.metered.setFlushListener(null, false));
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.metered.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        ((KeyValueStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Oops!")}).when(this.inner)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThrows(RuntimeException.class, () -> this.metered.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldThrowNullPointerOnGetIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.get(null);
        });
    }

    @Test
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.put(null, (Object)VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfAbsentIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.putIfAbsent(null, (Object)VALUE);
        });
    }

    @Test
    public void shouldThrowNullPointerOnDeleteIfKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.metered.delete(null);
        });
    }

    @Test
    public void shouldThrowNullPointerOnPutAllIfAnyKeyIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.putAll(Collections.singletonList(KeyValue.pair(null, (Object)VALUE))));
    }

    @Test
    public void shouldThrowNullPointerOnPrefixScanIfPrefixIsNull() {
        StringSerializer stringSerializer = new StringSerializer();
        Assert.assertThrows(NullPointerException.class, () -> this.metered.prefixScan(null, (Serializer)stringSerializer));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.range(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.range((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfFromIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.reverseRange(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfToIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.metered.reverseRange((Object)"from", null));
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        StringSerializer stringSerializer = new StringSerializer();
        Mockito.when((Object)this.inner.prefixScan((Object)KEY, (Serializer)stringSerializer)).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.prefixScan((Object)KEY, (Serializer)stringSerializer);
        MatcherAssert.assertThat((Object)((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)VALUE));
        iterator.close();
        KafkaMetric metric = this.metrics.metric(new MetricName("prefix-scan-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assert.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, STORE_LEVEL_GROUP, "", this.tags));
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(STORE_LEVEL_GROUP) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedKeyValueStore
    extends KeyValueStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

