/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskCorruptedException;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ActiveTaskCreator;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StandbyTaskCreator;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateUpdater;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.Tasks;
import org.apache.kafka.streams.processor.internals.TasksRegistry;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.tasks.DefaultTaskManager;
import org.apache.kafka.streams.processor.internals.testutil.DummyStreamsConfig;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.StreamsTestUtils;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@MockitoSettings(strictness=Strictness.STRICT_STUBS)
@RunWith(value=EasyMockRunner.class)
public class TaskManagerTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final TaskId taskId00 = new TaskId(0, 0);
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p0changelog = new TopicPartition("changelog", 0);
    private final Set<TopicPartition> taskId00Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0});
    private final Set<TopicPartition> taskId00ChangelogPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0changelog});
    private final Map<TaskId, Set<TopicPartition>> taskId00Assignment = Collections.singletonMap(this.taskId00, this.taskId00Partitions);
    private final TaskId taskId01 = new TaskId(0, 1);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p2 = new TopicPartition("topic2", 1);
    private final TopicPartition t1p1changelog = new TopicPartition("changelog", 1);
    private final Set<TopicPartition> taskId01Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p1});
    private final Set<TopicPartition> taskId01ChangelogPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p1changelog});
    private final Map<TaskId, Set<TopicPartition>> taskId01Assignment = Collections.singletonMap(this.taskId01, this.taskId01Partitions);
    private final TaskId taskId02 = new TaskId(0, 2);
    private final TopicPartition t1p2 = new TopicPartition("topic1", 2);
    private final TopicPartition t1p2changelog = new TopicPartition("changelog", 2);
    private final Set<TopicPartition> taskId02Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p2});
    private final Set<TopicPartition> taskId02ChangelogPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p2changelog});
    private final TaskId taskId03 = new TaskId(0, 3);
    private final TopicPartition t1p3 = new TopicPartition("topic1", 3);
    private final TopicPartition t1p3changelog = new TopicPartition("changelog", 3);
    private final Set<TopicPartition> taskId03Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p3});
    private final Set<TopicPartition> taskId03ChangelogPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p3changelog});
    private final TaskId taskId04 = new TaskId(0, 4);
    private final TopicPartition t1p4 = new TopicPartition("topic1", 4);
    private final TopicPartition t1p4changelog = new TopicPartition("changelog", 4);
    private final Set<TopicPartition> taskId04Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p4});
    private final Set<TopicPartition> taskId04ChangelogPartitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p4changelog});
    private final TaskId taskId05 = new TaskId(0, 5);
    private final TopicPartition t1p5 = new TopicPartition("topic1", 5);
    private final Set<TopicPartition> taskId05Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t1p5});
    private final TaskId taskId10 = new TaskId(1, 0);
    private final TopicPartition t2p0 = new TopicPartition("topic2", 0);
    private final Set<TopicPartition> taskId10Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.t2p0});
    final java.util.function.Consumer<Set<TopicPartition>> noOpResetter = partitions -> {};
    @org.mockito.Mock
    private InternalTopologyBuilder topologyBuilder;
    @Mock(type=MockType.DEFAULT)
    private StateDirectory stateDirectory;
    @org.mockito.Mock
    private ChangelogReader changeLogReader;
    @Mock(type=MockType.STRICT)
    private Consumer<byte[], byte[]> consumer;
    @org.mockito.Mock
    private ActiveTaskCreator activeTaskCreator;
    @org.mockito.Mock
    private StandbyTaskCreator standbyTaskCreator;
    @org.mockito.Mock
    private Admin adminClient;
    @org.mockito.Mock
    private ProcessorStateManager stateManager;
    @org.mockito.Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ProcessorStateManager.StateStoreMetadata stateStore;
    final StateUpdater stateUpdater = (StateUpdater)Mockito.mock(StateUpdater.class);
    final DefaultTaskManager schedulingTaskManager = (DefaultTaskManager)Mockito.mock(DefaultTaskManager.class);
    private TaskManager taskManager;
    private TopologyMetadata topologyMetadata;
    private final Time time = new MockTime();
    @Rule
    public final TemporaryFolder testFolder = new TemporaryFolder();
    @Rule
    public final MockitoRule rule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);

    @Before
    public void setUp() {
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, null, false);
    }

    private TaskManager setUpTaskManager(StreamsConfigUtils.ProcessingMode processingMode, boolean stateUpdaterEnabled) {
        return this.setUpTaskManager(processingMode, null, stateUpdaterEnabled, false);
    }

    private TaskManager setUpTaskManager(StreamsConfigUtils.ProcessingMode processingMode, TasksRegistry tasks, boolean stateUpdaterEnabled) {
        return this.setUpTaskManager(processingMode, tasks, stateUpdaterEnabled, false);
    }

    private TaskManager setUpTaskManager(StreamsConfigUtils.ProcessingMode processingMode, TasksRegistry tasks, boolean stateUpdaterEnabled, boolean processingThreadsEnabled) {
        this.topologyMetadata = new TopologyMetadata(this.topologyBuilder, (StreamsConfig)new DummyStreamsConfig(processingMode));
        TaskManager taskManager = new TaskManager(this.time, this.changeLogReader, UUID.randomUUID(), "taskManagerTest", this.activeTaskCreator, this.standbyTaskCreator, (TasksRegistry)(tasks != null ? tasks : new Tasks(new LogContext())), this.topologyMetadata, this.adminClient, this.stateDirectory, stateUpdaterEnabled ? this.stateUpdater : null, processingThreadsEnabled ? this.schedulingTaskManager : null);
        taskManager.setMainConsumer(this.consumer);
        return taskManager;
    }

    @Test
    public void shouldClassifyExistingTasksWithoutStateUpdater() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, false);
        Map runningActiveTasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId01, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1}))});
        Map standbyTasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId02, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t2p2}))});
        Map restoringActiveTasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p3}))});
        HashMap activeTasks = new HashMap(runningActiveTasks);
        activeTasks.putAll(restoringActiveTasks);
        this.handleAssignment(runningActiveTasks, standbyTasks, restoringActiveTasks);
        taskManager.handleAssignment(activeTasks, standbyTasks);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.stateUpdater});
    }

    @Test
    public void shouldNotUpdateExistingStandbyTaskIfStandbyIsReassignedWithSameInputPartitionWithoutStateUpdater() {
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        this.updateExistingStandbyTaskIfStandbyIsReassignedWithoutStateUpdater((Task)standbyTask, this.taskId03Partitions);
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).updateInputPartitions((Set)Mockito.eq(this.taskId03Partitions), (Map)Mockito.any());
    }

    @Test
    public void shouldUpdateExistingStandbyTaskIfStandbyIsReassignedWithDifferentInputPartitionWithoutStateUpdater() {
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        this.updateExistingStandbyTaskIfStandbyIsReassignedWithoutStateUpdater((Task)standbyTask, this.taskId04Partitions);
        ((StandbyTask)Mockito.verify((Object)standbyTask)).updateInputPartitions((Set)Mockito.eq(this.taskId04Partitions), (Map)Mockito.any());
    }

    private void updateExistingStandbyTaskIfStandbyIsReassignedWithoutStateUpdater(Task standbyTask, Set<TopicPartition> newInputPartition) {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTask}));
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, false);
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTask.id(), newInputPartition)}));
        ((Task)Mockito.verify((Object)standbyTask)).resume();
    }

    @Test
    public void shouldLockAllTasksOnCorruptionWithProcessingThreads() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        Mockito.when((Object)tasks.activeTaskIds()).thenReturn((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        Mockito.when((Object)tasks.task(this.taskId00)).thenReturn((Object)activeTask1);
        KafkaFuture mockFuture = KafkaFuture.completedFuture(null);
        Mockito.when((Object)this.schedulingTaskManager.lockTasks((Set)ArgumentMatchers.any())).thenReturn((Object)mockFuture);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleCorruption(Utils.mkSet((Object[])new TaskId[]{this.taskId00}));
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).lockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).unlockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
    }

    @Test
    public void shouldLockCommitableTasksOnCorruptionWithProcessingThreads() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask activeTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        KafkaFuture mockFuture = KafkaFuture.completedFuture(null);
        Mockito.when((Object)this.schedulingTaskManager.lockTasks((Set)ArgumentMatchers.any())).thenReturn((Object)mockFuture);
        taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{activeTask1, activeTask2}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).lockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).unlockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
    }

    @Test
    public void shouldLockActiveOnHandleAssignmentWithProcessingThreads() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        Mockito.when((Object)tasks.allTaskIds()).thenReturn((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        KafkaFuture mockFuture = KafkaFuture.completedFuture(null);
        Mockito.when((Object)this.schedulingTaskManager.lockTasks((Set)ArgumentMatchers.any())).thenReturn((Object)mockFuture);
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions)}), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions)}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).lockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).unlockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
    }

    @Test
    public void shouldLockAffectedTasksOnHandleRevocation() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask activeTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask1, activeTask2}));
        KafkaFuture mockFuture = KafkaFuture.completedFuture(null);
        Mockito.when((Object)this.schedulingTaskManager.lockTasks((Set)ArgumentMatchers.any())).thenReturn((Object)mockFuture);
        taskManager.handleRevocation(this.taskId01Partitions);
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).lockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).unlockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}));
    }

    @Test
    public void shouldLockTasksOnClose() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask activeTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask1, activeTask2}));
        KafkaFuture mockFuture = KafkaFuture.completedFuture(null);
        Mockito.when((Object)this.schedulingTaskManager.lockTasks((Set)ArgumentMatchers.any())).thenReturn((Object)mockFuture);
        taskManager.closeAndCleanUpTasks((Collection)Utils.mkSet((Object[])new Task[]{activeTask1}), (Collection)Utils.mkSet((Object[])new Task[0]), false);
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).lockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00}));
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).unlockTasks(Utils.mkSet((Object[])new TaskId[]{this.taskId00}));
    }

    @Test
    public void shouldResumePollingForPartitionsWithAvailableSpaceForAllActiveTasks() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask activeTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.activeTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask1, activeTask2}));
        taskManager.resumePollingForPartitionsWithAvailableSpace();
        ((StreamTask)Mockito.verify((Object)activeTask1)).resumePollingForPartitionsWithAvailableSpace();
        ((StreamTask)Mockito.verify((Object)activeTask2)).resumePollingForPartitionsWithAvailableSpace();
    }

    @Test
    public void shouldUpdateLagForAllActiveTasks() {
        StreamTask activeTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask activeTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.activeTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask1, activeTask2}));
        taskManager.updateLags();
        ((StreamTask)Mockito.verify((Object)activeTask1)).updateLags();
        ((StreamTask)Mockito.verify((Object)activeTask2)).updateLags();
    }

    @Test
    public void shouldPrepareActiveTaskInStateUpdaterToBeRecycled() {
        StreamTask activeTaskToRecycle = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToRecycle}));
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToRecycle.id(), (Object)activeTaskToRecycle.inputPartitions())}));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToRecycle(activeTaskToRecycle.id(), activeTaskToRecycle.inputPartitions());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldPrepareStandbyTaskInStateUpdaterToBeRecycled() {
        StandbyTask standbyTaskToRecycle = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToRecycle}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToRecycle.id(), (Object)standbyTaskToRecycle.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(standbyTaskToRecycle.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToRecycle(standbyTaskToRecycle.id(), standbyTaskToRecycle.inputPartitions());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldRemoveUnusedActiveTaskFromStateUpdater() {
        StreamTask activeTaskToClose = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToClose}));
        taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(activeTaskToClose.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseClean(activeTaskToClose.id());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldRemoveUnusedStandbyTaskFromStateUpdater() {
        StandbyTask standbyTaskToClose = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToClose}));
        taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(standbyTaskToClose.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseClean(standbyTaskToClose.id());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldUpdateInputPartitionOfActiveTaskInStateUpdater() {
        StreamTask activeTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId02Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToUpdateInputPartitions}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToUpdateInputPartitions.id(), newInputPartitions)}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(activeTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToUpdateInputPartitions(activeTaskToUpdateInputPartitions.id(), newInputPartitions);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldCloseReviveAndUpdateInputPartitionOfActiveTaskInStateUpdater() {
        StreamTask activeTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId02Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToUpdateInputPartitions}));
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(activeTaskToUpdateInputPartitions.id())).thenReturn((Object)true);
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToUpdateInputPartitions.id(), newInputPartitions)}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(activeTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).removePendingTaskToCloseClean(activeTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseReviveAndUpdateInputPartitions(activeTaskToUpdateInputPartitions.id(), newInputPartitions);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldKeepReassignedActiveTaskInStateUpdater() {
        StreamTask reassignedActiveTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{reassignedActiveTask}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)reassignedActiveTask.id(), (Object)reassignedActiveTask.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldMoveReassignedSuspendedActiveTaskToStateUpdater() {
        StreamTask reassignedActiveTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.SUSPENDED).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{reassignedActiveTask}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)reassignedActiveTask.id(), (Object)reassignedActiveTask.inputPartitions())}), Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)reassignedActiveTask);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)reassignedActiveTask);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldRemoveReassignedRevokedActiveTaskInStateUpdaterFromPendingTaskToSuspend() {
        StreamTask reassignedRevokedActiveTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{reassignedRevokedActiveTask}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)reassignedRevokedActiveTask.id(), (Object)reassignedRevokedActiveTask.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).removePendingActiveTaskToSuspend(reassignedRevokedActiveTask.id());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldRemoveReassignedLostTaskInStateUpdaterFromPendingTaskToCloseClean() {
        StreamTask reassignedLostTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{reassignedLostTask}));
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(reassignedLostTask.id())).thenReturn((Object)true);
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)reassignedLostTask.id(), (Object)reassignedLostTask.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).removePendingTaskToCloseClean(reassignedLostTask.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToAddBack(reassignedLostTask.id());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldNeverUpdateInputPartitionsOfStandbyTaskInStateUpdater() {
        StandbyTask standbyTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId03Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToUpdateInputPartitions}));
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToUpdateInputPartitions.id(), newInputPartitions)}));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(standbyTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addPendingTaskToUpdateInputPartitions(standbyTaskToUpdateInputPartitions.id(), newInputPartitions);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldNeverCloseReviveAndUpdateInputPartitionsOfStandbyTaskInStateUpdater() {
        StandbyTask standbyTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId03Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToUpdateInputPartitions}));
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToUpdateInputPartitions.id(), newInputPartitions)}));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(standbyTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).removePendingTaskToCloseClean(standbyTaskToUpdateInputPartitions.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addPendingTaskToCloseReviveAndUpdateInputPartitions(standbyTaskToUpdateInputPartitions.id(), newInputPartitions);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldKeepReassignedStandbyTaskInStateUpdater() {
        StandbyTask reassignedStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{reassignedStandbyTask}));
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)reassignedStandbyTask.id(), (Object)reassignedStandbyTask.inputPartitions())}));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldAssignMultipleTasksInStateUpdater() {
        StreamTask activeTaskToClose = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        StandbyTask standbyTaskToRecycle = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToClose, standbyTaskToRecycle}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToRecycle.id(), (Object)standbyTaskToRecycle.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(activeTaskToClose.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseClean(activeTaskToClose.id());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(standbyTaskToRecycle.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToRecycle(standbyTaskToRecycle.id(), standbyTaskToRecycle.inputPartitions());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldReturnStateUpdaterTasksInAllTasks() {
        StreamTask activeTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTask}));
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)activeTask)}));
        Assert.assertEquals((Object)taskManager.allTasks(), (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)activeTask), Utils.mkEntry((Object)this.taskId02, (Object)standbyTask)}));
    }

    @Test
    public void shouldNotReturnStateUpdaterTasksInOwnedTasks() {
        StreamTask activeTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTask}));
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)activeTask)}));
        Assert.assertEquals((Object)taskManager.allOwnedTasks(), (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)activeTask)}));
    }

    @Test
    public void shouldCreateActiveTaskDuringAssignment() {
        StreamTask activeTaskToBeCreated = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Set createdTasks = Utils.mkSet((Object[])new Task[]{activeTaskToBeCreated});
        Map tasksToBeCreated = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToBeCreated.id(), (Object)activeTaskToBeCreated.inputPartitions())});
        Mockito.when((Object)this.activeTaskCreator.createTasks(this.consumer, tasksToBeCreated)).thenReturn((Object)createdTasks);
        taskManager.handleAssignment(tasksToBeCreated, Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)createdTasks);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldCreateStandbyTaskDuringAssignment() {
        StandbyTask standbyTaskToBeCreated = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Set createdTasks = Utils.mkSet((Object[])new Task[]{standbyTaskToBeCreated});
        Mockito.when((Object)this.standbyTaskCreator.createTasks(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToBeCreated.id(), (Object)standbyTaskToBeCreated.inputPartitions())}))).thenReturn((Object)createdTasks);
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToBeCreated.id(), (Object)standbyTaskToBeCreated.inputPartitions())}));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)createdTasks);
    }

    @Test
    public void shouldAddRecycledStandbyTaskfromActiveToPendingTasksToInitWithStateUpdaterEnabled() {
        StreamTask activeTaskToRecycle = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.CREATED).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToRecycle}));
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(activeTaskToRecycle, this.taskId01Partitions)).thenReturn((Object)standbyTask);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions)}));
        ((StreamTask)Mockito.verify((Object)activeTaskToRecycle)).prepareCommit();
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(activeTaskToRecycle.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)Utils.mkSet((Object[])new Task[]{standbyTask}));
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)activeTaskToRecycle);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldAddRecycledStandbyTaskfromActiveToTaskRegistryWithStateUpdaterDisabled() {
        StreamTask activeTaskToRecycle = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.CREATED).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToRecycle}));
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(activeTaskToRecycle, this.taskId01Partitions)).thenReturn((Object)standbyTask);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, false);
        taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions)}));
        ((StreamTask)Mockito.verify((Object)activeTaskToRecycle)).prepareCommit();
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(activeTaskToRecycle.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).replaceActiveWithStandby(standbyTask);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldThrowDuringAssignmentIfStandbyTaskToRecycleIsFoundInTasksRegistryWithStateUpdaterEnabled() {
        StandbyTask standbyTaskToRecycle = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToRecycle}));
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        IllegalStateException illegalStateException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToRecycle.id(), (Object)standbyTaskToRecycle.inputPartitions())}), Collections.emptyMap()));
        Assert.assertEquals((Object)illegalStateException.getMessage(), (Object)("Standby tasks should only be managed by the state updater, but standby task " + this.taskId03 + " is managed by the stream thread"));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.activeTaskCreator});
    }

    @Test
    public void shouldAssignActiveTaskInTasksRegistryToBeClosedCleanlyWithStateUpdaterEnabled() {
        StreamTask activeTaskToClose = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToClose}));
        taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(activeTaskToClose.id());
        ((StreamTask)Mockito.verify((Object)activeTaskToClose)).prepareCommit();
        ((StreamTask)Mockito.verify((Object)activeTaskToClose)).closeClean();
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)activeTaskToClose);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldThrowDuringAssignmentIfStandbyTaskToCloseIsFoundInTasksRegistryWithStateUpdaterEnabled() {
        StandbyTask standbyTaskToClose = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToClose}));
        IllegalStateException illegalStateException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        Assert.assertEquals((Object)illegalStateException.getMessage(), (Object)("Standby tasks should only be managed by the state updater, but standby task " + this.taskId03 + " is managed by the stream thread"));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.activeTaskCreator});
    }

    @Test
    public void shouldAssignActiveTaskInTasksRegistryToUpdateInputPartitionsWithStateUpdaterEnabled() {
        StreamTask activeTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId02Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToUpdateInputPartitions}));
        Mockito.when((Object)tasks.updateActiveTaskInputPartitions((Task)activeTaskToUpdateInputPartitions, newInputPartitions)).thenReturn((Object)true);
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToUpdateInputPartitions.id(), newInputPartitions)}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StreamTask)Mockito.verify((Object)activeTaskToUpdateInputPartitions)).updateInputPartitions((Set)Mockito.eq(newInputPartitions), (Map)ArgumentMatchers.any());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldResumeActiveRunningTaskInTasksRegistryWithStateUpdaterEnabled() {
        StreamTask activeTaskToResume = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToResume}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToResume.id(), (Object)activeTaskToResume.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldResumeActiveSuspendedTaskInTasksRegistryAndAddToStateUpdater() {
        StreamTask activeTaskToResume = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.SUSPENDED).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToResume}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToResume.id(), (Object)activeTaskToResume.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Collections.emptyMap());
        ((StreamTask)Mockito.verify((Object)activeTaskToResume)).resume();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)activeTaskToResume);
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)activeTaskToResume);
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldThrowDuringAssignmentIfStandbyTaskToUpdateInputPartitionsIsFoundInTasksRegistryWithStateUpdaterEnabled() {
        StandbyTask standbyTaskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        Set<TopicPartition> newInputPartitions = this.taskId03Partitions;
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTaskToUpdateInputPartitions}));
        IllegalStateException illegalStateException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> taskManager.handleAssignment(Collections.emptyMap(), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)standbyTaskToUpdateInputPartitions.id(), (Object)newInputPartitions)})));
        Assert.assertEquals((Object)illegalStateException.getMessage(), (Object)("Standby tasks should only be managed by the state updater, but standby task " + this.taskId02 + " is managed by the stream thread"));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.activeTaskCreator});
    }

    @Test
    public void shouldAssignMultipleTasksInTasksRegistryWithStateUpdaterEnabled() {
        StreamTask activeTaskToClose = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId03Partitions).build();
        StreamTask activeTaskToCreate = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTaskToClose}));
        taskManager.handleAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToCreate.id(), (Object)activeTaskToCreate.inputPartitions())}), Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks(this.consumer, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)activeTaskToCreate.id(), (Object)activeTaskToCreate.inputPartitions())}));
        ((StreamTask)Mockito.verify((Object)activeTaskToClose)).closeClean();
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldAddTasksToStateUpdater() {
        StreamTask task00 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask task01 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.drainPendingTasksToInit()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01}));
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)task00)).initializeIfNeeded();
        ((StandbyTask)Mockito.verify((Object)task01)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task00);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task01);
    }

    @Test
    public void shouldRetryInitializationWhenLockExceptionInStateUpdater() {
        StreamTask task00 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask task01 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.drainPendingTasksToInit()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01}));
        LockException lockException = new LockException("Where are my keys??");
        ((StreamTask)Mockito.doThrow((Throwable[])new Throwable[]{lockException}).when((Object)task00)).initializeIfNeeded();
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)task00)).initializeIfNeeded();
        ((StandbyTask)Mockito.verify((Object)task01)).initializeIfNeeded();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)Mockito.argThat(tasksToInit -> tasksToInit.contains(task00) && !tasksToInit.contains(task01)));
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).add((Task)task00);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task01);
    }

    @Test
    public void shouldRetryInitializationWhenLockExceptionAfterRecyclingInStateUpdater() {
        StreamTask task00 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask task01 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        StandbyTask task00Converted = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00Partitions).withInputPartitions(this.taskId00Partitions).build();
        StreamTask task01Converted = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01Partitions).withInputPartitions(this.taskId01Partitions).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(task00.id())).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(task01.id())).thenReturn(this.taskId01Partitions);
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.activeTaskCreator.createActiveTaskFromStandby(task01, this.taskId01Partitions, this.consumer)).thenReturn((Object)task01Converted);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(task00, this.taskId00Partitions)).thenReturn((Object)task00Converted);
        LockException lockException = new LockException("Where are my keys??");
        ((StandbyTask)Mockito.doThrow((Throwable[])new Throwable[]{lockException}).when((Object)task00Converted)).initializeIfNeeded();
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StandbyTask)Mockito.verify((Object)task00Converted)).initializeIfNeeded();
        ((StreamTask)Mockito.verify((Object)task01Converted)).initializeIfNeeded();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)Mockito.argThat(tasksToInit -> tasksToInit.contains(task00Converted) && !tasksToInit.contains(task01Converted)));
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).add((Task)task00Converted);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task01Converted);
    }

    @Test
    public void shouldRecycleTasksRemovedFromStateUpdater() {
        StreamTask task00 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask task01 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        StandbyTask task00Converted = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00Partitions).withInputPartitions(this.taskId00Partitions).build();
        StreamTask task01Converted = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01Partitions).withInputPartitions(this.taskId01Partitions).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(task00.id())).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(task01.id())).thenReturn(this.taskId01Partitions);
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.activeTaskCreator.createActiveTaskFromStandby(task01, this.taskId01Partitions, this.consumer)).thenReturn((Object)task01Converted);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(task00, this.taskId00Partitions)).thenReturn((Object)task00Converted);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded((TaskId)ArgumentMatchers.any());
        ((StreamTask)Mockito.verify((Object)task00)).suspend();
        ((StandbyTask)Mockito.verify((Object)task01)).suspend();
        ((StandbyTask)Mockito.verify((Object)task00Converted)).initializeIfNeeded();
        ((StreamTask)Mockito.verify((Object)task01Converted)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task00Converted);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)task01Converted);
    }

    @Test
    public void shouldCloseTasksRemovedFromStateUpdater() {
        StreamTask task00 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask task01 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle((TaskId)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(task00.id())).thenReturn((Object)true);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(task01.id())).thenReturn((Object)true);
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded((TaskId)ArgumentMatchers.any());
        ((StreamTask)Mockito.verify((Object)task00)).suspend();
        ((StreamTask)Mockito.verify((Object)task00)).closeClean();
        ((StandbyTask)Mockito.verify((Object)task01)).suspend();
        ((StandbyTask)Mockito.verify((Object)task01)).closeClean();
    }

    @Test
    public void shouldUpdateInputPartitionsOfTasksRemovedFromStateUpdater() {
        StreamTask activeTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask, standbyTask}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle((TaskId)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions((TaskId)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(activeTask.id())).thenReturn(this.taskId02Partitions);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(standbyTask.id())).thenReturn(this.taskId03Partitions);
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)activeTask)).updateInputPartitions((Set)Mockito.eq(this.taskId02Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)activeTask, (VerificationMode)Mockito.never())).closeDirty();
        ((StreamTask)Mockito.verify((Object)activeTask, (VerificationMode)Mockito.never())).closeClean();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)activeTask);
        ((StandbyTask)Mockito.verify((Object)standbyTask)).updateInputPartitions((Set)Mockito.eq(this.taskId03Partitions), ArgumentMatchers.anyMap());
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).closeDirty();
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).closeClean();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)standbyTask);
    }

    @Test
    public void shouldCloseReviveAndUpdateInputPartitionsOfTasksRemovedFromStateUpdater() {
        StreamTask activeTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeTask}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle((TaskId)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(activeTask.id())).thenReturn(this.taskId02Partitions);
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)activeTask)).closeClean();
        ((StreamTask)Mockito.verify((Object)activeTask)).revive();
        ((StreamTask)Mockito.verify((Object)activeTask)).updateInputPartitions((Set)Mockito.eq(this.taskId02Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)activeTask)).initializeIfNeeded();
        ((StreamTask)Mockito.verify((Object)activeTask, (VerificationMode)Mockito.never())).closeDirty();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)activeTask);
    }

    @Test
    public void shouldSuspendRevokedTaskRemovedFromStateUpdater() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingActiveTaskToSuspend(statefulTask.id())).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{statefulTask}));
        this.taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((StreamTask)Mockito.verify((Object)statefulTask)).suspend();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)statefulTask);
    }

    @Test
    public void shouldHandleMultipleRemovedTasksFromStateUpdater() {
        StreamTask taskToRecycle0 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StandbyTask taskToRecycle1 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        StandbyTask convertedTask0 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00ChangelogPartitions).build();
        StreamTask convertedTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).build();
        StreamTask taskToClose = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId02Partitions).build();
        StreamTask taskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        StreamTask taskToCloseReviveAndUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId04, this.taskId04ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId04Partitions).build();
        Mockito.when((Object)this.stateUpdater.hasRemovedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{taskToRecycle0, taskToRecycle1, taskToClose, taskToUpdateInputPartitions, taskToCloseReviveAndUpdateInputPartitions}));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.activeTaskCreator.createActiveTaskFromStandby(taskToRecycle1, this.taskId01Partitions, this.consumer)).thenReturn((Object)convertedTask1);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(taskToRecycle0, this.taskId00Partitions)).thenReturn((Object)convertedTask0);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet()).anyTimes();
        this.consumer.resume((Collection)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(taskToClose.id())).thenReturn((Object)true);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToClose.id())))).thenReturn((Object)false);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(taskToRecycle0.id())).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(taskToRecycle1.id())).thenReturn(this.taskId01Partitions);
        Mockito.when((Object)tasks.removePendingTaskToRecycle((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToRecycle0.id()) && !taskId.equals((Object)taskToRecycle1.id())))).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(taskToUpdateInputPartitions.id())).thenReturn(this.taskId04Partitions);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(taskToCloseReviveAndUpdateInputPartitions.id())).thenReturn(this.taskId05Partitions);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToCloseReviveAndUpdateInputPartitions.id())))).thenReturn(null);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.setMainConsumer(this.consumer);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.checkStateUpdater(this.time.milliseconds(), noOpResetter -> {});
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator, (VerificationMode)Mockito.times((int)3))).closeAndRemoveTaskProducerIfNeeded((TaskId)ArgumentMatchers.any());
        ((StandbyTask)Mockito.verify((Object)convertedTask0)).initializeIfNeeded();
        ((StreamTask)Mockito.verify((Object)convertedTask1)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)convertedTask0);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)convertedTask1);
        ((StreamTask)Mockito.verify((Object)taskToClose)).closeClean();
        ((StreamTask)Mockito.verify((Object)taskToUpdateInputPartitions)).updateInputPartitions((Set)Mockito.eq(this.taskId04Partitions), ArgumentMatchers.anyMap());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)taskToUpdateInputPartitions);
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).closeClean();
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).revive();
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).updateInputPartitions((Set)Mockito.eq(this.taskId05Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)taskToCloseReviveAndUpdateInputPartitions);
    }

    @Test
    public void shouldReturnFalseFromCheckStateUpdaterIfActiveTasksAreRestoring() {
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Assert.assertFalse((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
    }

    @Test
    public void shouldReturnFalseFromCheckStateUpdaterIfActiveTasksAreNotRestoringAndNoPendingTaskToInitButPendingTasksToRecycle() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.hasPendingTasksToRecycle()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Assert.assertFalse((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
    }

    @Test
    public void shouldReturnFalseFromCheckStateUpdaterIfActiveTasksAreNotRestoringAndNoPendingTaskToRecycleButPendingTasksToInit() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.hasPendingTasksToInit()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Assert.assertFalse((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
    }

    @Test
    public void shouldReturnTrueFromCheckStateUpdaterIfActiveTasksAreNotRestoringAndNoPendingTasksToRecycleAndInit() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Assert.assertTrue((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
    }

    @Test
    public void shouldAddActiveTaskWithRevokedInputPartitionsInStateUpdaterToPendingTasksToSuspend() {
        StreamTask task = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setupForRevocationAndLost(Utils.mkSet((Object[])new Task[]{task}), tasks);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task}));
        taskManager.handleRevocation((Collection)task.inputPartitions());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingActiveTaskToSuspend(task.id());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(task.id());
    }

    public void shouldAddMultipleActiveTasksWithRevokedInputPartitionsInStateUpdaterToPendingTasksToSuspend() {
        StreamTask task1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask task2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId01Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setupForRevocationAndLost(Utils.mkSet((Object[])new Task[]{task1, task2}), tasks);
        taskManager.handleRevocation((Collection)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions}));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingActiveTaskToSuspend(task1.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingActiveTaskToSuspend(task2.id());
    }

    @Test
    public void shouldNotAddActiveTaskWithoutRevokedInputPartitionsInStateUpdaterToPendingTasksToSuspend() {
        StreamTask task = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setupForRevocationAndLost(Utils.mkSet((Object[])new Task[]{task}), tasks);
        taskManager.handleRevocation(this.taskId01Partitions);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(task.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addPendingActiveTaskToSuspend(task.id());
    }

    @Test
    public void shouldNotRevokeStandbyTaskInStateUpdaterOnRevocation() {
        StandbyTask task = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setupForRevocationAndLost(Utils.mkSet((Object[])new Task[]{task}), tasks);
        taskManager.handleRevocation(this.taskId00Partitions);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(task.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addPendingActiveTaskToSuspend(task.id());
    }

    @Test
    public void shouldRemoveAllActiveTasksFromStateUpdaterOnPartitionLost() {
        StreamTask task1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StandbyTask task2 = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId01Partitions).build();
        StreamTask task3 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setupForRevocationAndLost(Utils.mkSet((Object[])new Task[]{task1, task2, task3}), tasks);
        taskManager.handleLostAll();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(task1.id());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).remove(task2.id());
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).remove(task3.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseClean(task1.id());
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addPendingTaskToCloseClean(task2.id());
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTaskToCloseClean(task3.id());
    }

    private TaskManager setupForRevocationAndLost(Set<Task> tasksInStateUpdater, TasksRegistry tasks) {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn(tasksInStateUpdater);
        return taskManager;
    }

    @Test
    public void shouldTransitRestoredTaskToRunning() {
        StreamTask task = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTransitionToRunningOfRestoredTask(task, tasks);
        this.consumer.resume((Collection)task.inputPartitions());
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)task)).completeRestoration(this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)task)).clearTaskTimeout();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)task);
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldHandleTimeoutExceptionInTransitRestoredTaskToRunning() {
        StreamTask task = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTransitionToRunningOfRestoredTask(task, tasks);
        TimeoutException timeoutException = new TimeoutException();
        ((StreamTask)Mockito.doThrow((Throwable[])new Throwable[]{timeoutException}).when((Object)task)).completeRestoration(this.noOpResetter);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)task)).maybeInitTaskTimeoutOrThrow(ArgumentMatchers.anyLong(), (Exception)Mockito.eq((Object)timeoutException));
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).addTask((Task)task);
        ((StreamTask)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).clearTaskTimeout();
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    private TaskManager setUpTransitionToRunningOfRestoredTask(StreamTask statefulTask, TasksRegistry tasks) {
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        return this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
    }

    @Test
    public void shouldReturnCorrectBooleanWhenTryingToCompleteRestorationWithStateUpdater() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, true);
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)false);
        Assert.assertTrue((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Assert.assertFalse((boolean)taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
    }

    @Test
    public void shouldRecycleRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId00Partitions).build();
        TaskManager taskManager = this.setUpRecycleRestoredTask(statefulTask);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(statefulTask, statefulTask.inputPartitions())).thenReturn((Object)standbyTask);
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(statefulTask.id());
        ((StreamTask)Mockito.verify((Object)statefulTask)).suspend();
        ((StandbyTask)Mockito.verify((Object)standbyTask)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)standbyTask);
    }

    @Test
    public void shouldHandleExceptionThrownDuringConversionInRecycleRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TaskManager taskManager = this.setUpRecycleRestoredTask(statefulTask);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(statefulTask, statefulTask.inputPartitions())).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertThrows(StreamsException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).add((Task)ArgumentMatchers.any());
        ((StreamTask)Mockito.verify((Object)statefulTask)).closeDirty();
    }

    @Test
    public void shouldHandleExceptionThrownDuringTaskInitInRecycleRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.CLOSED).withInputPartitions(this.taskId00Partitions).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId00Partitions).build();
        TaskManager taskManager = this.setUpRecycleRestoredTask(statefulTask);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(statefulTask, statefulTask.inputPartitions())).thenReturn((Object)standbyTask);
        ((StandbyTask)Mockito.doThrow(StreamsException.class).when((Object)standbyTask)).initializeIfNeeded();
        Assert.assertThrows(StreamsException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater, (VerificationMode)Mockito.never())).add((Task)ArgumentMatchers.any());
        ((StandbyTask)Mockito.verify((Object)standbyTask)).closeDirty();
    }

    private TaskManager setUpRecycleRestoredTask(StreamTask statefulTask) {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        return this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
    }

    @Test
    public void shouldCloseCleanRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpCloseCleanRestoredTask(statefulTask, tasks);
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(statefulTask.id());
        ((StreamTask)Mockito.verify((Object)statefulTask)).suspend();
        ((StreamTask)Mockito.verify((Object)statefulTask)).closeClean();
        ((StreamTask)Mockito.verify((Object)statefulTask, (VerificationMode)Mockito.never())).closeDirty();
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).removeTask((Task)statefulTask);
    }

    @Test
    public void shouldHandleExceptionThrownDuringCloseInCloseCleanRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpCloseCleanRestoredTask(statefulTask, tasks);
        ((StreamTask)Mockito.doThrow(RuntimeException.class).when((Object)statefulTask)).closeClean();
        Assert.assertThrows(RuntimeException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(statefulTask.id());
        ((StreamTask)Mockito.verify((Object)statefulTask)).closeDirty();
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).removeTask((Task)statefulTask);
    }

    @Test
    public void shouldHandleExceptionThrownDuringClosingTaskProducerInCloseCleanRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.CLOSED).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpCloseCleanRestoredTask(statefulTask, tasks);
        TaskId taskId = statefulTask.id();
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something happened")}).when((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(taskId);
        Assert.assertThrows(RuntimeException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        ((StreamTask)Mockito.verify((Object)statefulTask, (VerificationMode)Mockito.never())).closeDirty();
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).removeTask((Task)statefulTask);
    }

    private TaskManager setUpCloseCleanRestoredTask(StreamTask statefulTask, TasksRegistry tasks) {
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(statefulTask.id())).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        return this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
    }

    @Test
    public void shouldAddBackRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToAddBack(statefulTask.id())).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)statefulTask);
        ((TasksRegistry)Mockito.verify((Object)tasks, (VerificationMode)Mockito.never())).removeTask((Task)statefulTask);
    }

    @Test
    public void shouldUpdateInputPartitionsOfRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(statefulTask.id())).thenReturn(this.taskId01Partitions);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        this.consumer.resume((Collection)statefulTask.inputPartitions());
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((StreamTask)Mockito.verify((Object)statefulTask)).updateInputPartitions((Set)Mockito.eq(this.taskId01Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)statefulTask)).completeRestoration(this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)statefulTask)).clearTaskTimeout();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)statefulTask);
    }

    @Test
    public void shouldCloseReviveAndUpdateInputPartitionsOfRestoredTask() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(statefulTask.id())).thenReturn(this.taskId01Partitions);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((StreamTask)Mockito.verify((Object)statefulTask)).updateInputPartitions((Set)Mockito.eq(this.taskId01Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)statefulTask)).closeClean();
        ((StreamTask)Mockito.verify((Object)statefulTask)).revive();
        ((StreamTask)Mockito.verify((Object)statefulTask)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)statefulTask);
    }

    @Test
    public void shouldSuspendRestoredTaskIfRevoked() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(statefulTask.id())).thenReturn(null);
        Mockito.when((Object)tasks.removePendingActiveTaskToSuspend(statefulTask.id())).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{statefulTask}));
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((StreamTask)Mockito.verify((Object)statefulTask)).suspend();
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)statefulTask);
    }

    @Test
    public void shouldHandleMultipleRestoredTasks() {
        StreamTask taskToTransitToRunning = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask taskToRecycle = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId01Partitions).build();
        StandbyTask recycledStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId01Partitions).build();
        StreamTask taskToCloseClean = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId02Partitions).build();
        StreamTask taskToAddBack = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        StreamTask taskToUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId04, this.taskId04ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId04Partitions).build();
        StreamTask taskToCloseReviveAndUpdateInputPartitions = StreamsTestUtils.TaskBuilder.statelessTask(this.taskId05).inState(Task.State.RESTORING).withInputPartitions(this.taskId05Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive(taskToRecycle, taskToRecycle.inputPartitions())).thenReturn((Object)recycledStandbyTask);
        Mockito.when((Object)tasks.removePendingTaskToRecycle(taskToRecycle.id())).thenReturn(this.taskId01Partitions);
        Mockito.when((Object)tasks.removePendingTaskToRecycle((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToRecycle.id())))).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean(taskToCloseClean.id())).thenReturn((Object)true);
        Mockito.when((Object)tasks.removePendingTaskToCloseClean((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToCloseClean.id())))).thenReturn((Object)false);
        Mockito.when((Object)tasks.removePendingTaskToAddBack(taskToAddBack.id())).thenReturn((Object)true);
        Mockito.when((Object)tasks.removePendingTaskToAddBack((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToAddBack.id())))).thenReturn((Object)false);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions(taskToUpdateInputPartitions.id())).thenReturn(this.taskId05Partitions);
        Mockito.when((Object)tasks.removePendingTaskToUpdateInputPartitions((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToUpdateInputPartitions.id())))).thenReturn(null);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions(taskToCloseReviveAndUpdateInputPartitions.id())).thenReturn(this.taskId04Partitions);
        Mockito.when((Object)tasks.removePendingTaskToCloseReviveAndUpdateInputPartitions((TaskId)ArgumentMatchers.argThat(taskId -> !taskId.equals((Object)taskToCloseReviveAndUpdateInputPartitions.id())))).thenReturn(null);
        Mockito.when((Object)this.stateUpdater.restoresActiveTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks((Duration)ArgumentMatchers.any(Duration.class))).thenReturn((Object)Utils.mkSet((Object[])new StreamTask[]{taskToTransitToRunning, taskToRecycle, taskToCloseClean, taskToAddBack, taskToUpdateInputPartitions, taskToCloseReviveAndUpdateInputPartitions}));
        taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter);
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)taskToTransitToRunning);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)recycledStandbyTask);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)recycledStandbyTask);
        ((StreamTask)Mockito.verify((Object)taskToCloseClean)).closeClean();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)taskToAddBack);
        ((StreamTask)Mockito.verify((Object)taskToUpdateInputPartitions)).updateInputPartitions((Set)Mockito.eq(this.taskId05Partitions), ArgumentMatchers.anyMap());
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).closeClean();
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).revive();
        ((StreamTask)Mockito.verify((Object)taskToCloseReviveAndUpdateInputPartitions)).initializeIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)taskToCloseReviveAndUpdateInputPartitions);
    }

    @Test
    public void shouldRethrowStreamsExceptionFromStateUpdater() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StreamsException exception = new StreamsException("boom!");
        StateUpdater.ExceptionAndTasks exceptionAndTasks = new StateUpdater.ExceptionAndTasks(Collections.singleton(statefulTask), (RuntimeException)((Object)exception));
        Mockito.when((Object)this.stateUpdater.hasExceptionsAndFailedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainExceptionsAndFailedTasks()).thenReturn(Collections.singletonList(exceptionAndTasks));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        Assert.assertEquals((Object)((Object)exception), (Object)((Object)thrown));
        Assert.assertEquals((Object)statefulTask.id(), thrown.taskId().get());
    }

    @Test
    public void shouldRethrowRuntimeExceptionFromStateUpdater() {
        StreamTask statefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        RuntimeException exception = new RuntimeException("boom!");
        StateUpdater.ExceptionAndTasks exceptionAndTasks = new StateUpdater.ExceptionAndTasks(Collections.singleton(statefulTask), exception);
        Mockito.when((Object)this.stateUpdater.hasExceptionsAndFailedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainExceptionsAndFailedTasks()).thenReturn(Collections.singletonList(exceptionAndTasks));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        Assert.assertEquals((Object)exception, (Object)thrown.getCause());
        Assert.assertEquals((Object)statefulTask.id(), thrown.taskId().get());
        Assert.assertEquals((Object)"Encounter unexpected fatal error for task 0_0", (Object)thrown.getMessage());
    }

    @Test
    public void shouldRethrowTaskCorruptedExceptionFromStateUpdater() {
        StreamTask statefulTask0 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask statefulTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId01Partitions).build();
        StateUpdater.ExceptionAndTasks exceptionAndTasks0 = new StateUpdater.ExceptionAndTasks(Collections.singleton(statefulTask0), (RuntimeException)new TaskCorruptedException(Collections.singleton(this.taskId00)));
        StateUpdater.ExceptionAndTasks exceptionAndTasks1 = new StateUpdater.ExceptionAndTasks(Collections.singleton(statefulTask1), (RuntimeException)new TaskCorruptedException(Collections.singleton(this.taskId01)));
        Mockito.when((Object)this.stateUpdater.hasExceptionsAndFailedTasks()).thenReturn((Object)true);
        Mockito.when((Object)this.stateUpdater.drainExceptionsAndFailedTasks()).thenReturn(Arrays.asList(exceptionAndTasks0, exceptionAndTasks1));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        TaskCorruptedException thrown = (TaskCorruptedException)Assert.assertThrows(TaskCorruptedException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}), (Object)thrown.corruptedTasks());
        Assert.assertEquals((Object)"Tasks [0_1, 0_0] are corrupted and hence need to be re-initialized", (Object)thrown.getMessage());
    }

    @Test
    public void shouldRethrowTaskCorruptedExceptionFromInitialization() {
        StreamTask statefulTask0 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId00Partitions).build();
        StreamTask statefulTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId01Partitions).build();
        StreamTask statefulTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, tasks, true);
        Mockito.when((Object)tasks.drainPendingTasksToInit()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{statefulTask0, statefulTask1, statefulTask2}));
        ((StreamTask)Mockito.doThrow((Throwable[])new Throwable[]{new TaskCorruptedException(Collections.singleton(statefulTask0.id))}).when((Object)statefulTask0)).initializeIfNeeded();
        ((StreamTask)Mockito.doThrow((Throwable[])new Throwable[]{new TaskCorruptedException(Collections.singleton(statefulTask1.id))}).when((Object)statefulTask1)).initializeIfNeeded();
        TaskCorruptedException thrown = (TaskCorruptedException)Assert.assertThrows(TaskCorruptedException.class, () -> taskManager.checkStateUpdater(this.time.milliseconds(), this.noOpResetter));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)statefulTask0);
        ((TasksRegistry)Mockito.verify((Object)tasks)).addTask((Task)statefulTask1);
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).add((Task)statefulTask2);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01}), (Object)thrown.corruptedTasks());
        Assert.assertEquals((Object)"Tasks [0_1, 0_0] are corrupted and hence need to be re-initialized", (Object)thrown.getMessage());
    }

    @Test
    public void shouldAddSubscribedTopicsFromAssignmentToTopologyMetadata() {
        Map activeTasksAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId01, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1})), Utils.mkEntry((Object)this.taskId02, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p2, this.t2p2}))});
        Map standbyTasksAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p3})), Utils.mkEntry((Object)this.taskId04, (Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p4}))});
        Mockito.when((Object)this.standbyTaskCreator.createTasks(standbyTasksAssignment)).thenReturn(Collections.emptySet());
        this.taskManager.handleAssignment(activeTasksAssignment, standbyTasksAssignment);
        ((InternalTopologyBuilder)Mockito.verify((Object)this.topologyBuilder)).addSubscribedTopicsFromAssignment((Set)Mockito.eq((Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1, this.t1p2, this.t2p2})), Mockito.anyString());
        ((InternalTopologyBuilder)Mockito.verify((Object)this.topologyBuilder, (VerificationMode)Mockito.never())).addSubscribedTopicsFromAssignment((Set)Mockito.eq((Object)Utils.mkSet((Object[])new TopicPartition[]{this.t1p3, this.t1p4})), Mockito.anyString());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)activeTasksAssignment));
    }

    @Test
    public void shouldNotLockAnythingIfStateDirIsEmpty() {
        EasyMock.expect((Object)this.stateDirectory.listNonEmptyTaskDirectories()).andReturn(new ArrayList()).once();
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
        Assert.assertTrue((boolean)this.taskManager.lockedTaskDirectories().isEmpty());
    }

    @Test
    public void shouldTryToLockValidTaskDirsAtRebalanceStart() throws Exception {
        this.expectLockObtainedFor(this.taskId01);
        this.expectLockFailedFor(this.taskId10);
        this.expectDirectoryNotEmpty(this.taskId01);
        this.makeTaskFolders(this.taskId01.toString(), this.taskId10.toString(), "dummy");
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is(Collections.singleton(this.taskId01)));
    }

    @Test
    public void shouldUnlockEmptyDirsAtRebalanceStart() throws Exception {
        this.expectLockObtainedFor(this.taskId01, this.taskId10);
        this.expectDirectoryNotEmpty(this.taskId01);
        EasyMock.expect((Object)this.stateDirectory.directoryForTaskIsEmpty(this.taskId10)).andReturn((Object)true);
        this.expectUnlockFor(this.taskId10);
        this.makeTaskFolders(this.taskId01.toString(), this.taskId10.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is(Collections.singleton(this.taskId01)));
    }

    @Test
    public void shouldPauseAllTopicsWithoutStateUpdaterOnRebalanceComplete() {
        Set assigned = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t1p1});
        EasyMock.expect((Object)this.consumer.assignment()).andReturn((Object)assigned);
        this.consumer.pause((Collection)assigned);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleRebalanceComplete();
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldNotPauseReadyTasksWithStateUpdaterOnRebalanceComplete() {
        StreamTask statefulTask0 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{statefulTask0}));
        Set assigned = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t1p1});
        EasyMock.expect((Object)this.consumer.assignment()).andReturn((Object)assigned);
        this.consumer.pause((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleRebalanceComplete();
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldReleaseLockForUnassignedTasksAfterRebalance() throws Exception {
        this.expectLockObtainedFor(this.taskId00, this.taskId01, this.taskId02);
        this.expectDirectoryNotEmpty(this.taskId00, this.taskId01, this.taskId02);
        this.expectUnlockFor(this.taskId02);
        this.makeTaskFolders(this.taskId00.toString(), this.taskId01.toString(), this.taskId02.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01, this.taskId02})));
        this.handleAssignment(this.taskId00Assignment, this.taskId01Assignment, Collections.emptyMap());
        EasyMock.reset((Object[])new Object[]{this.consumer});
        TaskManagerTest.expectConsumerAssignmentPaused(this.consumer);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleRebalanceComplete();
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01})));
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
    }

    @Test
    public void shouldReleaseLockForUnassignedTasksAfterRebalanceWithStateUpdater() throws Exception {
        StreamTask runningStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId00Partitions).build();
        StreamTask restoringStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId01Partitions).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        StandbyTask unassignedStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.CREATED).withInputPartitions(this.taskId03Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)runningStatefulTask)}));
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{standbyTask, restoringStatefulTask}));
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{runningStatefulTask}));
        this.expectLockObtainedFor(this.taskId00, this.taskId01, this.taskId02, this.taskId03);
        this.expectDirectoryNotEmpty(this.taskId00, this.taskId01, this.taskId02, this.taskId03);
        this.expectUnlockFor(this.taskId03);
        this.makeTaskFolders(this.taskId00.toString(), this.taskId01.toString(), this.taskId02.toString(), this.taskId03.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        Set assigned = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, this.t1p1, this.t1p2});
        EasyMock.expect((Object)this.consumer.assignment()).andReturn((Object)assigned);
        this.consumer.pause((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.t1p1, this.t1p2}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleRebalanceStart(Collections.singleton("topic"));
        taskManager.handleRebalanceComplete();
        EasyMock.verify((Object[])new Object[]{this.consumer});
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
        MatcherAssert.assertThat((Object)taskManager.lockedTaskDirectories(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01, this.taskId02})));
    }

    @Test
    public void shouldReportLatestOffsetAsOffsetSumForRunningTask() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)-2L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)-2L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)-2L)});
        this.computeOffsetSumAndVerify(changelogOffsets, expectedOffsetSums);
    }

    @Test
    public void shouldComputeOffsetSumForNonRunningActiveTask() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)5L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)15L)});
        this.computeOffsetSumAndVerify(changelogOffsets, expectedOffsetSums);
    }

    @Test
    public void shouldComputeOffsetSumForRestoringActiveTaskWithStateUpdater() throws Exception {
        StreamTask restoringStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RESTORING).build();
        long changelogOffset = 42L;
        Mockito.when((Object)restoringStatefulTask.changelogOffsets()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p0changelog, (Object)42L)}));
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        Map changelogOffsetInCheckpoint = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p0changelog, (Object)24L)});
        this.writeCheckpointFile(this.taskId00, changelogOffsetInCheckpoint);
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{restoringStatefulTask}));
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        taskManager.handleRebalanceStart(Collections.singleton("topic"));
        MatcherAssert.assertThat((Object)taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)42L)})));
    }

    @Test
    public void shouldComputeOffsetSumForRestoringStandbyTaskWithStateUpdater() throws Exception {
        StandbyTask restoringStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).build();
        long changelogOffset = 42L;
        Mockito.when((Object)restoringStandbyTask.changelogOffsets()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p0changelog, (Object)42L)}));
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        Map changelogOffsetInCheckpoint = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p0changelog, (Object)24L)});
        this.writeCheckpointFile(this.taskId00, changelogOffsetInCheckpoint);
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{restoringStandbyTask}));
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        taskManager.handleRebalanceStart(Collections.singleton("topic"));
        MatcherAssert.assertThat((Object)taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)42L)})));
    }

    @Test
    public void shouldComputeOffsetSumForRunningStatefulTaskAndRestoringTaskWithStateUpdater() {
        StreamTask runningStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).inState(Task.State.RUNNING).build();
        StreamTask restoringStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).build();
        StandbyTask restoringStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).build();
        long changelogOffsetOfRunningTask = 42L;
        long changelogOffsetOfRestoringStatefulTask = 24L;
        long changelogOffsetOfRestoringStandbyTask = 84L;
        Mockito.when((Object)runningStatefulTask.changelogOffsets()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p0changelog, (Object)42L)}));
        Mockito.when((Object)restoringStatefulTask.changelogOffsets()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p1changelog, (Object)24L)}));
        Mockito.when((Object)restoringStandbyTask.changelogOffsets()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.t1p2changelog, (Object)84L)}));
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)runningStatefulTask)}));
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{restoringStandbyTask, restoringStatefulTask}));
        MatcherAssert.assertThat((Object)taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)42L), Utils.mkEntry((Object)this.taskId01, (Object)24L), Utils.mkEntry((Object)this.taskId02, (Object)84L)})));
    }

    @Test
    public void shouldSkipUnknownOffsetsWhenComputingOffsetSum() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)-4L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)10L)});
        this.computeOffsetSumAndVerify(changelogOffsets, expectedOffsetSums);
    }

    private void computeOffsetSumAndVerify(Map<TopicPartition, Long> changelogOffsets, Map<TaskId, Long> expectedOffsetSums) throws Exception {
        this.expectLockObtainedFor(this.taskId00);
        this.expectDirectoryNotEmpty(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        StateMachineTask restoringTask = this.handleAssignment(Collections.emptyMap(), Collections.emptyMap(), this.taskId00Assignment).get(this.taskId00);
        restoringTask.setChangelogOffsets(changelogOffsets);
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is(expectedOffsetSums));
    }

    @Test
    public void shouldComputeOffsetSumForStandbyTask() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)5L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)15L)});
        this.expectLockObtainedFor(this.taskId00);
        this.expectDirectoryNotEmpty(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        StateMachineTask restoringTask = this.handleAssignment(Collections.emptyMap(), this.taskId00Assignment, Collections.emptyMap()).get(this.taskId00);
        restoringTask.setChangelogOffsets(changelogOffsets);
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)expectedOffsetSums));
    }

    @Test
    public void shouldComputeOffsetSumForUnassignedTaskWeCanLock() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)5L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)15L)});
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        this.writeCheckpointFile(this.taskId00, changelogOffsets);
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)expectedOffsetSums));
    }

    @Test
    public void shouldComputeOffsetSumFromCheckpointFileForUninitializedTask() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)5L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)15L)});
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        this.writeCheckpointFile(this.taskId00, changelogOffsets);
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        StateMachineTask uninitializedTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singleton(uninitializedTask));
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)uninitializedTask.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)expectedOffsetSums));
    }

    @Test
    public void shouldComputeOffsetSumFromCheckpointFileForClosedTask() throws Exception {
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 0), (Object)5L), Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)10L)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)15L)});
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        this.writeCheckpointFile(this.taskId00, changelogOffsets);
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        StateMachineTask closedTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singleton(closedTask));
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        closedTask.suspend();
        closedTask.closeClean();
        MatcherAssert.assertThat((Object)closedTask.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)expectedOffsetSums));
    }

    @Test
    public void shouldNotReportOffsetSumsForTaskWeCantLock() throws Exception {
        this.expectLockFailedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        Assert.assertTrue((boolean)this.taskManager.lockedTaskDirectories().isEmpty());
        Assert.assertTrue((boolean)this.taskManager.getTaskOffsetSums().isEmpty());
    }

    @Test
    public void shouldNotReportOffsetSumsAndReleaseLockForUnassignedTaskWithoutCheckpoint() throws Exception {
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        this.expectDirectoryNotEmpty(this.taskId00);
        EasyMock.expect((Object)this.stateDirectory.checkpointFileFor(this.taskId00)).andReturn((Object)this.getCheckpointFile(this.taskId00));
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        Assert.assertTrue((boolean)this.taskManager.getTaskOffsetSums().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.stateDirectory});
    }

    @Test
    public void shouldPinOffsetSumToLongMaxValueInCaseOfOverflow() throws Exception {
        long largeOffset = 0x3FFFFFFFFFFFFFFFL;
        Map changelogOffsets = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TopicPartition("changelog", 1), (Object)0x3FFFFFFFFFFFFFFFL), Utils.mkEntry((Object)new TopicPartition("changelog", 2), (Object)0x3FFFFFFFFFFFFFFFL), Utils.mkEntry((Object)new TopicPartition("changelog", 3), (Object)0x3FFFFFFFFFFFFFFFL)});
        Map expectedOffsetSums = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)Long.MAX_VALUE)});
        this.expectLockObtainedFor(this.taskId00);
        this.makeTaskFolders(this.taskId00.toString());
        this.writeCheckpointFile(this.taskId00, changelogOffsets);
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.singleton("topic"));
        MatcherAssert.assertThat((Object)this.taskManager.getTaskOffsetSums(), (Matcher)Matchers.is((Object)expectedOffsetSums));
    }

    @Test
    public void shouldCloseActiveUnassignedSuspendedTasksWhenClosingRevokedTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.expectLastCall();
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
    }

    @Test
    public void shouldCloseDirtyActiveUnassignedTasksWhenErrorCleanClosingTask() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public void closeClean() {
                throw new RuntimeException("KABOOM!");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        this.taskManager.handleRevocation(this.taskId00Partitions);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Encounter unexpected fatal error for task 0_0"));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
    }

    @Test
    public void shouldCloseActiveTasksWhenHandlingLostTasks() throws Exception {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        this.makeTaskFolders(this.taskId00.toString(), this.taskId01.toString());
        this.expectLockObtainedFor(this.taskId00, this.taskId01);
        this.expectDirectoryNotEmpty(this.taskId00, this.taskId01);
        this.makeTaskFolders(new String[0]);
        this.expectLockObtainedFor(new TaskId[0]);
        EasyMock.replay((Object[])new Object[]{this.stateDirectory});
        this.taskManager.handleRebalanceStart(Collections.emptySet());
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01})));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleLostAll();
        MatcherAssert.assertThat((Object)task00.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.is(Collections.singletonMap(this.taskId01, task01)));
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01})));
        this.taskManager.handleRebalanceStart(Collections.emptySet());
        MatcherAssert.assertThat((Object)this.taskManager.lockedTaskDirectories(), (Matcher)Matchers.is(Collections.emptySet()));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
    }

    @Test
    public void shouldReInitializeThreadProducerOnHandleLostAllIfEosV2Enabled() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, false);
        taskManager.handleLostAll();
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).reInitializeThreadProducer();
    }

    @Test
    public void shouldThrowWhenHandlingClosingTasksOnProducerCloseError() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("KABOOM!")}).when((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Encounter unexpected fatal error for task 0_0"));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
    }

    @Test
    public void shouldReAddRevivedTasksToStateUpdater() {
        StreamTask corruptedActiveTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId03, this.taskId03ChangelogPartitions).inState(Task.State.RESTORING).withInputPartitions(this.taskId03Partitions).build();
        StandbyTask corruptedStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).withInputPartitions(this.taskId02Partitions).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)tasks.task(this.taskId03)).thenReturn((Object)corruptedActiveTask);
        Mockito.when((Object)tasks.task(this.taskId02)).thenReturn((Object)corruptedStandbyTask);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet());
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleCorruption(Utils.mkSet((Object[])new TaskId[]{corruptedActiveTask.id(), corruptedStandbyTask.id()}));
        InOrder activeTaskOrder = Mockito.inOrder((Object[])new Object[]{corruptedActiveTask});
        ((StreamTask)activeTaskOrder.verify((Object)corruptedActiveTask)).closeDirty();
        ((StreamTask)activeTaskOrder.verify((Object)corruptedActiveTask)).revive();
        InOrder standbyTaskOrder = Mockito.inOrder((Object[])new Object[]{corruptedStandbyTask});
        ((StandbyTask)standbyTaskOrder.verify((Object)corruptedStandbyTask)).closeDirty();
        ((StandbyTask)standbyTaskOrder.verify((Object)corruptedStandbyTask)).revive();
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)corruptedActiveTask);
        ((TasksRegistry)Mockito.verify((Object)tasks)).removeTask((Task)corruptedStandbyTask);
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)Utils.mkSet((Object[])new Task[]{corruptedActiveTask}));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addPendingTasksToInit((Collection)Utils.mkSet((Object[])new Task[]{corruptedStandbyTask}));
    }

    @Test
    public void shouldReviveCorruptTasks() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        final AtomicBoolean enforcedCheckpoint = new AtomicBoolean(false);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager){

            @Override
            public void postCommit(boolean enforceCheckpoint) {
                if (enforceCheckpoint) {
                    enforcedCheckpoint.set(true);
                }
                super.postCommit(enforceCheckpoint);
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(this.taskId00Partitions);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), tp -> MatcherAssert.assertThat((Object)tp, (Matcher)Matchers.is((Matcher)Matchers.empty()))), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)task00.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task00.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(this.taskId00Partitions));
        MatcherAssert.assertThat((Object)enforcedCheckpoint.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.is(Collections.singletonMap(this.taskId00, task00)));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldReviveCorruptTasksEvenIfTheyCannotCloseClean() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("oops");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(this.taskId00Partitions);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), tp -> MatcherAssert.assertThat((Object)tp, (Matcher)Matchers.is((Matcher)Matchers.empty()))), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)task00.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task00.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(this.taskId00Partitions));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.is(Collections.singletonMap(this.taskId00, task00)));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldCommitNonCorruptedTasksOnTaskCorruptedException() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask corruptedTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager);
        StateMachineTask nonCorruptedTask = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager);
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{corruptedTask, nonCorruptedTask}));
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(this.taskId00Partitions);
        this.consumer.commitSync((Map)EasyMock.eq(Collections.emptyMap()));
        EasyMock.expectLastCall().andStubThrow((Throwable)((Object)new AssertionError((Object)"should not invoke commitSync when offset map is empty")));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), tp -> MatcherAssert.assertThat((Object)tp, (Matcher)Matchers.is((Matcher)Matchers.empty()))), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)nonCorruptedTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        nonCorruptedTask.setCommitNeeded();
        corruptedTask.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        Assert.assertTrue((boolean)nonCorruptedTask.commitPrepared);
        MatcherAssert.assertThat((Object)nonCorruptedTask.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(Collections.emptySet()));
        MatcherAssert.assertThat((Object)corruptedTask.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(this.taskId00Partitions));
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldNotCommitNonRunningNonCorruptedTasks() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask corruptedTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager);
        StateMachineTask nonRunningNonCorruptedTask = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager);
        nonRunningNonCorruptedTask.setCommitNeeded();
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{corruptedTask, nonRunningNonCorruptedTask}));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(this.taskId00Partitions);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        corruptedTask.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)nonRunningNonCorruptedTask.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)nonRunningNonCorruptedTask.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(Collections.emptySet()));
        MatcherAssert.assertThat((Object)corruptedTask.partitionsForOffsetReset, (Matcher)IsEqual.equalTo(this.taskId00Partitions));
        Assert.assertFalse((boolean)nonRunningNonCorruptedTask.commitPrepared);
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldNotCommitNonCorruptedRestoringActiveTasksAndNotCommitRunningStandbyTasksWithStateUpdaterEnabled() {
        StreamTask activeRestoringTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        StreamTask corruptedTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).withInputPartitions(this.taskId02Partitions).inState(Task.State.RUNNING).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId02, (Object)corruptedTask)}));
        Mockito.when((Object)tasks.task(this.taskId02)).thenReturn((Object)corruptedTask);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        Mockito.when((Object)this.stateUpdater.getTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{activeRestoringTask, standbyTask}));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn((Object)Utils.intersection(HashSet::new, this.taskId00Partitions, (Set[])new Set[]{this.taskId01Partitions, this.taskId02Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleCorruption(Utils.mkSet((Object[])new TaskId[]{this.taskId02}));
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).commitNeeded();
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).prepareCommit();
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).postCommit(Mockito.anyBoolean());
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).commitNeeded();
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).prepareCommit();
        ((StandbyTask)Mockito.verify((Object)standbyTask, (VerificationMode)Mockito.never())).postCommit(Mockito.anyBoolean());
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldNotCommitNonCorruptedRestoringActiveTasksAndCommitRunningStandbyTasksWithStateUpdaterDisabled() {
        StreamTask activeRestoringTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId00, this.taskId00ChangelogPartitions).withInputPartitions(this.taskId00Partitions).inState(Task.State.RESTORING).build();
        StandbyTask standbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId01, this.taskId01ChangelogPartitions).withInputPartitions(this.taskId01Partitions).inState(Task.State.RUNNING).build();
        Mockito.when((Object)standbyTask.commitNeeded()).thenReturn((Object)true);
        StreamTask corruptedTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).withInputPartitions(this.taskId02Partitions).inState(Task.State.RUNNING).build();
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        Mockito.when((Object)tasks.allTasksPerId()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)activeRestoringTask), Utils.mkEntry((Object)this.taskId01, (Object)standbyTask), Utils.mkEntry((Object)this.taskId02, (Object)corruptedTask)}));
        Mockito.when((Object)tasks.task(this.taskId02)).thenReturn((Object)corruptedTask);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, false);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn((Object)Utils.intersection(HashSet::new, this.taskId00Partitions, (Set[])new Set[]{this.taskId01Partitions, this.taskId02Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleCorruption(Utils.mkSet((Object[])new TaskId[]{this.taskId02}));
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).commitNeeded();
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).prepareCommit();
        ((StreamTask)Mockito.verify((Object)activeRestoringTask, (VerificationMode)Mockito.never())).postCommit(Mockito.anyBoolean());
        ((StandbyTask)Mockito.verify((Object)standbyTask)).prepareCommit();
        ((StandbyTask)Mockito.verify((Object)standbyTask)).postCommit(Mockito.anyBoolean());
    }

    @Test
    public void shouldCleanAndReviveCorruptedStandbyTasksBeforeCommittingNonCorruptedTasks() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask corruptedStandby = new StateMachineTask(this.taskId00, this.taskId00Partitions, false, stateManager);
        StateMachineTask runningNonCorruptedActive = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager){

            @Override
            public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
                throw new TaskMigratedException("You dropped out of the group!", (Throwable)new RuntimeException());
            }
        };
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId01Assignment))).thenReturn(Collections.singleton(runningNonCorruptedActive));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId00Assignment)).thenReturn(Collections.singleton(corruptedStandby));
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId01Assignment, this.taskId00Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)runningNonCorruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)corruptedStandby.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        runningNonCorruptedActive.setCommitNeeded();
        corruptedStandby.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        Assert.assertThrows(TaskMigratedException.class, () -> this.taskManager.handleCorruption(Collections.singleton(this.taskId00)));
        MatcherAssert.assertThat((Object)corruptedStandby.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedStandby.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldNotAttemptToCommitInHandleCorruptedDuringARebalance() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        EasyMock.expect((Object)this.stateDirectory.listNonEmptyTaskDirectories()).andStubReturn(new ArrayList());
        StateMachineTask corruptedActive = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager);
        StateMachineTask uncorruptedActive = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        uncorruptedActive.setCommitNeeded();
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>();
        assignment.putAll(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{corruptedActive, uncorruptedActive}));
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        EasyMock.expect((Object)this.consumer.assignment()).andStubReturn((Object)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer, this.stateDirectory});
        uncorruptedActive.setCommittableOffsetsAndMetadata(offsets);
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitCompleted, (Matcher)Matchers.is((Object)false));
        this.taskManager.handleRebalanceStart(Collections.singleton("topic1"));
        MatcherAssert.assertThat((Object)this.taskManager.rebalanceInProgress(), (Matcher)Matchers.is((Object)true));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitCompleted, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldCloseAndReviveUncorruptedTasksWhenTimeoutExceptionThrownFromCommitWithALOS() {
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask corruptedActive = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager);
        StateMachineTask uncorruptedActive = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager){

            public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
                Assert.fail((String)"Should not try to mark changelogs as corrupted for uncorrupted task");
            }
        };
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        uncorruptedActive.setCommittableOffsetsAndMetadata(offsets);
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>();
        assignment.putAll(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{corruptedActive, uncorruptedActive}));
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException());
        EasyMock.expect((Object)this.consumer.assignment()).andStubReturn((Object)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)corruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        uncorruptedActive.setCommitNeeded();
        corruptedActive.setChangelogOffsets(Collections.singletonMap(this.t1p0, 0L));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitCompleted, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActive.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActive.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActive.commitCompleted, (Matcher)Matchers.is((Object)false));
        this.taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActive.commitCompleted, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActive.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedActive.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActive.commitCompleted, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)uncorruptedActive.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00Partitions);
    }

    @Test
    public void shouldCloseAndReviveUncorruptedTasksWhenTimeoutExceptionThrownFromCommitDuringHandleCorruptedWithEOS() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, false);
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.threadProducer()).thenReturn((Object)producer);
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        final AtomicBoolean corruptedTaskChangelogMarkedAsCorrupted = new AtomicBoolean(false);
        StateMachineTask corruptedActiveTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager){

            public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
                super.markChangelogAsCorrupted(partitions);
                corruptedTaskChangelogMarkedAsCorrupted.set(true);
            }
        };
        final AtomicBoolean uncorruptedTaskChangelogMarkedAsCorrupted = new AtomicBoolean(false);
        StateMachineTask uncorruptedActiveTask = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager){

            public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
                super.markChangelogAsCorrupted(partitions);
                uncorruptedTaskChangelogMarkedAsCorrupted.set(true);
            }
        };
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        uncorruptedActiveTask.setCommittableOffsetsAndMetadata(offsets);
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>();
        assignment.putAll(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{corruptedActiveTask, uncorruptedActiveTask}));
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata("appId");
        EasyMock.expect((Object)this.consumer.groupMetadata()).andReturn((Object)groupMetadata);
        ((StreamsProducer)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException()}).when((Object)producer)).commitTransaction(offsets, groupMetadata);
        EasyMock.expect((Object)this.consumer.assignment()).andStubReturn((Object)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)corruptedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        uncorruptedActiveTask.setCommitNeeded();
        Map<TopicPartition, Long> corruptedActiveTaskChangelogOffsets = Collections.singletonMap(this.t1p0changelog, 0L);
        corruptedActiveTask.setChangelogOffsets(corruptedActiveTaskChangelogOffsets);
        Map<TopicPartition, Long> uncorruptedActiveTaskChangelogOffsets = Collections.singletonMap(this.t1p1changelog, 0L);
        uncorruptedActiveTask.setChangelogOffsets(uncorruptedActiveTaskChangelogOffsets);
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitCompleted, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitCompleted, (Matcher)Matchers.is((Object)false));
        taskManager.handleCorruption(Collections.singleton(this.taskId00));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.commitCompleted, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)corruptedActiveTask.commitCompleted, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corruptedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)uncorruptedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)corruptedTaskChangelogMarkedAsCorrupted.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)uncorruptedTaskChangelogMarkedAsCorrupted.get(), (Matcher)Matchers.is((Object)true));
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00ChangelogPartitions);
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId01ChangelogPartitions);
    }

    @Test
    public void shouldCloseAndReviveUncorruptedTasksWhenTimeoutExceptionThrownFromCommitDuringRevocationWithALOS() {
        StateMachineTask revokedActiveTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        revokedActiveTask.setCommittableOffsetsAndMetadata(offsets00);
        revokedActiveTask.setCommitNeeded();
        StateMachineTask unrevokedActiveTaskWithCommitNeeded = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
                Assert.fail((String)"Should not try to mark changelogs as corrupted for uncorrupted task");
            }
        };
        Map<TopicPartition, OffsetAndMetadata> offsets01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        unrevokedActiveTaskWithCommitNeeded.setCommittableOffsetsAndMetadata(offsets01);
        unrevokedActiveTaskWithCommitNeeded.setCommitNeeded();
        StateMachineTask unrevokedActiveTaskWithoutCommitNeeded = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        HashMap<TopicPartition, OffsetAndMetadata> expectedCommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        expectedCommittedOffsets.putAll(offsets00);
        expectedCommittedOffsets.putAll(offsets01);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{revokedActiveTask, unrevokedActiveTaskWithCommitNeeded, unrevokedActiveTaskWithoutCommitNeeded}));
        EasyMock.expectLastCall();
        this.consumer.commitSync(expectedCommittedOffsets);
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException());
        EasyMock.expect((Object)this.consumer.assignment()).andStubReturn((Object)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions, this.taskId02Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)revokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithoutCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)revokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithoutCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
    }

    @Test
    public void shouldCloseAndReviveUncorruptedTasksWhenTimeoutExceptionThrownFromCommitDuringRevocationWithEOS() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, false);
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.threadProducer()).thenReturn((Object)producer);
        ProcessorStateManager stateManager = (ProcessorStateManager)Mockito.mock(ProcessorStateManager.class);
        StateMachineTask revokedActiveTask = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, stateManager);
        Map<TopicPartition, OffsetAndMetadata> revokedActiveTaskOffsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        revokedActiveTask.setCommittableOffsetsAndMetadata(revokedActiveTaskOffsets);
        revokedActiveTask.setCommitNeeded();
        final AtomicBoolean unrevokedTaskChangelogMarkedAsCorrupted = new AtomicBoolean(false);
        StateMachineTask unrevokedActiveTask = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, stateManager){

            public void markChangelogAsCorrupted(Collection<TopicPartition> partitions) {
                super.markChangelogAsCorrupted(partitions);
                unrevokedTaskChangelogMarkedAsCorrupted.set(true);
            }
        };
        Map<TopicPartition, OffsetAndMetadata> unrevokedTaskOffsets = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        unrevokedActiveTask.setCommittableOffsetsAndMetadata(unrevokedTaskOffsets);
        unrevokedActiveTask.setCommitNeeded();
        StateMachineTask unrevokedActiveTaskWithoutCommitNeeded = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, stateManager);
        HashMap<TopicPartition, OffsetAndMetadata> expectedCommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        expectedCommittedOffsets.putAll(revokedActiveTaskOffsets);
        expectedCommittedOffsets.putAll(unrevokedTaskOffsets);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{revokedActiveTask, unrevokedActiveTask, unrevokedActiveTaskWithoutCommitNeeded}));
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata("appId");
        EasyMock.expect((Object)this.consumer.groupMetadata()).andReturn((Object)groupMetadata);
        ((StreamsProducer)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException()}).when((Object)producer)).commitTransaction(expectedCommittedOffsets, groupMetadata);
        EasyMock.expect((Object)this.consumer.assignment()).andStubReturn((Object)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId00Partitions, this.taskId01Partitions, this.taskId02Partitions}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleAssignment(assignmentActive, Collections.emptyMap());
        MatcherAssert.assertThat((Object)taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)revokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)unrevokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithoutCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Map<TopicPartition, Long> revokedActiveTaskChangelogOffsets = Collections.singletonMap(this.t1p0changelog, 0L);
        revokedActiveTask.setChangelogOffsets(revokedActiveTaskChangelogOffsets);
        Map<TopicPartition, Long> unrevokedActiveTaskChangelogOffsets = Collections.singletonMap(this.t1p1changelog, 0L);
        unrevokedActiveTask.setChangelogOffsets(unrevokedActiveTaskChangelogOffsets);
        taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)unrevokedTaskChangelogMarkedAsCorrupted.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)revokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        MatcherAssert.assertThat((Object)unrevokedActiveTask.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)unrevokedActiveTaskWithoutCommitNeeded.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId00ChangelogPartitions);
        ((ProcessorStateManager)Mockito.verify((Object)stateManager)).markChangelogAsCorrupted(this.taskId01ChangelogPartitions);
    }

    @Test
    public void shouldCloseStandbyUnassignedTasksWhenCreatingNewTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId00Assignment)).thenReturn(Collections.singletonList(task00));
        this.consumer.commitSync(Collections.emptyMap());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId00Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
    }

    @Test
    public void shouldAddNonResumedSuspendedTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleAssignment(this.taskId00Assignment, this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(Collections.emptyMap()));
    }

    @Test
    public void shouldUpdateInputPartitionsAfterRebalance() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Set newPartitionsSet = Utils.mkSet((Object[])new TopicPartition[]{this.t1p1});
        Map<TaskId, Set> taskIdSetMap = Collections.singletonMap(this.taskId00, newPartitionsSet);
        this.taskManager.handleAssignment(taskIdSetMap, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Assert.assertEquals((Object)newPartitionsSet, (Object)task00.inputPartitions());
        EasyMock.verify((Object[])new Object[]{this.consumer});
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(Collections.emptyMap()));
    }

    @Test
    public void shouldAddNewActiveTasks() {
        Map<TaskId, Set<TopicPartition>> assignment = this.taskId00Assignment;
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet());
        this.consumer.resume((Collection)EasyMock.eq(Collections.emptySet()));
        EasyMock.expectLastCall();
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), noOpResetter -> {});
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo(Collections.singletonMap(this.taskId00, task00)));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
    }

    @Test
    public void shouldNotCompleteRestorationIfTasksCannotInitialize() {
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public void initializeIfNeeded() {
                throw new LockException("can't lock");
            }
        };
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            @Override
            public void initializeIfNeeded() {
                throw new TimeoutException("timed out");
            }
        };
        this.consumer.commitSync(Collections.emptyMap());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet());
        this.consumer.resume((Collection)EasyMock.eq(Collections.emptySet()));
        EasyMock.expectLastCall();
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Arrays.asList(new Task[]{task00, task01}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00)), Utils.mkEntry((Object)this.taskId01, (Object)((Object)task01))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
    }

    @Test
    public void shouldNotCompleteRestorationIfTaskCannotCompleteRestoration() {
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public void completeRestoration(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
                throw new TimeoutException("timeout!");
            }
        };
        this.consumer.commitSync(Collections.emptyMap());
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet());
        this.consumer.resume((Collection)EasyMock.eq(Collections.emptySet()));
        EasyMock.expectLastCall();
        EasyMock.expectLastCall();
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
    }

    @Test
    public void shouldSuspendActiveTasksDuringRevocation() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
    }

    @Test
    public void shouldCommitAllActiveTasksThatNeedCommittingOnHandleRevocationWithEosV2() {
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, false);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets00);
        task00.setCommitNeeded();
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        task01.setCommittableOffsetsAndMetadata(offsets01);
        task01.setCommitNeeded();
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets02 = Collections.singletonMap(this.t1p2, new OffsetAndMetadata(2L, null));
        task02.setCommittableOffsetsAndMetadata(offsets02);
        StateMachineTask task10 = new StateMachineTask(this.taskId10, this.taskId10Partitions, false, this.stateManager);
        HashMap<TopicPartition, OffsetAndMetadata> expectedCommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        expectedCommittedOffsets.putAll(offsets00);
        expectedCommittedOffsets.putAll(offsets01);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        Map assignmentStandby = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId10, this.taskId10Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02}));
        Mockito.when((Object)this.activeTaskCreator.threadProducer()).thenReturn((Object)producer);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Collections.singletonList(task10));
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata("appId");
        EasyMock.expect((Object)this.consumer.groupMetadata()).andReturn((Object)groupMetadata);
        producer.commitTransaction(expectedCommittedOffsets, groupMetadata);
        EasyMock.expectLastCall();
        task00.committedOffsets();
        EasyMock.expectLastCall();
        task01.committedOffsets();
        EasyMock.expectLastCall();
        task02.committedOffsets();
        EasyMock.expectLastCall();
        task10.committedOffsets();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task10.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task01.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task02.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task10.commitPrepared, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldCommitAllNeededTasksOnHandleRevocation() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets00);
        task00.setCommitNeeded();
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        task01.setCommittableOffsetsAndMetadata(offsets01);
        task01.setCommitNeeded();
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets02 = Collections.singletonMap(this.t1p2, new OffsetAndMetadata(2L, null));
        task02.setCommittableOffsetsAndMetadata(offsets02);
        StateMachineTask task10 = new StateMachineTask(this.taskId10, this.taskId10Partitions, false, this.stateManager);
        HashMap<TopicPartition, OffsetAndMetadata> expectedCommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        expectedCommittedOffsets.putAll(offsets00);
        expectedCommittedOffsets.putAll(offsets01);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        Map assignmentStandby = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId10, this.taskId10Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02}));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Collections.singletonList(task10));
        this.consumer.commitSync(expectedCommittedOffsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task10.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task00.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task01.commitPrepared, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task02.commitPrepared, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task10.commitPrepared, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotCommitOnHandleAssignmentIfNoTaskClosed() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets00);
        task00.setCommitNeeded();
        StateMachineTask task10 = new StateMachineTask(this.taskId10, this.taskId10Partitions, false, this.stateManager);
        Map<TaskId, Set<TopicPartition>> assignmentActive = Collections.singletonMap(this.taskId00, this.taskId00Partitions);
        Map<TaskId, Set<TopicPartition>> assignmentStandby = Collections.singletonMap(this.taskId10, this.taskId10Partitions);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignmentActive))).thenReturn(Collections.singleton(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Collections.singletonList(task10));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task10.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task10.commitPrepared, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotCommitOnHandleAssignmentIfOnlyStandbyTaskClosed() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets00);
        task00.setCommitNeeded();
        StateMachineTask task10 = new StateMachineTask(this.taskId10, this.taskId10Partitions, false, this.stateManager);
        Map<TaskId, Set<TopicPartition>> assignmentActive = Collections.singletonMap(this.taskId00, this.taskId00Partitions);
        Map<TaskId, Set<TopicPartition>> assignmentStandby = Collections.singletonMap(this.taskId10, this.taskId10Partitions);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignmentActive))).thenReturn(Collections.singleton(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Collections.singletonList(task10));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task10.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        this.taskManager.handleAssignment(assignmentActive, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldNotCommitCreatedTasksOnRevocationOrClosure() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.handleRevocation(this.taskId00Partitions);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded((TaskId)EasyMock.eq((Object)this.taskId00));
    }

    @Test
    public void shouldPassUpIfExceptionDuringSuspend() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("KABOOM!");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleRevocation(this.taskId00Partitions));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldCloseActiveTasksAndPropagateExceptionsOnCleanShutdown() {
        final TopicPartition changelog = new TopicPartition("changelog", 0);
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions), Utils.mkEntry((Object)this.taskId03, this.taskId03Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Set<TopicPartition> changelogPartitions() {
                return Collections.singleton(changelog);
            }
        };
        final AtomicBoolean closedDirtyTask01 = new AtomicBoolean(false);
        final AtomicBoolean closedDirtyTask02 = new AtomicBoolean(false);
        final AtomicBoolean closedDirtyTask03 = new AtomicBoolean(false);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("migrated", (Throwable)new RuntimeException("cause"));
            }

            @Override
            public void closeDirty() {
                super.closeDirty();
                closedDirtyTask01.set(true);
            }
        };
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("oops");
            }

            @Override
            public void closeDirty() {
                super.closeDirty();
                closedDirtyTask02.set(true);
            }
        };
        StateMachineTask task03 = new StateMachineTask(this.taskId03, this.taskId03Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("oops");
            }

            @Override
            public void closeDirty() {
                super.closeDirty();
                closedDirtyTask03.set(true);
            }
        };
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02, task03}));
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task03.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task03.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00)), Utils.mkEntry((Object)this.taskId01, (Object)((Object)task01)), Utils.mkEntry((Object)this.taskId02, (Object)((Object)task02)), Utils.mkEntry((Object)this.taskId03, (Object)((Object)task03))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).completedChangelogs();
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.shutdown(true));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.is((Object)"oops"));
        MatcherAssert.assertThat((Object)closedDirtyTask01.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)closedDirtyTask02.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)closedDirtyTask03.get(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task03.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator, (VerificationMode)Mockito.times((int)4))).closeAndRemoveTaskProducerIfNeeded((TaskId)ArgumentMatchers.any());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
    }

    @Test
    public void shouldCloseActiveTasksAndPropagateTaskProducerExceptionsOnCleanShutdown() {
        final TopicPartition changelog = new TopicPartition("changelog", 0);
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Set<TopicPartition> changelogPartitions() {
                return Collections.singleton(changelog);
            }
        };
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Collections.singletonList(task00));
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("whatever")}).when((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).completedChangelogs();
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.shutdown(true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.is((Object)"whatever"));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
    }

    @Test
    public void shouldCloseActiveTasksAndPropagateThreadProducerExceptionsOnCleanShutdown() {
        final TopicPartition changelog = new TopicPartition("changelog", 0);
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Set<TopicPartition> changelogPartitions() {
                return Collections.singleton(changelog);
            }
        };
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Collections.singletonList(task00));
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("whatever")}).when((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).completedChangelogs();
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.shutdown(true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"whatever"));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
    }

    @Test
    public void shouldOnlyCommitRevokedStandbyTaskAndPropagatePrepareCommitException() {
        this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA, false);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, false, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager){

            @Override
            public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
                throw new RuntimeException("task 0_1 prepare commit boom!");
            }
        };
        task01.setCommitNeeded();
        this.taskManager.addTask((Task)task00);
        this.taskManager.addTask((Task)task01);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.singletonMap(this.taskId00, this.taskId00Partitions)));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)Matchers.is((Object)"task 0_1 prepare commit boom!"));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.allTasks(), (Matcher)Matchers.is(Collections.singletonMap(this.taskId00, task00)));
    }

    @Test
    public void shouldSuspendAllRevokedActiveTasksAndPropagateSuspendException() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("task 0_1 suspend boom!");
            }
        };
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        this.taskManager.addTask((Task)task00);
        this.taskManager.addTask((Task)task01);
        this.taskManager.addTask((Task)task02);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleRevocation((Collection)Utils.union(HashSet::new, (Set[])new Set[]{this.taskId01Partitions, this.taskId02Partitions})));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)Matchers.is((Object)"task 0_1 suspend boom!"));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.activeTaskCreator});
    }

    @Test
    public void shouldCloseActiveTasksAndIgnoreExceptionsOnUncleanShutdown() {
        final TopicPartition changelog = new TopicPartition("changelog", 0);
        Map assignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Set<TopicPartition> changelogPartitions() {
                return Collections.singleton(changelog);
            }
        };
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("migrated", (Throwable)new RuntimeException("cause"));
            }
        };
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("oops");
            }
        };
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignment))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02}));
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("whatever")}).when((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded((TaskId)Mockito.any());
        ((ActiveTaskCreator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("whatever all")}).when((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, (Object)((Object)task00)), Utils.mkEntry((Object)this.taskId01, (Object)((Object)task01)), Utils.mkEntry((Object)this.taskId02, (Object)((Object)task02))})));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).enforceRestoreActive();
        ((ChangelogReader)Mockito.verify((Object)this.changeLogReader)).completedChangelogs();
        this.taskManager.shutdown(false);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator, (VerificationMode)Mockito.times((int)3))).closeAndRemoveTaskProducerIfNeeded((TaskId)ArgumentMatchers.any());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
    }

    @Test
    public void shouldCloseStandbyTasksOnShutdown() {
        Map<TaskId, Set<TopicPartition>> assignment = Collections.singletonMap(this.taskId00, this.taskId00Partitions);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, false, this.stateManager);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignment)).thenReturn(Collections.singletonList(task00));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(Collections.emptySet());
        this.consumer.resume((Collection)EasyMock.eq(Collections.emptySet()));
        EasyMock.expectLastCall();
        this.consumer.commitSync(Collections.emptyMap());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), assignment);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.equalTo(Collections.singletonMap(this.taskId00, task00)));
        this.taskManager.shutdown(true);
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.CLOSED));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
    }

    @Test
    public void shouldShutDownStateUpdaterAndCloseFailedTasksDirty() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        StreamTask failedStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).build();
        StandbyTask failedStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).build();
        Mockito.when((Object)this.stateUpdater.drainExceptionsAndFailedTasks()).thenReturn(Arrays.asList(new StateUpdater.ExceptionAndTasks(Utils.mkSet((Object[])new Task[]{failedStatefulTask}), new RuntimeException()), new StateUpdater.ExceptionAndTasks(Utils.mkSet((Object[])new Task[]{failedStandbyTask}), new RuntimeException())));
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.shutdown(true);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(failedStatefulTask.id());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).shutdown(Duration.ofMillis(Long.MAX_VALUE));
        ((StreamTask)Mockito.verify((Object)failedStatefulTask)).prepareCommit();
        ((StreamTask)Mockito.verify((Object)failedStatefulTask)).suspend();
        ((StreamTask)Mockito.verify((Object)failedStatefulTask)).closeDirty();
    }

    @Test
    public void shouldShutdownSchedulingTaskManager() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true, true);
        taskManager.shutdown(true);
        ((DefaultTaskManager)Mockito.verify((Object)this.schedulingTaskManager)).shutdown(Duration.ofMillis(Long.MAX_VALUE));
    }

    @Test
    public void shouldShutDownStateUpdaterAndAddRestoredTasksToTaskRegistry() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        StreamTask statefulTask1 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).build();
        StreamTask statefulTask2 = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RESTORING).build();
        Set restoredActiveTasks = Utils.mkSet((Object[])new StreamTask[]{statefulTask1, statefulTask2});
        Set restoredTasks = restoredActiveTasks.stream().map(t -> t).collect(Collectors.toSet());
        Mockito.when((Object)this.stateUpdater.drainRestoredActiveTasks(Duration.ZERO)).thenReturn((Object)restoredActiveTasks);
        Mockito.when((Object)tasks.activeTasks()).thenReturn(restoredTasks);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.shutdown(true);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(statefulTask1.id());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(statefulTask2.id());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).shutdown(Duration.ofMillis(Long.MAX_VALUE));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addActiveTasks(restoredTasks);
        ((StreamTask)Mockito.verify((Object)statefulTask1)).closeClean();
        ((StreamTask)Mockito.verify((Object)statefulTask2)).closeClean();
    }

    @Test
    public void shouldShutDownStateUpdaterAndAddRemovedTasksToTaskRegistry() {
        TasksRegistry tasks = (TasksRegistry)Mockito.mock(TasksRegistry.class);
        StreamTask removedStatefulTask = StreamsTestUtils.TaskBuilder.statefulTask(this.taskId01, this.taskId01ChangelogPartitions).inState(Task.State.RESTORING).build();
        StandbyTask removedStandbyTask = StreamsTestUtils.TaskBuilder.standbyTask(this.taskId02, this.taskId02ChangelogPartitions).inState(Task.State.RUNNING).build();
        Mockito.when((Object)this.stateUpdater.drainRemovedTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{removedStandbyTask, removedStatefulTask}));
        Mockito.when((Object)tasks.activeTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{removedStatefulTask}));
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{removedStatefulTask, removedStandbyTask}));
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.AT_LEAST_ONCE, tasks, true);
        taskManager.shutdown(true);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(removedStatefulTask.id());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeThreadProducerIfNeeded();
        ((StateUpdater)Mockito.verify((Object)this.stateUpdater)).shutdown(Duration.ofMillis(Long.MAX_VALUE));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addActiveTasks((Collection)Utils.mkSet((Object[])new Task[]{removedStatefulTask}));
        ((TasksRegistry)Mockito.verify((Object)tasks)).addStandbyTasks((Collection)Utils.mkSet((Object[])new Task[]{removedStandbyTask}));
        ((StreamTask)Mockito.verify((Object)removedStatefulTask)).closeClean();
        ((StandbyTask)Mockito.verify((Object)removedStandbyTask)).closeClean();
    }

    @Test
    public void shouldInitializeNewActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.equalTo(Collections.singletonMap(this.taskId00, task00)));
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.anEmptyMap());
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldInitialiseNewStandbyTasks() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.activeTaskMap(), (Matcher)Matchers.anEmptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.standbyTaskMap(), (Matcher)Matchers.equalTo(Collections.singletonMap(this.taskId01, task01)));
    }

    @Test
    public void shouldHandleRebalanceEvents() {
        Set<TopicPartition> assignment = Collections.singleton(new TopicPartition("assignment", 0));
        EasyMock.expect((Object)this.consumer.assignment()).andReturn(assignment);
        this.consumer.pause(assignment);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.stateDirectory.listNonEmptyTaskDirectories()).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{this.consumer, this.stateDirectory});
        MatcherAssert.assertThat((Object)this.taskManager.rebalanceInProgress(), (Matcher)Matchers.is((Object)false));
        this.taskManager.handleRebalanceStart(Collections.emptySet());
        MatcherAssert.assertThat((Object)this.taskManager.rebalanceInProgress(), (Matcher)Matchers.is((Object)true));
        this.taskManager.handleRebalanceComplete();
        MatcherAssert.assertThat((Object)this.taskManager.rebalanceInProgress(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldCommitActiveAndStandbyTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        task01.setCommitNeeded();
        MatcherAssert.assertThat((Object)this.taskManager.commitAll(), (Matcher)IsEqual.equalTo((Object)2));
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task01.commitNeeded, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldCommitProvidedTasksIfNeeded() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        StateMachineTask task03 = new StateMachineTask(this.taskId03, this.taskId03Partitions, false, this.stateManager);
        StateMachineTask task04 = new StateMachineTask(this.taskId04, this.taskId04Partitions, false, this.stateManager);
        StateMachineTask task05 = new StateMachineTask(this.taskId05, this.taskId05Partitions, false, this.stateManager);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions)});
        Map assignmentStandby = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId03, this.taskId03Partitions), Utils.mkEntry((Object)this.taskId04, this.taskId04Partitions), Utils.mkEntry((Object)this.taskId05, this.taskId05Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02}));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Arrays.asList(new Task[]{task03, task04, task05}));
        this.consumer.commitSync((Map)EasyMock.eq(Collections.emptyMap()));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        task01.setCommitNeeded();
        task03.setCommitNeeded();
        task04.setCommitNeeded();
        MatcherAssert.assertThat((Object)this.taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task00, task02, task03, task05})), (Matcher)IsEqual.equalTo((Object)2));
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task01.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task02.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task03.commitNeeded, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task04.commitNeeded, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task05.commitNeeded, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotCommitOffsetsIfOnlyStandbyTasksAssigned() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, false, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId00Assignment)).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId00Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        MatcherAssert.assertThat((Object)this.taskManager.commitAll(), (Matcher)IsEqual.equalTo((Object)1));
        MatcherAssert.assertThat((Object)task00.commitNeeded, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldNotCommitActiveAndStandbyTasksWhileRebalanceInProgress() throws Exception {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager);
        this.makeTaskFolders(this.taskId00.toString(), this.taskId01.toString());
        this.expectDirectoryNotEmpty(this.taskId00, this.taskId01);
        this.expectLockObtainedFor(this.taskId00, this.taskId01);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        EasyMock.replay((Object[])new Object[]{this.stateDirectory, this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        task01.setCommitNeeded();
        this.taskManager.handleRebalanceStart(Collections.emptySet());
        MatcherAssert.assertThat((Object)this.taskManager.commitAll(), (Matcher)IsEqual.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)this.taskManager.maybeCommitActiveTasksPerUserRequested(), (Matcher)IsEqual.equalTo((Object)-1));
    }

    @Test
    public void shouldCommitViaConsumerIfEosDisabled() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        task01.setCommittableOffsetsAndMetadata(offsets);
        task01.setCommitNeeded();
        this.taskManager.addTask((Task)task01);
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.commitAll();
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldCommitViaProducerIfEosAlphaEnabled() {
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.streamsProducerForTask((TaskId)ArgumentMatchers.any(TaskId.class))).thenReturn((Object)producer);
        Map<TopicPartition, OffsetAndMetadata> offsetsT01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        Map<TopicPartition, OffsetAndMetadata> offsetsT02 = Collections.singletonMap(this.t1p2, new OffsetAndMetadata(1L, null));
        this.shouldCommitViaProducerIfEosEnabled(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA, offsetsT01, offsetsT02);
        ((StreamsProducer)Mockito.verify((Object)producer)).commitTransaction(offsetsT01, new ConsumerGroupMetadata("appId"));
        ((StreamsProducer)Mockito.verify((Object)producer)).commitTransaction(offsetsT02, new ConsumerGroupMetadata("appId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{producer});
    }

    @Test
    public void shouldCommitViaProducerIfEosV2Enabled() {
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.threadProducer()).thenReturn((Object)producer);
        Map<TopicPartition, OffsetAndMetadata> offsetsT01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(0L, null));
        Map<TopicPartition, OffsetAndMetadata> offsetsT02 = Collections.singletonMap(this.t1p2, new OffsetAndMetadata(1L, null));
        HashMap<TopicPartition, OffsetAndMetadata> allOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        allOffsets.putAll(offsetsT01);
        allOffsets.putAll(offsetsT02);
        this.shouldCommitViaProducerIfEosEnabled(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, offsetsT01, offsetsT02);
        ((StreamsProducer)Mockito.verify((Object)producer)).commitTransaction(allOffsets, new ConsumerGroupMetadata("appId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{producer});
    }

    private void shouldCommitViaProducerIfEosEnabled(StreamsConfigUtils.ProcessingMode processingMode, Map<TopicPartition, OffsetAndMetadata> offsetsT01, Map<TopicPartition, OffsetAndMetadata> offsetsT02) {
        TaskManager taskManager = this.setUpTaskManager(processingMode, false);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        task01.setCommittableOffsetsAndMetadata(offsetsT01);
        task01.setCommitNeeded();
        taskManager.addTask((Task)task01);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        task02.setCommittableOffsetsAndMetadata(offsetsT02);
        task02.setCommitNeeded();
        taskManager.addTask((Task)task02);
        EasyMock.reset((Object[])new Object[]{this.consumer});
        EasyMock.expect((Object)this.consumer.groupMetadata()).andStubReturn((Object)new ConsumerGroupMetadata("appId"));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        taskManager.commitAll();
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldPropagateExceptionFromActiveCommit() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
                throw new RuntimeException("opsh.");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.commitAll());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"opsh."));
    }

    @Test
    public void shouldPropagateExceptionFromStandbyCommit() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager){

            @Override
            public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
                throw new RuntimeException("opsh.");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId01Assignment)).thenReturn(Collections.singletonList(task01));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId01Assignment);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task01.setCommitNeeded();
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.commitAll());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"opsh."));
    }

    @Test
    public void shouldSendPurgeData() {
        Mockito.when((Object)this.adminClient.deleteRecords(Collections.singletonMap(this.t1p1, RecordsToDelete.beforeOffset((long)5L)))).thenReturn((Object)new DeleteRecordsResult(Collections.singletonMap(this.t1p1, TaskManagerTest.completedFuture())));
        Mockito.when((Object)this.adminClient.deleteRecords(Collections.singletonMap(this.t1p1, RecordsToDelete.beforeOffset((long)17L)))).thenReturn((Object)new DeleteRecordsResult(Collections.singletonMap(this.t1p1, TaskManagerTest.completedFuture())));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.adminClient});
        final HashMap<TopicPartition, Long> purgableOffsets = new HashMap<TopicPartition, Long>();
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Map<TopicPartition, Long> purgeableOffsets() {
                return purgableOffsets;
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        purgableOffsets.put(this.t1p1, 5L);
        this.taskManager.maybePurgeCommittedRecords();
        purgableOffsets.put(this.t1p1, 17L);
        this.taskManager.maybePurgeCommittedRecords();
        ((Admin)inOrder.verify((Object)this.adminClient)).deleteRecords(Collections.singletonMap(this.t1p1, RecordsToDelete.beforeOffset((long)5L)));
        ((Admin)inOrder.verify((Object)this.adminClient)).deleteRecords(Collections.singletonMap(this.t1p1, RecordsToDelete.beforeOffset((long)17L)));
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldNotSendPurgeDataIfPreviousNotDone() {
        KafkaFutureImpl futureDeletedRecords = new KafkaFutureImpl();
        Mockito.when((Object)this.adminClient.deleteRecords(Collections.singletonMap(this.t1p1, RecordsToDelete.beforeOffset((long)5L)))).thenReturn((Object)new DeleteRecordsResult(Collections.singletonMap(this.t1p1, futureDeletedRecords)));
        final HashMap<TopicPartition, Long> purgableOffsets = new HashMap<TopicPartition, Long>();
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Map<TopicPartition, Long> purgeableOffsets() {
                return purgableOffsets;
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        purgableOffsets.put(this.t1p1, 5L);
        this.taskManager.maybePurgeCommittedRecords();
        purgableOffsets.put(this.t1p1, 17L);
        this.taskManager.maybePurgeCommittedRecords();
    }

    @Test
    public void shouldIgnorePurgeDataErrors() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        KafkaFutureImpl futureDeletedRecords = new KafkaFutureImpl();
        DeleteRecordsResult deleteRecordsResult = new DeleteRecordsResult(Collections.singletonMap(this.t1p1, futureDeletedRecords));
        futureDeletedRecords.completeExceptionally((Throwable)new Exception("KABOOM!"));
        Mockito.when((Object)this.adminClient.deleteRecords((Map)ArgumentMatchers.any())).thenReturn((Object)deleteRecordsResult);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.addTask((Task)task00);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setPurgeableOffsets(Collections.singletonMap(this.t1p1, 5L));
        this.taskManager.maybePurgeCommittedRecords();
        this.taskManager.maybePurgeCommittedRecords();
    }

    @Test
    public void shouldMaybeCommitAllActiveTasksThatNeedCommit() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets0 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets0);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets1 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        task01.setCommittableOffsetsAndMetadata(offsets1);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets2 = Collections.singletonMap(this.t1p2, new OffsetAndMetadata(2L, null));
        task02.setCommittableOffsetsAndMetadata(offsets2);
        StateMachineTask task03 = new StateMachineTask(this.taskId03, this.taskId03Partitions, true, this.stateManager);
        StateMachineTask task04 = new StateMachineTask(this.taskId10, this.taskId10Partitions, false, this.stateManager);
        HashMap<TopicPartition, OffsetAndMetadata> expectedCommittedOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        expectedCommittedOffsets.putAll(offsets0);
        expectedCommittedOffsets.putAll(offsets1);
        Map assignmentActive = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId00, this.taskId00Partitions), Utils.mkEntry((Object)this.taskId01, this.taskId01Partitions), Utils.mkEntry((Object)this.taskId02, this.taskId02Partitions), Utils.mkEntry((Object)this.taskId03, this.taskId03Partitions)});
        Map assignmentStandby = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.taskId10, this.taskId10Partitions)});
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq((Object)assignmentActive))).thenReturn(Arrays.asList(new Task[]{task00, task01, task02, task03}));
        Mockito.when((Object)this.standbyTaskCreator.createTasks(assignmentStandby)).thenReturn(Collections.singletonList(task04));
        this.consumer.commitSync(expectedCommittedOffsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignmentActive, assignmentStandby);
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task02.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task03.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task04.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.setCommitNeeded();
        task00.setCommitRequested();
        task01.setCommitNeeded();
        task02.setCommitRequested();
        task03.setCommitNeeded();
        task03.setCommitRequested();
        task04.setCommitNeeded();
        task04.setCommitRequested();
        MatcherAssert.assertThat((Object)this.taskManager.maybeCommitActiveTasksPerUserRequested(), (Matcher)IsEqual.equalTo((Object)3));
    }

    @Test
    public void shouldProcessActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>();
        assignment.put(this.taskId00, this.taskId00Partitions);
        assignment.put(this.taskId01, this.taskId01Partitions);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{task00, task01}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        task00.addRecords(this.t1p0, Arrays.asList(TaskManagerTest.getConsumerRecord(this.t1p0, 0L), TaskManagerTest.getConsumerRecord(this.t1p0, 1L), TaskManagerTest.getConsumerRecord(this.t1p0, 2L), TaskManagerTest.getConsumerRecord(this.t1p0, 3L), TaskManagerTest.getConsumerRecord(this.t1p0, 4L), TaskManagerTest.getConsumerRecord(this.t1p0, 5L)));
        task01.addRecords(this.t1p1, Arrays.asList(TaskManagerTest.getConsumerRecord(this.t1p1, 0L), TaskManagerTest.getConsumerRecord(this.t1p1, 1L), TaskManagerTest.getConsumerRecord(this.t1p1, 2L), TaskManagerTest.getConsumerRecord(this.t1p1, 3L), TaskManagerTest.getConsumerRecord(this.t1p1, 4L)));
        MatcherAssert.assertThat((Object)this.taskManager.process(3, this.time), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)this.taskManager.process(3, this.time), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)this.taskManager.process(3, this.time), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldNotFailOnTimeoutException() {
        final AtomicReference<TimeoutException> timeoutException = new AtomicReference<TimeoutException>();
        timeoutException.set(new TimeoutException("Skip me!"));
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        task00.transitionTo(Task.State.RESTORING);
        task00.transitionTo(Task.State.RUNNING);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager){

            @Override
            public boolean process(long wallClockTime) {
                TimeoutException exception = (TimeoutException)timeoutException.get();
                if (exception != null) {
                    throw exception;
                }
                return true;
            }
        };
        task01.transitionTo(Task.State.RESTORING);
        task01.transitionTo(Task.State.RUNNING);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        task02.transitionTo(Task.State.RESTORING);
        task02.transitionTo(Task.State.RUNNING);
        this.taskManager.addTask((Task)task00);
        this.taskManager.addTask((Task)task01);
        this.taskManager.addTask((Task)task02);
        task00.addRecords(this.t1p0, Arrays.asList(TaskManagerTest.getConsumerRecord(this.t1p0, 0L), TaskManagerTest.getConsumerRecord(this.t1p0, 1L)));
        task01.addRecords(this.t1p1, Arrays.asList(TaskManagerTest.getConsumerRecord(this.t1p1, 0L), TaskManagerTest.getConsumerRecord(this.t1p1, 1L)));
        task02.addRecords(this.t1p2, Arrays.asList(TaskManagerTest.getConsumerRecord(this.t1p2, 0L), TaskManagerTest.getConsumerRecord(this.t1p2, 1L)));
        MatcherAssert.assertThat((Object)this.taskManager.process(1, this.time), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)task01.timeout, (Matcher)IsEqual.equalTo((Object)this.time.milliseconds()));
        timeoutException.set(null);
        MatcherAssert.assertThat((Object)this.taskManager.process(1, this.time), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)task01.timeout, (Matcher)IsEqual.equalTo(null));
        MatcherAssert.assertThat((Object)this.taskManager.process(1, this.time), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void shouldPropagateTaskMigratedExceptionsInProcessActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public boolean process(long wallClockTime) {
                throw new TaskMigratedException("migrated", (Throwable)new RuntimeException("cause"));
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        TopicPartition partition = this.taskId00Partitions.iterator().next();
        task00.addRecords(partition, Collections.singletonList(TaskManagerTest.getConsumerRecord(partition, 0L)));
        Assert.assertThrows(TaskMigratedException.class, () -> this.taskManager.process(1, this.time));
    }

    @Test
    public void shouldWrapRuntimeExceptionsInProcessActiveTasksAndSetTaskId() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public boolean process(long wallClockTime) {
                throw new RuntimeException("oops");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        TopicPartition partition = this.taskId00Partitions.iterator().next();
        task00.addRecords(partition, Collections.singletonList(TaskManagerTest.getConsumerRecord(partition, 0L)));
        StreamsException exception = (StreamsException)Assert.assertThrows(StreamsException.class, () -> this.taskManager.process(1, this.time));
        MatcherAssert.assertThat((Object)exception.taskId().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(exception.taskId().get(), (Matcher)Matchers.is((Object)this.taskId00));
        MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.is((Object)"oops"));
    }

    @Test
    public void shouldPropagateTaskMigratedExceptionsInPunctuateActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            public boolean maybePunctuateStreamTime() {
                throw new TaskMigratedException("migrated", (Throwable)new RuntimeException("cause"));
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Assert.assertThrows(TaskMigratedException.class, () -> this.taskManager.punctuate());
    }

    @Test
    public void shouldPropagateKafkaExceptionsInPunctuateActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            public boolean maybePunctuateStreamTime() {
                throw new KafkaException("oops");
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        Assert.assertThrows(KafkaException.class, () -> this.taskManager.punctuate());
    }

    @Test
    public void shouldPunctuateActiveTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            public boolean maybePunctuateStreamTime() {
                return true;
            }

            public boolean maybePunctuateSystemTime() {
                return true;
            }
        };
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
        MatcherAssert.assertThat((Object)this.taskManager.punctuate(), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void shouldReturnFalseWhenThereAreStillNonRunningTasks() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public Set<TopicPartition> changelogPartitions() {
                return Collections.singleton(new TopicPartition("fake", 0));
            }
        };
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
        EasyMock.verify((Object[])new Object[]{this.consumer});
    }

    @Test
    public void shouldHaveRemainingPartitionsUncleared() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task00.setCommittableOffsetsAndMetadata(offsets);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(task00));
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(TaskManager.class);){
            appender.setClassLoggerToDebug(TaskManager.class);
            this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
            MatcherAssert.assertThat((Object)this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
            this.taskManager.handleRevocation((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.t1p0, new TopicPartition("unknown", 0)}));
            MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"taskManagerTestThe following revoked partitions [unknown-0] are missing from the current task partitions. It could potentially be due to race condition of consumer detecting the heartbeat failure, or the tasks have been cleaned up by the handleAssignment callback."));
        }
    }

    @Test
    public void shouldThrowTaskMigratedWhenAllTaskCloseExceptionsAreTaskMigrated() {
        StateMachineTask migratedTask01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("t1 close exception", (Throwable)new RuntimeException());
            }
        };
        StateMachineTask migratedTask02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("t2 close exception", (Throwable)new RuntimeException());
            }
        };
        this.taskManager.addTask((Task)migratedTask01);
        this.taskManager.addTask((Task)migratedTask02);
        TaskMigratedException thrown = (TaskMigratedException)Assert.assertThrows(TaskMigratedException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"t2 close exception; it means all tasks belonging to this thread should be migrated."));
    }

    @Test
    public void shouldThrowRuntimeExceptionWhenEncounteredUnknownExceptionDuringTaskClose() {
        StateMachineTask migratedTask01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("t1 close exception", (Throwable)new RuntimeException());
            }
        };
        StateMachineTask migratedTask02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new IllegalStateException("t2 illegal state exception", new RuntimeException());
            }
        };
        this.taskManager.addTask((Task)migratedTask01);
        this.taskManager.addTask((Task)migratedTask02);
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"Encounter unexpected fatal error for task 0_2"));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)IsEqual.equalTo((Object)"t2 illegal state exception"));
    }

    @Test
    public void shouldThrowSameKafkaExceptionWhenEncounteredDuringTaskClose() {
        StateMachineTask migratedTask01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new TaskMigratedException("t1 close exception", (Throwable)new RuntimeException());
            }
        };
        StateMachineTask migratedTask02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, false, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new KafkaException("Kaboom for t2!", (Throwable)new RuntimeException());
            }
        };
        this.taskManager.addTask((Task)migratedTask01);
        this.taskManager.addTask((Task)migratedTask02);
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> this.taskManager.handleAssignment(Collections.emptyMap(), Collections.emptyMap()));
        MatcherAssert.assertThat((Object)thrown.taskId().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(thrown.taskId().get(), (Matcher)Matchers.is((Object)this.taskId02));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)IsEqual.equalTo((Object)"Kaboom for t2!"));
    }

    @Test
    public void shouldTransmitProducerMetrics() {
        MetricName testMetricName = new MetricName("test_metric", "", "", new HashMap());
        KafkaMetric testMetric = new KafkaMetric(new Object(), testMetricName, (MetricValueProvider)((Measurable)(config, now) -> 0.0), null, (Time)new MockTime());
        Map<MetricName, KafkaMetric> dummyProducerMetrics = Collections.singletonMap(testMetricName, testMetric);
        Mockito.when((Object)this.activeTaskCreator.producerMetrics()).thenReturn(dummyProducerMetrics);
        MatcherAssert.assertThat((Object)this.taskManager.producerMetrics(), (Matcher)Matchers.is(dummyProducerMetrics));
    }

    private Map<TaskId, StateMachineTask> handleAssignment(Map<TaskId, Set<TopicPartition>> runningActiveAssignment, Map<TaskId, Set<TopicPartition>> standbyAssignment, Map<TaskId, Set<TopicPartition>> restoringActiveAssignment) {
        Set runningTasks = runningActiveAssignment.entrySet().stream().map(t -> new StateMachineTask((TaskId)t.getKey(), (Set)t.getValue(), true, this.stateManager)).collect(Collectors.toSet());
        Set standbyTasks = standbyAssignment.entrySet().stream().map(t -> new StateMachineTask((TaskId)t.getKey(), (Set)t.getValue(), false, this.stateManager)).collect(Collectors.toSet());
        Set<Task> restoringTasks = restoringActiveAssignment.entrySet().stream().map(t -> new StateMachineTask((TaskId)t.getKey(), (Set)t.getValue(), true, this.stateManager)).collect(Collectors.toSet());
        restoringTasks.forEach(t -> ((StateMachineTask)((Object)t)).setChangelogOffsets(Collections.singletonMap(new TopicPartition("changelog", 0), 0L)));
        HashMap<TaskId, Set<TopicPartition>> allActiveTasksAssignment = new HashMap<TaskId, Set<TopicPartition>>(runningActiveAssignment);
        allActiveTasksAssignment.putAll(restoringActiveAssignment);
        HashSet allActiveTasks = new HashSet(runningTasks);
        allActiveTasks.addAll(restoringTasks);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(standbyAssignment)).thenReturn(standbyTasks);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(allActiveTasksAssignment))).thenReturn(allActiveTasks);
        TaskManagerTest.expectRestoreToBeCompleted(this.consumer);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(allActiveTasksAssignment, standbyAssignment);
        this.taskManager.tryToCompleteRestoration(this.time.milliseconds(), null);
        HashMap<TaskId, StateMachineTask> allTasks = new HashMap<TaskId, StateMachineTask>();
        for (Task task : runningTasks) {
            MatcherAssert.assertThat((Object)task.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
            allTasks.put(task.id(), (StateMachineTask)task);
        }
        for (Task task : restoringTasks) {
            MatcherAssert.assertThat((Object)task.state(), (Matcher)Matchers.is((Object)Task.State.RESTORING));
            allTasks.put(task.id(), (StateMachineTask)task);
        }
        for (Task task : standbyTasks) {
            MatcherAssert.assertThat((Object)task.state(), (Matcher)Matchers.is((Object)Task.State.RUNNING));
            allTasks.put(task.id(), (StateMachineTask)task);
        }
        return allTasks;
    }

    private void expectLockObtainedFor(TaskId ... tasks) throws Exception {
        for (TaskId task : tasks) {
            EasyMock.expect((Object)this.stateDirectory.lock(task)).andReturn((Object)true).once();
        }
    }

    private void expectLockFailedFor(TaskId ... tasks) throws Exception {
        for (TaskId task : tasks) {
            EasyMock.expect((Object)this.stateDirectory.lock(task)).andReturn((Object)false).once();
        }
    }

    private void expectUnlockFor(TaskId ... tasks) throws Exception {
        for (TaskId task : tasks) {
            this.stateDirectory.unlock(task);
            EasyMock.expectLastCall();
        }
    }

    private void expectDirectoryNotEmpty(TaskId ... tasks) {
        for (TaskId taskId : tasks) {
            EasyMock.expect((Object)this.stateDirectory.directoryForTaskIsEmpty(taskId)).andReturn((Object)false);
        }
    }

    private static void expectConsumerAssignmentPaused(Consumer<byte[], byte[]> consumer) {
        Set<TopicPartition> assignment = Collections.singleton(new TopicPartition("assignment", 0));
        EasyMock.expect((Object)consumer.assignment()).andReturn(assignment);
        consumer.pause(assignment);
    }

    @Test
    public void shouldThrowTaskMigratedExceptionOnCommitFailed() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task01.setCommittableOffsetsAndMetadata(offsets);
        task01.setCommitNeeded();
        this.taskManager.addTask((Task)task01);
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall().andThrow((Throwable)new CommitFailedException());
        EasyMock.replay((Object[])new Object[]{this.consumer});
        TaskMigratedException thrown = (TaskMigratedException)Assert.assertThrows(TaskMigratedException.class, () -> this.taskManager.commitAll());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.instanceOf(CommitFailedException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"Consumer committing offsets failed, indicating the corresponding thread is no longer part of the group; it means all tasks belonging to this thread should be migrated."));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
    }

    @Test
    public void shouldNotFailForTimeoutExceptionOnConsumerCommit() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        task00.setCommittableOffsetsAndMetadata(this.taskId00Partitions.stream().collect(Collectors.toMap(p -> p, p -> new OffsetAndMetadata(0L))));
        task01.setCommittableOffsetsAndMetadata(this.taskId00Partitions.stream().collect(Collectors.toMap(p -> p, p -> new OffsetAndMetadata(0L))));
        this.consumer.commitSync((Map)EasyMock.anyObject(Map.class));
        EasyMock.expectLastCall().andThrow((Throwable)new TimeoutException("KABOOM!"));
        this.consumer.commitSync((Map)EasyMock.anyObject(Map.class));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.consumer});
        task00.setCommitNeeded();
        MatcherAssert.assertThat((Object)this.taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task00, task01})), (Matcher)IsEqual.equalTo((Object)0));
        MatcherAssert.assertThat((Object)task00.timeout, (Matcher)IsEqual.equalTo((Object)this.time.milliseconds()));
        Assert.assertNull((Object)task01.timeout);
        MatcherAssert.assertThat((Object)this.taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task00, task01})), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertNull((Object)task00.timeout);
        Assert.assertNull((Object)task01.timeout);
    }

    @Test
    public void shouldNotFailForTimeoutExceptionOnCommitWithEosAlpha() {
        Tasks tasks = (Tasks)Mockito.mock(Tasks.class);
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA, (TasksRegistry)tasks, false);
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.streamsProducerForTask((TaskId)ArgumentMatchers.any(TaskId.class))).thenReturn((Object)producer);
        Map<TopicPartition, OffsetAndMetadata> offsetsT00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        Map<TopicPartition, OffsetAndMetadata> offsetsT01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        ((StreamsProducer)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("KABOOM!")}).doNothing().doNothing().doNothing().when((Object)producer)).commitTransaction(offsetsT00, null);
        ((StreamsProducer)Mockito.doNothing().doNothing().when((Object)producer)).commitTransaction(offsetsT01, null);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        task00.setCommittableOffsetsAndMetadata(offsetsT00);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        task01.setCommittableOffsetsAndMetadata(offsetsT01);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        Mockito.when((Object)tasks.allTasks()).thenReturn((Object)Utils.mkSet((Object[])new Task[]{task00, task01, task02}));
        EasyMock.expect((Object)this.consumer.groupMetadata()).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        task00.setCommitNeeded();
        task01.setCommitNeeded();
        TaskCorruptedException exception = (TaskCorruptedException)Assert.assertThrows(TaskCorruptedException.class, () -> taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task00, task01, task02})));
        MatcherAssert.assertThat((Object)exception.corruptedTasks(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId00)));
    }

    @Test
    public void shouldThrowTaskCorruptedExceptionForTimeoutExceptionOnCommitWithEosV2() {
        TaskManager taskManager = this.setUpTaskManager(StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_V2, false);
        StreamsProducer producer = (StreamsProducer)Mockito.mock(StreamsProducer.class);
        Mockito.when((Object)this.activeTaskCreator.threadProducer()).thenReturn((Object)producer);
        Map<TopicPartition, OffsetAndMetadata> offsetsT00 = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        Map<TopicPartition, OffsetAndMetadata> offsetsT01 = Collections.singletonMap(this.t1p1, new OffsetAndMetadata(1L, null));
        HashMap<TopicPartition, OffsetAndMetadata> allOffsets = new HashMap<TopicPartition, OffsetAndMetadata>(offsetsT00);
        allOffsets.putAll(offsetsT01);
        ((StreamsProducer)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("KABOOM!")}).doNothing().when((Object)producer)).commitTransaction(allOffsets, null);
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager);
        task00.setCommittableOffsetsAndMetadata(offsetsT00);
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        task01.setCommittableOffsetsAndMetadata(offsetsT01);
        StateMachineTask task02 = new StateMachineTask(this.taskId02, this.taskId02Partitions, true, this.stateManager);
        EasyMock.expect((Object)this.consumer.groupMetadata()).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        task00.setCommitNeeded();
        task01.setCommitNeeded();
        TaskCorruptedException exception = (TaskCorruptedException)Assert.assertThrows(TaskCorruptedException.class, () -> taskManager.commit((Collection)Utils.mkSet((Object[])new Task[]{task00, task01, task02})));
        MatcherAssert.assertThat((Object)exception.corruptedTasks(), (Matcher)IsEqual.equalTo((Object)Utils.mkSet((Object[])new TaskId[]{this.taskId00, this.taskId01})));
    }

    @Test
    public void shouldStreamsExceptionOnCommitError() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task01.setCommittableOffsetsAndMetadata(offsets);
        task01.setCommitNeeded();
        this.taskManager.addTask((Task)task01);
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall().andThrow((Throwable)new KafkaException());
        EasyMock.replay((Object[])new Object[]{this.consumer});
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> this.taskManager.commitAll());
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Matchers.instanceOf(KafkaException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"Error encountered committing offsets via consumer"));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
    }

    @Test
    public void shouldFailOnCommitFatal() {
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        Map<TopicPartition, OffsetAndMetadata> offsets = Collections.singletonMap(this.t1p0, new OffsetAndMetadata(0L, null));
        task01.setCommittableOffsetsAndMetadata(offsets);
        task01.setCommitNeeded();
        this.taskManager.addTask((Task)task01);
        this.consumer.commitSync(offsets);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("KABOOM"));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.commitAll());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)"KABOOM"));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.CREATED));
    }

    @Test
    public void shouldSuspendAllTasksButSkipCommitIfSuspendingFailsDuringRevocation() {
        StateMachineTask task00 = new StateMachineTask(this.taskId00, this.taskId00Partitions, true, this.stateManager){

            @Override
            public void suspend() {
                super.suspend();
                throw new RuntimeException("KABOOM!");
            }
        };
        StateMachineTask task01 = new StateMachineTask(this.taskId01, this.taskId01Partitions, true, this.stateManager);
        HashMap<TaskId, Set<TopicPartition>> assignment = new HashMap<TaskId, Set<TopicPartition>>(this.taskId00Assignment);
        assignment.putAll(this.taskId01Assignment);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(assignment))).thenReturn(Arrays.asList(new Task[]{task00, task01}));
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(assignment, Collections.emptyMap());
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.taskManager.handleRevocation(Arrays.asList(this.t1p0, this.t1p1)));
        MatcherAssert.assertThat((Object)thrown.getCause().getMessage(), (Matcher)Matchers.is((Object)"KABOOM!"));
        MatcherAssert.assertThat((Object)task00.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
        MatcherAssert.assertThat((Object)task01.state(), (Matcher)Matchers.is((Object)Task.State.SUSPENDED));
    }

    @Test
    public void shouldConvertActiveTaskToStandbyTask() {
        StreamTask activeTask = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)activeTask.id()).thenReturn((Object)this.taskId00);
        Mockito.when((Object)activeTask.inputPartitions()).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)activeTask.isActive()).thenReturn((Object)true);
        StandbyTask standbyTask = (StandbyTask)Mockito.mock(StandbyTask.class);
        Mockito.when((Object)standbyTask.id()).thenReturn((Object)this.taskId00);
        Mockito.when((Object)this.activeTaskCreator.createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(this.taskId00Assignment))).thenReturn(Collections.singletonList(activeTask));
        Mockito.when((Object)this.standbyTaskCreator.createStandbyTaskFromActive((StreamTask)Mockito.any(), (Set)Mockito.eq(this.taskId00Partitions))).thenReturn((Object)standbyTask);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId00Assignment);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).closeAndRemoveTaskProducerIfNeeded(this.taskId00);
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator)).createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(Collections.emptyMap()));
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator, (VerificationMode)Mockito.times((int)2))).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldConvertStandbyTaskToActiveTask() {
        StandbyTask standbyTask = (StandbyTask)Mockito.mock(StandbyTask.class);
        Mockito.when((Object)standbyTask.id()).thenReturn((Object)this.taskId00);
        Mockito.when((Object)standbyTask.isActive()).thenReturn((Object)false);
        Mockito.when((Object)standbyTask.prepareCommit()).thenReturn(Collections.emptyMap());
        StreamTask activeTask = (StreamTask)Mockito.mock(StreamTask.class);
        Mockito.when((Object)activeTask.id()).thenReturn((Object)this.taskId00);
        Mockito.when((Object)activeTask.inputPartitions()).thenReturn(this.taskId00Partitions);
        Mockito.when((Object)this.standbyTaskCreator.createTasks(this.taskId00Assignment)).thenReturn(Collections.singletonList(standbyTask));
        Mockito.when((Object)this.activeTaskCreator.createActiveTaskFromStandby((StandbyTask)Mockito.eq((Object)standbyTask), (Set)Mockito.eq(this.taskId00Partitions), (Consumer)ArgumentMatchers.any())).thenReturn((Object)activeTask);
        EasyMock.replay((Object[])new Object[]{this.consumer});
        this.taskManager.handleAssignment(Collections.emptyMap(), this.taskId00Assignment);
        this.taskManager.handleAssignment(this.taskId00Assignment, Collections.emptyMap());
        ((ActiveTaskCreator)Mockito.verify((Object)this.activeTaskCreator, (VerificationMode)Mockito.times((int)2))).createTasks((Consumer)ArgumentMatchers.any(), (Map)Mockito.eq(Collections.emptyMap()));
        ((StandbyTaskCreator)Mockito.verify((Object)this.standbyTaskCreator)).createTasks(Collections.emptyMap());
    }

    @Test
    public void shouldListNotPausedTasks() {
        this.handleAssignment(this.taskId00Assignment, this.taskId01Assignment, Collections.emptyMap());
        Assert.assertEquals((long)this.taskManager.notPausedTasks().size(), (long)2L);
        this.topologyMetadata.pauseTopology("__UNNAMED_TOPOLOGY__");
        Assert.assertEquals((long)this.taskManager.notPausedTasks().size(), (long)0L);
    }

    private static void expectRestoreToBeCompleted(Consumer<byte[], byte[]> consumer) {
        Set<TopicPartition> assignment = Collections.singleton(new TopicPartition("assignment", 0));
        EasyMock.expect((Object)consumer.assignment()).andReturn(assignment);
        consumer.resume(assignment);
        EasyMock.expectLastCall();
    }

    private static KafkaFutureImpl<DeletedRecords> completedFuture() {
        KafkaFutureImpl futureDeletedRecords = new KafkaFutureImpl();
        futureDeletedRecords.complete(null);
        return futureDeletedRecords;
    }

    private void makeTaskFolders(String ... names) throws Exception {
        ArrayList<StateDirectory.TaskDirectory> taskFolders = new ArrayList<StateDirectory.TaskDirectory>(names.length);
        for (int i = 0; i < names.length; ++i) {
            taskFolders.add(new StateDirectory.TaskDirectory(this.testFolder.newFolder(names[i]), null));
        }
        EasyMock.expect((Object)this.stateDirectory.listNonEmptyTaskDirectories()).andReturn(taskFolders).once();
    }

    private void writeCheckpointFile(TaskId task, Map<TopicPartition, Long> offsets) throws Exception {
        File checkpointFile = this.getCheckpointFile(task);
        Files.createFile(checkpointFile.toPath(), new FileAttribute[0]);
        new OffsetCheckpoint(checkpointFile).write(offsets);
        EasyMock.expect((Object)this.stateDirectory.checkpointFileFor(task)).andReturn((Object)checkpointFile);
        this.expectDirectoryNotEmpty(task);
    }

    private File getCheckpointFile(TaskId task) {
        return new File(new File(this.testFolder.getRoot(), task.toString()), ".checkpoint");
    }

    private static ConsumerRecord<byte[], byte[]> getConsumerRecord(TopicPartition topicPartition, long offset) {
        return new ConsumerRecord(topicPartition.topic(), topicPartition.partition(), offset, null, null);
    }

    private static class StateMachineTask
    extends AbstractTask
    implements Task {
        private final boolean active;
        private boolean commitNeeded = false;
        private boolean commitRequested = false;
        private boolean commitPrepared = false;
        private boolean commitCompleted = false;
        private Map<TopicPartition, OffsetAndMetadata> committableOffsets = Collections.emptyMap();
        private Map<TopicPartition, Long> purgeableOffsets;
        private Map<TopicPartition, Long> changelogOffsets = Collections.emptyMap();
        private Set<TopicPartition> partitionsForOffsetReset = Collections.emptySet();
        private Long timeout = null;
        private final Map<TopicPartition, LinkedList<ConsumerRecord<byte[], byte[]>>> queue = new HashMap<TopicPartition, LinkedList<ConsumerRecord<byte[], byte[]>>>();

        StateMachineTask(TaskId id, Set<TopicPartition> partitions, boolean active, ProcessorStateManager processorStateManager) {
            super(id, null, null, processorStateManager, partitions, new TopologyConfig((StreamsConfig)new DummyStreamsConfig()).getTaskConfig(), "test-task", StateMachineTask.class);
            this.active = active;
        }

        public void initializeIfNeeded() {
            if (this.state() == Task.State.CREATED) {
                this.transitionTo(Task.State.RESTORING);
                if (!this.active) {
                    this.transitionTo(Task.State.RUNNING);
                }
            }
        }

        public void addPartitionsForOffsetReset(Set<TopicPartition> partitionsForOffsetReset) {
            this.partitionsForOffsetReset = partitionsForOffsetReset;
        }

        public void completeRestoration(java.util.function.Consumer<Set<TopicPartition>> offsetResetter) {
            if (this.state() == Task.State.RUNNING) {
                return;
            }
            this.transitionTo(Task.State.RUNNING);
        }

        public void setCommitNeeded() {
            this.commitNeeded = true;
        }

        public boolean commitNeeded() {
            return this.commitNeeded;
        }

        public void setCommitRequested() {
            this.commitRequested = true;
        }

        public boolean commitRequested() {
            return this.commitRequested;
        }

        public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
            this.commitPrepared = true;
            if (this.commitNeeded) {
                return this.committableOffsets;
            }
            return Collections.emptyMap();
        }

        public void postCommit(boolean enforceCheckpoint) {
            this.commitNeeded = false;
            this.commitCompleted = true;
        }

        public void suspend() {
            if (this.state() == Task.State.CLOSED) {
                throw new IllegalStateException("Illegal state " + this.state() + " while suspending active task " + this.id);
            }
            if (this.state() != Task.State.SUSPENDED) {
                this.transitionTo(Task.State.SUSPENDED);
            }
        }

        public void resume() {
            if (this.state() == Task.State.SUSPENDED) {
                this.transitionTo(Task.State.RUNNING);
            }
        }

        public void revive() {
            this.commitNeeded = false;
            this.commitRequested = false;
            super.revive();
        }

        public void maybeInitTaskTimeoutOrThrow(long currentWallClockMs, Exception cause) {
            this.timeout = currentWallClockMs;
        }

        public void clearTaskTimeout() {
            this.timeout = null;
        }

        public void recordRestoration(Time time, long numRecords, boolean initRemaining) {
        }

        public void closeClean() {
            this.transitionTo(Task.State.CLOSED);
        }

        public void closeDirty() {
            this.transitionTo(Task.State.CLOSED);
        }

        public void prepareRecycle() {
            this.transitionTo(Task.State.CLOSED);
        }

        public void resumePollingForPartitionsWithAvailableSpace() {
        }

        public void updateLags() {
        }

        public void updateInputPartitions(Set<TopicPartition> topicPartitions, Map<String, List<String>> allTopologyNodesToSourceTopics) {
            this.inputPartitions = topicPartitions;
        }

        void setCommittableOffsetsAndMetadata(Map<TopicPartition, OffsetAndMetadata> committableOffsets) {
            if (!this.active) {
                throw new IllegalStateException("Cannot set CommittableOffsetsAndMetadate for StandbyTasks");
            }
            this.committableOffsets = committableOffsets;
        }

        public StateStore getStore(String name) {
            return null;
        }

        public Set<TopicPartition> changelogPartitions() {
            return this.changelogOffsets.keySet();
        }

        public boolean isActive() {
            return this.active;
        }

        void setPurgeableOffsets(Map<TopicPartition, Long> purgeableOffsets) {
            this.purgeableOffsets = purgeableOffsets;
        }

        public Map<TopicPartition, Long> purgeableOffsets() {
            return this.purgeableOffsets;
        }

        void setChangelogOffsets(Map<TopicPartition, Long> changelogOffsets) {
            this.changelogOffsets = changelogOffsets;
        }

        public Map<TopicPartition, Long> changelogOffsets() {
            return this.changelogOffsets;
        }

        public Map<TopicPartition, Long> committedOffsets() {
            return Collections.emptyMap();
        }

        public Map<TopicPartition, Long> highWaterMark() {
            return Collections.emptyMap();
        }

        public Optional<Long> timeCurrentIdlingStarted() {
            return Optional.empty();
        }

        public void addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
            if (this.isActive()) {
                Deque partitionQueue = this.queue.computeIfAbsent(partition, k -> new LinkedList());
                for (ConsumerRecord<byte[], byte[]> record : records) {
                    partitionQueue.add(record);
                }
            } else {
                throw new IllegalStateException("Can't add records to an inactive task.");
            }
        }

        public boolean process(long wallClockTime) {
            if (this.isActive() && this.state() == Task.State.RUNNING) {
                for (LinkedList<ConsumerRecord<byte[], byte[]>> records : this.queue.values()) {
                    ConsumerRecord<byte[], byte[]> record = records.poll();
                    if (record == null) continue;
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("Can't process an inactive or non-running task.");
        }
    }
}

