/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.SessionWindowedSerializer;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowedSerializerTest {
    private final SessionWindowedSerializer<?> sessionWindowedSerializer = new SessionWindowedSerializer(Serdes.String().serializer());
    private final Map<String, String> props = new HashMap<String, String>();

    @Test
    public void testSessionWindowedSerializerConstructor() {
        this.sessionWindowedSerializer.configure(this.props, true);
        Serializer inner = this.sessionWindowedSerializer.innerSerializer();
        Assert.assertNotNull((String)"Inner serializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner serializer type should be StringSerializer", (boolean)(inner instanceof StringSerializer));
    }

    @Test
    public void shouldSetWindowedInnerClassSerialiserThroughConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        SessionWindowedSerializer serializer = new SessionWindowedSerializer();
        serializer.configure(this.props, false);
        Assert.assertTrue((boolean)(serializer.innerSerializer() instanceof ByteArraySerializer));
    }

    @Test
    public void shouldThrowErrorIfWindowInnerClassSerialiserIsNotSet() {
        SessionWindowedSerializer serializer = new SessionWindowedSerializer();
        Assert.assertThrows(IllegalArgumentException.class, () -> serializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowErrorIfSerialisersConflictInConstructorAndConfig() {
        this.props.put("windowed.inner.class.serde", Serdes.ByteArraySerde.class.getName());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.sessionWindowedSerializer.configure(this.props, false));
    }

    @Test
    public void shouldThrowConfigExceptionWhenInvalidWindowInnerClassSerialiserSupplied() {
        this.props.put("windowed.inner.class.serde", "some.non.existent.class");
        Assert.assertThrows(ConfigException.class, () -> this.sessionWindowedSerializer.configure(this.props, false));
    }
}

