/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class StreamTableJoinWithGraceIntegrationTest
extends AbstractJoinIntegrationTest {
    private static final String STORE_NAME = "table-store";
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);
    private KStream<Long, String> leftStream;
    private KTable<Long, String> rightTable;
    private Joined<Long, String, String> joined;

    public StreamTableJoinWithGraceIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "stream-table-join-integration-test";
        this.builder = new StreamsBuilder();
        this.joined = Joined.with((Serde)Serdes.Long(), (Serde)Serdes.String(), (Serde)Serdes.String(), (String)"Grace", (Duration)Duration.ofMillis(2L));
    }

    @Test
    public void testInnerWithVersionedStore() {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        this.leftStream = this.builder.stream("inputTopicLeft");
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)STORE_NAME, (Duration)Duration.ofMinutes(5L))));
        this.leftStream.join(this.rightTable, this.valueJoiner, this.joined).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(6L))), null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-a", null, Long.valueOf(4L))), null);
        this.runTestWithDriver(this.input, expectedResult);
    }

    @Test
    public void testLeftWithVersionedStore() {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        this.leftStream = this.builder.stream("inputTopicLeft");
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)STORE_NAME, (Duration)Duration.ofMinutes(5L))));
        this.leftStream.leftJoin(this.rightTable, this.valueJoiner, this.joined).to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-b", null, Long.valueOf(6L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-a", null, Long.valueOf(4L))), null);
        this.runTestWithDriver(this.input, expectedResult);
    }
}

