/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MergedSortedCacheWrappedWindowStoreIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private final List<KeyValue<Long, byte[]>> windowStoreKvPairs = new ArrayList<KeyValue<Long, byte[]>>();
    private final ThreadCache cache = new ThreadCache(new LogContext("testCache "), 1000000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
    private final String namespace = "0.0-one";
    private final StateSerdes<String, String> stateSerdes = new StateSerdes("foo", Serdes.String(), Serdes.String());
    private Function<byte[], Long> tsExtractor;
    private StoreKeySerializer<String> storeKeySerializer;
    @Parameterized.Parameter
    public SchemaType schemaType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SchemaType.WINDOW_KEY_SCHEMA}, {SchemaType.KEY_FIRST_SCHEMA}, {SchemaType.TIME_FIRST_SCHEMA});
    }

    @Before
    public void setUp() {
        switch (this.schemaType) {
            case KEY_FIRST_SCHEMA: {
                this.tsExtractor = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreTimestamp;
                this.storeKeySerializer = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            case WINDOW_KEY_SCHEMA: {
                this.tsExtractor = WindowKeySchema::extractStoreTimestamp;
                this.storeKeySerializer = WindowKeySchema::toStoreKeyBinary;
                break;
            }
            case TIME_FIRST_SCHEMA: {
                this.tsExtractor = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp;
                this.storeKeySerializer = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown schemaType: " + (Object)((Object)this.schemaType));
            }
        }
    }

    @Test
    public void shouldIterateOverValueFromBothIterators() {
        ArrayList<KeyValue> expectedKvPairs = new ArrayList<KeyValue>();
        for (long t = 0L; t < 100L; t += 20L) {
            byte[] v1Bytes = String.valueOf(t).getBytes();
            KeyValue v1 = KeyValue.pair((Object)t, (Object)v1Bytes);
            this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)v1);
            expectedKvPairs.add(KeyValue.pair((Object)t, (Object)v1Bytes));
            Bytes keyBytes = this.storeKeySerializer.serialize("a", t + 10L, 0, this.stateSerdes);
            byte[] valBytes = String.valueOf(t + 10L).getBytes();
            expectedKvPairs.add(KeyValue.pair((Object)(t + 10L), (Object)valBytes));
            this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(keyBytes), new LRUCacheEntry(valBytes));
        }
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, true, this.tsExtractor);
        int index = 0;
        while (iterator.hasNext()) {
            KeyValue next = iterator.next();
            KeyValue expected = (KeyValue)expectedKvPairs.get(index++);
            Assert.assertArrayEquals((byte[])((byte[])expected.value), (byte[])((byte[])next.value));
            Assert.assertEquals((Object)expected.key, (Object)next.key);
        }
        iterator.close();
    }

    @Test
    public void shouldReverseIterateOverValueFromBothIterators() {
        ArrayList<KeyValue> expectedKvPairs = new ArrayList<KeyValue>();
        for (long t = 0L; t < 100L; t += 20L) {
            byte[] v1Bytes = String.valueOf(t).getBytes();
            KeyValue v1 = KeyValue.pair((Object)t, (Object)v1Bytes);
            this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)v1);
            expectedKvPairs.add(KeyValue.pair((Object)t, (Object)v1Bytes));
            Bytes keyBytes = this.storeKeySerializer.serialize("a", t + 10L, 0, this.stateSerdes);
            byte[] valBytes = String.valueOf(t + 10L).getBytes();
            expectedKvPairs.add(KeyValue.pair((Object)(t + 10L), (Object)valBytes));
            this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(keyBytes), new LRUCacheEntry(valBytes));
        }
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        Collections.reverse(this.windowStoreKvPairs);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.reverseRange("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, false, this.tsExtractor);
        int index = 0;
        Collections.reverse(expectedKvPairs);
        while (iterator.hasNext()) {
            KeyValue next = iterator.next();
            KeyValue expected = (KeyValue)expectedKvPairs.get(index++);
            Assert.assertArrayEquals((byte[])((byte[])expected.value), (byte[])((byte[])next.value));
            Assert.assertEquals((Object)expected.key, (Object)next.key);
        }
        iterator.close();
    }

    @Test
    public void shouldPeekNextStoreKey() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)10L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, true, this.tsExtractor);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }

    @Test
    public void shouldPeekNextStoreKeyReverse() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)10L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.reverseRange("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, false, this.tsExtractor);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.close();
    }

    @Test
    public void shouldPeekNextCacheKey() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)0L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize("a", 10L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, true, this.tsExtractor);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }

    @Test
    public void shouldPeekNextCacheKeyReverse() {
        this.windowStoreKvPairs.add((KeyValue<Long, byte[]>)KeyValue.pair((Object)0L, (Object)"a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize("a", 10L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = this.storeKeySerializer.serialize("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = this.storeKeySerializer.serialize("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.reverseRange("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, false, this.tsExtractor);
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.next();
        MatcherAssert.assertThat((Object)iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.close();
    }

    private static enum SchemaType {
        WINDOW_KEY_SCHEMA,
        KEY_FIRST_SCHEMA,
        TIME_FIRST_SCHEMA;

    }

    @FunctionalInterface
    private static interface StoreKeySerializer<K> {
        public Bytes serialize(K var1, long var2, int var4, StateSerdes<K, ?> var5);
    }
}

