/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockApiProcessor;

public class MockProcessor<K, V>
extends AbstractProcessor<K, V> {
    private final MockApiProcessor<K, V, Object, Object> delegate;

    public MockProcessor(PunctuationType punctuationType, long scheduleInterval) {
        this.delegate = new MockApiProcessor(punctuationType, scheduleInterval);
    }

    public MockProcessor() {
        this.delegate = new MockApiProcessor();
    }

    public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
        super.init(context);
        this.delegate.init((ProcessorContext<Object, Object>)((ProcessorContext)context));
    }

    public void process(K key, V value) {
        this.delegate.process(new Record(key, value, this.context.timestamp(), this.context.headers()));
    }

    public void checkAndClearProcessResult(KeyValueTimestamp<?, ?> ... expected) {
        this.delegate.checkAndClearProcessResult(expected);
    }

    public void requestCommit() {
        this.delegate.requestCommit();
    }

    public void checkEmptyAndClearProcessResult() {
        this.delegate.checkEmptyAndClearProcessResult();
    }

    public void checkAndClearPunctuateResult(PunctuationType type, long ... expected) {
        this.delegate.checkAndClearPunctuateResult(type, expected);
    }

    public Map<K, ValueAndTimestamp<V>> lastValueAndTimestampPerKey() {
        return this.delegate.lastValueAndTimestampPerKey();
    }

    public List<Long> punctuatedStreamTime() {
        return this.delegate.punctuatedStreamTime();
    }

    public Cancellable scheduleCancellable() {
        return this.delegate.scheduleCancellable();
    }

    public ArrayList<KeyValueTimestamp<K, V>> processed() {
        return this.delegate.processed();
    }

    public void addProcessorMetadata(String key, long value) {
        if (this.context instanceof InternalProcessorContext) {
            ((InternalProcessorContext)this.context).addProcessorMetadataKeyValue(key, value);
        }
    }
}

