/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetrics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class RocksDBMetricsTest {
    private static final String STATE_LEVEL_GROUP = "stream-state-metrics";
    private static final String TASK_ID = "test-task";
    private static final String STORE_TYPE = "test-store-type";
    private static final String STORE_NAME = "store";
    private static final RocksDBMetrics.RocksDBMetricContext ROCKSDB_METRIC_CONTEXT = new RocksDBMetrics.RocksDBMetricContext("test-task", "test-store-type", "store");
    private static final Gauge<BigInteger> VALUE_PROVIDER = (config, now) -> BigInteger.valueOf(10L);
    private final Metrics metrics = new Metrics();
    private final Sensor sensor = this.metrics.sensor("dummy");
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Map<String, String> tags = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetBytesWrittenSensor() {
        String metricNamePrefix = "bytes-written";
        String descriptionOfTotal = "Total number of bytes written to the RocksDB state store";
        String descriptionOfRate = "Average number of bytes written per second to the RocksDB state store";
        this.verifyRateAndTotalSensor("bytes-written", "Total number of bytes written to the RocksDB state store", "Average number of bytes written per second to the RocksDB state store", RocksDBMetrics::bytesWrittenToDatabaseSensor);
    }

    @Test
    public void shouldGetBytesReadSensor() {
        String metricNamePrefix = "bytes-read";
        String descriptionOfTotal = "Total number of bytes read from the RocksDB state store";
        String descriptionOfRate = "Average number of bytes read per second from the RocksDB state store";
        this.verifyRateAndTotalSensor("bytes-read", "Total number of bytes read from the RocksDB state store", "Average number of bytes read per second from the RocksDB state store", RocksDBMetrics::bytesReadFromDatabaseSensor);
    }

    @Test
    public void shouldGetMemtableHitRatioSensor() {
        String metricNamePrefix = "memtable-hit-ratio";
        String description = "Ratio of memtable hits relative to all lookups to the memtable";
        this.verifyValueSensor("memtable-hit-ratio", "Ratio of memtable hits relative to all lookups to the memtable", RocksDBMetrics::memtableHitRatioSensor);
    }

    @Test
    public void shouldGetMemtableBytesFlushedSensor() {
        String metricNamePrefix = "memtable-bytes-flushed";
        String descriptionOfTotal = "Total number of bytes flushed from the memtable to disk";
        String descriptionOfRate = "Average number of bytes flushed per second from the memtable to disk";
        this.verifyRateAndTotalSensor("memtable-bytes-flushed", "Total number of bytes flushed from the memtable to disk", "Average number of bytes flushed per second from the memtable to disk", RocksDBMetrics::memtableBytesFlushedSensor);
    }

    @Test
    public void shouldGetMemtableAvgFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-avg";
        String description = "Average time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-avg", "Average time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableAvgFlushTimeSensor);
    }

    @Test
    public void shouldGetMemtableMinFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-min";
        String description = "Minimum time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-min", "Minimum time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableMinFlushTimeSensor);
    }

    @Test
    public void shouldGetMemtableMaxFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-max";
        String description = "Maximum time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-max", "Maximum time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableMaxFlushTimeSensor);
    }

    @Test
    public void shouldGetWriteStallDurationSensor() {
        String metricNamePrefix = "write-stall-duration";
        String descriptionOfAvg = "Average duration of write stalls in ms";
        String descriptionOfTotal = "Total duration of write stalls in ms";
        this.setupStreamsMetricsMock("write-stall-duration");
        StreamsMetricsImpl.addAvgAndSumMetricsToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)"write-stall-duration", (String)"Average duration of write stalls in ms", (String)"Total duration of write stalls in ms");
        this.replayCallAndVerify(RocksDBMetrics::writeStallDurationSensor);
    }

    @Test
    public void shouldGetBlockCacheDataHitRatioSensor() {
        String metricNamePrefix = "block-cache-data-hit-ratio";
        String description = "Ratio of block cache hits for data relative to all lookups for data to the block cache";
        this.verifyValueSensor("block-cache-data-hit-ratio", "Ratio of block cache hits for data relative to all lookups for data to the block cache", RocksDBMetrics::blockCacheDataHitRatioSensor);
    }

    @Test
    public void shouldGetBlockCacheIndexHitRatioSensor() {
        String metricNamePrefix = "block-cache-index-hit-ratio";
        String description = "Ratio of block cache hits for indexes relative to all lookups for indexes to the block cache";
        this.verifyValueSensor("block-cache-index-hit-ratio", "Ratio of block cache hits for indexes relative to all lookups for indexes to the block cache", RocksDBMetrics::blockCacheIndexHitRatioSensor);
    }

    @Test
    public void shouldGetBlockCacheFilterHitRatioSensor() {
        String metricNamePrefix = "block-cache-filter-hit-ratio";
        String description = "Ratio of block cache hits for filters relative to all lookups for filters to the block cache";
        this.verifyValueSensor("block-cache-filter-hit-ratio", "Ratio of block cache hits for filters relative to all lookups for filters to the block cache", RocksDBMetrics::blockCacheFilterHitRatioSensor);
    }

    @Test
    public void shouldGetBytesReadDuringCompactionSensor() {
        String metricNamePrefix = "bytes-read-compaction";
        String description = "Average number of bytes read per second during compaction";
        this.verifyRateSensor("bytes-read-compaction", "Average number of bytes read per second during compaction", RocksDBMetrics::bytesReadDuringCompactionSensor);
    }

    @Test
    public void shouldGetBytesWrittenDuringCompactionSensor() {
        String metricNamePrefix = "bytes-written-compaction";
        String description = "Average number of bytes written per second during compaction";
        this.verifyRateSensor("bytes-written-compaction", "Average number of bytes written per second during compaction", RocksDBMetrics::bytesWrittenDuringCompactionSensor);
    }

    @Test
    public void shouldGetCompactionTimeAvgSensor() {
        String metricNamePrefix = "compaction-time-avg";
        String description = "Average time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-avg", "Average time spent on compaction in ms", RocksDBMetrics::compactionTimeAvgSensor);
    }

    @Test
    public void shouldGetCompactionTimeMinSensor() {
        String metricNamePrefix = "compaction-time-min";
        String description = "Minimum time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-min", "Minimum time spent on compaction in ms", RocksDBMetrics::compactionTimeMinSensor);
    }

    @Test
    public void shouldGetCompactionTimeMaxSensor() {
        String metricNamePrefix = "compaction-time-max";
        String description = "Maximum time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-max", "Maximum time spent on compaction in ms", RocksDBMetrics::compactionTimeMaxSensor);
    }

    @Test
    public void shouldGetNumberOfOpenFilesSensor() {
        String metricNamePrefix = "number-open-files";
        String description = "Number of currently open files";
        this.verifySumSensor("number-open-files", false, "Number of currently open files", RocksDBMetrics::numberOfOpenFilesSensor);
    }

    @Test
    public void shouldGetNumberOfFilesErrors() {
        String metricNamePrefix = "number-file-errors";
        String description = "Total number of file errors occurred";
        this.verifySumSensor("number-file-errors", true, "Total number of file errors occurred", RocksDBMetrics::numberOfFileErrorsSensor);
    }

    @Test
    public void shouldAddNumEntriesActiveMemTableMetric() {
        String name = "num-entries-active-mem-table";
        String description = "Total number of entries in the active memtable";
        this.runAndVerifyMutableMetric("num-entries-active-mem-table", "Total number of entries in the active memtable", () -> RocksDBMetrics.addNumEntriesActiveMemTableMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumberDeletesActiveTableMetric() {
        String name = "num-deletes-active-mem-table";
        String description = "Total number of delete entries in the active memtable";
        this.runAndVerifyMutableMetric("num-deletes-active-mem-table", "Total number of delete entries in the active memtable", () -> RocksDBMetrics.addNumDeletesActiveMemTableMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumEntriesImmutableMemTablesMetric() {
        String name = "num-entries-imm-mem-tables";
        String description = "Total number of entries in the unflushed immutable memtables";
        this.runAndVerifyMutableMetric("num-entries-imm-mem-tables", "Total number of entries in the unflushed immutable memtables", () -> RocksDBMetrics.addNumEntriesImmMemTablesMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumDeletesImmutableMemTablesMetric() {
        String name = "num-deletes-imm-mem-tables";
        String description = "Total number of delete entries in the unflushed immutable memtables";
        this.runAndVerifyMutableMetric("num-deletes-imm-mem-tables", "Total number of delete entries in the unflushed immutable memtables", () -> RocksDBMetrics.addNumDeletesImmMemTablesMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumImmutableMemTablesMetric() {
        String name = "num-immutable-mem-table";
        String description = "Number of immutable memtables that have not yet been flushed";
        this.runAndVerifyMutableMetric("num-immutable-mem-table", "Number of immutable memtables that have not yet been flushed", () -> RocksDBMetrics.addNumImmutableMemTableMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddCurSizeActiveMemTableMetric() {
        String name = "cur-size-active-mem-table";
        String description = "Approximate size of active memtable in bytes";
        this.runAndVerifyMutableMetric("cur-size-active-mem-table", "Approximate size of active memtable in bytes", () -> RocksDBMetrics.addCurSizeActiveMemTable((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddCurSizeAllMemTablesMetric() {
        String name = "cur-size-all-mem-tables";
        String description = "Approximate size of active and unflushed immutable memtables in bytes";
        this.runAndVerifyMutableMetric("cur-size-all-mem-tables", "Approximate size of active and unflushed immutable memtables in bytes", () -> RocksDBMetrics.addCurSizeAllMemTables((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddSizeAllMemTablesMetric() {
        String name = "size-all-mem-tables";
        String description = "Approximate size of active, unflushed immutable, and pinned immutable memtables in bytes";
        this.runAndVerifyMutableMetric("size-all-mem-tables", "Approximate size of active, unflushed immutable, and pinned immutable memtables in bytes", () -> RocksDBMetrics.addSizeAllMemTables((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddMemTableFlushPendingMetric() {
        String name = "mem-table-flush-pending";
        String description = "Reports 1 if a memtable flush is pending, otherwise it reports 0";
        this.runAndVerifyMutableMetric("mem-table-flush-pending", "Reports 1 if a memtable flush is pending, otherwise it reports 0", () -> RocksDBMetrics.addMemTableFlushPending((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumRunningFlushesMetric() {
        String name = "num-running-flushes";
        String description = "Number of currently running flushes";
        this.runAndVerifyMutableMetric("num-running-flushes", "Number of currently running flushes", () -> RocksDBMetrics.addNumRunningFlushesMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddCompactionPendingMetric() {
        String name = "compaction-pending";
        String description = "Reports 1 if at least one compaction is pending, otherwise it reports 0";
        this.runAndVerifyMutableMetric("compaction-pending", "Reports 1 if at least one compaction is pending, otherwise it reports 0", () -> RocksDBMetrics.addCompactionPendingMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumRunningCompactionsMetric() {
        String name = "num-running-compactions";
        String description = "Number of currently running compactions";
        this.runAndVerifyMutableMetric("num-running-compactions", "Number of currently running compactions", () -> RocksDBMetrics.addNumRunningCompactionsMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddEstimatePendingCompactionBytesMetric() {
        String name = "estimate-pending-compaction-bytes";
        String description = "Estimated total number of bytes a compaction needs to rewrite on disk to get all levels down to under target size";
        this.runAndVerifyMutableMetric("estimate-pending-compaction-bytes", "Estimated total number of bytes a compaction needs to rewrite on disk to get all levels down to under target size", () -> RocksDBMetrics.addEstimatePendingCompactionBytesMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddTotalSstFilesSizeMetric() {
        String name = "total-sst-files-size";
        String description = "Total size in bytes of all SST files";
        this.runAndVerifyMutableMetric("total-sst-files-size", "Total size in bytes of all SST files", () -> RocksDBMetrics.addTotalSstFilesSizeMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddLiveSstFilesSizeMetric() {
        String name = "live-sst-files-size";
        String description = "Total size in bytes of all SST files that belong to the latest LSM tree";
        this.runAndVerifyMutableMetric("live-sst-files-size", "Total size in bytes of all SST files that belong to the latest LSM tree", () -> RocksDBMetrics.addLiveSstFilesSizeMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddNumLiveVersionMetric() {
        String name = "num-live-versions";
        String description = "Number of live versions of the LSM tree";
        this.runAndVerifyMutableMetric("num-live-versions", "Number of live versions of the LSM tree", () -> RocksDBMetrics.addNumLiveVersionMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddBlockCacheCapacityMetric() {
        String name = "block-cache-capacity";
        String description = "Capacity of the block cache in bytes";
        this.runAndVerifyMutableMetric("block-cache-capacity", "Capacity of the block cache in bytes", () -> RocksDBMetrics.addBlockCacheCapacityMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddBlockCacheUsageMetric() {
        String name = "block-cache-usage";
        String description = "Memory size of the entries residing in block cache in bytes";
        this.runAndVerifyMutableMetric("block-cache-usage", "Memory size of the entries residing in block cache in bytes", () -> RocksDBMetrics.addBlockCacheUsageMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddBlockCachePinnedUsageMetric() {
        String name = "block-cache-pinned-usage";
        String description = "Memory size for the entries being pinned in the block cache in bytes";
        this.runAndVerifyMutableMetric("block-cache-pinned-usage", "Memory size for the entries being pinned in the block cache in bytes", () -> RocksDBMetrics.addBlockCachePinnedUsageMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddEstimateNumKeysMetric() {
        String name = "estimate-num-keys";
        String description = "Estimated number of keys in the active and unflushed immutable memtables and storage";
        this.runAndVerifyMutableMetric("estimate-num-keys", "Estimated number of keys in the active and unflushed immutable memtables and storage", () -> RocksDBMetrics.addEstimateNumKeysMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddEstimateTableReadersMemMetric() {
        String name = "estimate-table-readers-mem";
        String description = "Estimated memory in bytes used for reading SST tables, excluding memory used in block cache";
        this.runAndVerifyMutableMetric("estimate-table-readers-mem", "Estimated memory in bytes used for reading SST tables, excluding memory used in block cache", () -> RocksDBMetrics.addEstimateTableReadersMemMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    @Test
    public void shouldAddBackgroundErrorsMetric() {
        String name = "background-errors";
        String description = "Total number of background errors";
        this.runAndVerifyMutableMetric("background-errors", "Total number of background errors", () -> RocksDBMetrics.addBackgroundErrorsMetric((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)ROCKSDB_METRIC_CONTEXT, VALUE_PROVIDER));
    }

    private void runAndVerifyMutableMetric(String name, String description, Runnable metricAdder) {
        metricAdder.run();
        ((StreamsMetricsImpl)Mockito.verify((Object)this.streamsMetrics)).addStoreLevelMutableMetric((String)Mockito.eq((Object)TASK_ID), (String)Mockito.eq((Object)STORE_TYPE), (String)Mockito.eq((Object)STORE_NAME), (String)Mockito.eq((Object)name), (String)Mockito.eq((Object)description), (Sensor.RecordingLevel)Mockito.eq((Object)Sensor.RecordingLevel.INFO), (Gauge)Mockito.eq(VALUE_PROVIDER));
    }

    private void verifyRateAndTotalSensor(String metricNamePrefix, String descriptionOfTotal, String descriptionOfRate, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfTotal);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifyRateSensor(String metricNamePrefix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addRateOfSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifyValueSensor(String metricNamePrefix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifySumSensor(String metricNamePrefix, boolean withSuffix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        if (withSuffix) {
            StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        } else {
            StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (boolean)withSuffix, (String)description);
        }
        this.replayCallAndVerify(sensorCreator);
    }

    private void setupStreamsMetricsMock(String metricNamePrefix) {
        Mockito.when((Object)this.streamsMetrics.storeLevelSensor(TASK_ID, STORE_NAME, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.sensor);
        Mockito.when((Object)this.streamsMetrics.storeLevelTagMap(TASK_ID, STORE_TYPE, STORE_NAME)).thenReturn(this.tags);
    }

    private void replayCallAndVerify(SensorCreator sensorCreator) {
        Sensor sensor = sensorCreator.sensor(this.streamsMetrics, ROCKSDB_METRIC_CONTEXT);
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.sensor));
    }

    private static interface SensorCreator {
        public Sensor sensor(StreamsMetricsImpl var1, RocksDBMetrics.RocksDBMetricContext var2);
    }
}

