/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskAndAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TaskAndActionTest {
    TaskAndActionTest() {
    }

    @Test
    public void shouldCreateAddTaskAction() {
        StreamTask task = (StreamTask)Mockito.mock(StreamTask.class);
        TaskAndAction addTask = TaskAndAction.createAddTask((Task)task);
        Assertions.assertEquals((Object)TaskAndAction.Action.ADD, (Object)addTask.getAction());
        Assertions.assertEquals((Object)task, (Object)addTask.getTask());
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((TaskAndAction)addTask).getTaskId());
        Assertions.assertEquals((Object)"Action type ADD cannot have a task ID!", (Object)exception.getMessage());
    }

    @Test
    public void shouldCreateRemoveTaskAction() {
        TaskId taskId = new TaskId(0, 0);
        TaskAndAction removeTask = TaskAndAction.createRemoveTask((TaskId)taskId);
        Assertions.assertEquals((Object)TaskAndAction.Action.REMOVE, (Object)removeTask.getAction());
        Assertions.assertEquals((Object)taskId, (Object)removeTask.getTaskId());
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((TaskAndAction)removeTask).getTask());
        Assertions.assertEquals((Object)"Action type REMOVE cannot have a task!", (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowIfAddTaskActionIsCreatedWithNullTask() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TaskAndAction.createAddTask(null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Task to add is null!"));
    }

    @Test
    public void shouldThrowIfRemoveTaskActionIsCreatedWithNullTaskId() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TaskAndAction.createRemoveTask(null));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Task ID of task to remove is null!"));
    }
}

