/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.SensorAccessor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SourceNodeTest {
    @Test
    public void shouldProvideTopicHeadersAndDataToKeyDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new TheDeserializer(), new TheDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializeKey = (String)sourceNode.deserializeKey("topic", (Headers)headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializeKey, (Matcher)CoreMatchers.is((Object)("topic" + headers + "data")));
    }

    @Test
    public void shouldProvideTopicHeadersAndDataToValueDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new TheDeserializer(), new TheDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializedValue = (String)sourceNode.deserializeValue("topic", (Headers)headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializedValue, (Matcher)CoreMatchers.is((Object)("topic" + headers + "data")));
    }

    @Test
    public void shouldExposeProcessMetrics() {
        Metrics metrics = new Metrics();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test-client", "latest", (Time)new MockTime());
        InternalMockProcessorContext context = new InternalMockProcessorContext(streamsMetrics);
        SourceNode node = new SourceNode(context.currentNode().name(), (Deserializer)new TheDeserializer(), (Deserializer)new TheDeserializer());
        node.init(context);
        String threadId = Thread.currentThread().getName();
        String groupName = "stream-processor-node-metrics";
        Map metricTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)context.taskId().toString()), Utils.mkEntry((Object)"processor-node-id", (Object)node.name())});
        Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-rate", "stream-processor-node-metrics", metricTags));
        Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-total", "stream-processor-node-metrics", metricTags));
        String parentGroupName = "stream-task-metrics";
        metricTags.remove("processor-node-id");
        Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-rate", "stream-task-metrics", metricTags));
        Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(metrics, "process-total", "stream-task-metrics", metricTags));
        String sensorNamePrefix = "internal." + threadId + ".task." + context.taskId().toString();
        Sensor processSensor = metrics.getSensor(sensorNamePrefix + ".node." + context.currentNode().name() + ".s.process");
        SensorAccessor sensorAccessor = new SensorAccessor(processSensor);
        MatcherAssert.assertThat(sensorAccessor.parents().stream().map(Sensor::name).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{sensorNamePrefix + ".s.process"}));
    }

    public static class TheDeserializer
    implements Deserializer<String> {
        public String deserialize(String topic, Headers headers, byte[] data) {
            return topic + headers + new String(data, StandardCharsets.UTF_8);
        }

        public String deserialize(String topic, byte[] data) {
            return this.deserialize(topic, null, data);
        }
    }
}

