/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeWindowedKStreamImplTest {
    private static final String TOPIC = "input";
    private static final Windowed<String> KEY_1_WINDOW_0 = new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L));
    private static final Windowed<String> KEY_1_WINDOW_1 = new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L));
    private static final Windowed<String> KEY_2_WINDOW_1 = new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L));
    private static final Windowed<String> KEY_2_WINDOW_2 = new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L));
    private final StreamsBuilder builder = new StreamsBuilder();
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private TimeWindowedKStream<String, String> windowedStream;
    @Parameterized.Parameter
    public EmitStrategy.StrategyType type;
    @Parameterized.Parameter(value=1)
    public boolean withCache;
    private EmitStrategy emitStrategy;
    private boolean emitFinal;

    @Parameterized.Parameters(name="{0}_cache:{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({EmitStrategy.StrategyType.ON_WINDOW_UPDATE, true}, {EmitStrategy.StrategyType.ON_WINDOW_UPDATE, false}, {EmitStrategy.StrategyType.ON_WINDOW_CLOSE, true}, {EmitStrategy.StrategyType.ON_WINDOW_CLOSE, false});
    }

    @Before
    public void before() {
        this.emitFinal = this.type.equals((Object)EmitStrategy.StrategyType.ON_WINDOW_CLOSE);
        this.emitStrategy = EmitStrategy.StrategyType.forType((EmitStrategy.StrategyType)this.type);
        this.props.setProperty("__emit.interval.ms.kstreams.windowed.aggregation__", "0");
        KStream stream = this.builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.windowedStream = stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).windowedBy((Windows)TimeWindows.ofSizeWithNoGrace((Duration)Duration.ofMillis(500L)));
    }

    @Test
    public void shouldCountWindowed() {
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        this.windowedStream.emitStrategy(this.emitStrategy).count().toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        ArrayList processed = supplier.theCapturedProcessor().processed();
        if (this.emitFinal) {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, Long>(KEY_1_WINDOW_0, 2L, 15L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_1_WINDOW_1, 1L, 500L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_2_WINDOW_1, 2L, 550L)), processed);
        } else {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, Long>(KEY_1_WINDOW_0, 1L, 10L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_1_WINDOW_0, 2L, 15L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_1_WINDOW_1, 1L, 500L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_2_WINDOW_1, 1L, 550L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_2_WINDOW_1, 2L, 550L), new KeyValueTimestamp<Windowed<String>, Long>(KEY_2_WINDOW_2, 1L, 1000L)), processed);
        }
    }

    @Test
    public void shouldReduceWindowed() {
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        this.windowedStream.emitStrategy(this.emitStrategy).reduce(MockReducer.STRING_ADDER).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        ArrayList processed = supplier.theCapturedProcessor().processed();
        if (this.emitFinal) {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "1+2", 15L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_1, "3", 500L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "10+20", 550L)), processed);
        } else {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "1", 10L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "1+2", 15L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_1, "3", 500L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "10", 550L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "10+20", 550L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_2, "30", 1000L)), processed);
        }
    }

    @Test
    public void shouldAggregateWindowed() {
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        this.windowedStream.emitStrategy(this.emitStrategy).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.setMaterializedCache(Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String()))).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        ArrayList processed = supplier.theCapturedProcessor().processed();
        if (this.emitFinal) {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "0+1+2", 15L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_1, "0+3", 500L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "0+10+20", 550L)), processed);
        } else {
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "0+1", 10L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_0, "0+1+2", 15L), new KeyValueTimestamp<Windowed<String>, String>(KEY_1_WINDOW_1, "0+3", 500L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "0+10", 550L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_1, "0+10+20", 550L), new KeyValueTimestamp<Windowed<String>, String>(KEY_2_WINDOW_2, "0+30", 1000L)), processed);
        }
    }

    @Test
    public void shouldMaterializeCount() {
        this.windowedStream.emitStrategy(this.emitStrategy).count(this.setMaterializedCache(Materialized.as((String)"count-store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Long())));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("count-store");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)1L))));
            } else if (!this.emitFinal) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)1L))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)1L))));
            }
            windowStore = driver.getTimestampedWindowStore("count-store");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)ValueAndTimestamp.make((Object)2L, (long)15L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)1L, (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)2L, (long)550L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)1L, (long)1000L)))));
            } else if (!this.emitFinal) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)1L, (long)1000L)))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)1L, (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)2L, (long)550L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)1L, (long)1000L)))));
            }
        }
    }

    @Test
    public void shouldMaterializeReduced() {
        this.windowedStream.reduce(MockReducer.STRING_ADDER, this.setMaterializedCache(Materialized.as((String)"reduced").withKeySerde(Serdes.String()).withValueSerde(Serdes.String())));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("reduced");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)"1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)"3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)"10+20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)"30"))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)"30"))));
            }
            windowStore = driver.getTimestampedWindowStore("reduced");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)ValueAndTimestamp.make((Object)"1+2", (long)15L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)"3", (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)"10+20", (long)550L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)"30", (long)1000L)))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)"30", (long)1000L)))));
            }
        }
    }

    @Test
    public void shouldMaterializeAggregated() {
        this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.setMaterializedCache(Materialized.as((String)"aggregated").withKeySerde(Serdes.String()).withValueSerde(Serdes.String())));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("aggregated");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)"0+1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)"0+3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)"0+10+20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)"0+30"))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)"0+30"))));
            }
            windowStore = driver.getTimestampedWindowStore("aggregated");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            if (this.withCache) {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 500L)), (Object)ValueAndTimestamp.make((Object)"0+1+2", (long)15L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)"0+3", (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(500L, 1000L)), (Object)ValueAndTimestamp.make((Object)"0+10+20", (long)550L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)"0+30", (long)1000L)))));
            } else {
                MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Collections.singletonList(KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(1000L, 1500L)), (Object)ValueAndTimestamp.make((Object)"0+30", (long)1000L)))));
            }
        }
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(null, MockAggregator.TOSTRING_ADDER));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, null));
    }

    @Test
    public void shouldThrowNullPointerOnReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.setMaterializedCache(Materialized.as((String)"store"))));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, null, this.setMaterializedCache(Materialized.as((String)"store"))));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(null, this.setMaterializedCache(Materialized.as((String)"store"))));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(MockReducer.STRING_ADDER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfNamedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(MockReducer.STRING_ADDER, (Named)null));
    }

    @Test
    public void shouldThrowNullPointerOnCountIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.count((Materialized)null));
    }

    private void processData(TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        inputTopic.pipeInput((Object)"1", (Object)"1", 10L);
        inputTopic.pipeInput((Object)"1", (Object)"2", 15L);
        inputTopic.pipeInput((Object)"1", (Object)"3", 500L);
        inputTopic.pipeInput((Object)"2", (Object)"10", 550L);
        inputTopic.pipeInput((Object)"2", (Object)"20", 500L);
        inputTopic.pipeInput((Object)"2", (Object)"30", 1000L);
    }

    private <K, V, S extends StateStore> Materialized<K, V, S> setMaterializedCache(Materialized<K, V, S> materialized) {
        if (this.withCache) {
            return materialized.withCachingEnabled();
        }
        return materialized.withCachingDisabled();
    }
}

