/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class TableTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)600L);
    private KTable<Long, String> leftTable;
    private KTable<Long, String> rightTable;
    private final TestRecord<Long, String> expectedFinalJoinResultUnversioned = new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L));
    private final TestRecord<Long, String> expectedFinalJoinResultLeftVersionedOnly = new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L));
    private final TestRecord<Long, String> expectedFinalJoinResultRightVersionedOnly = new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L));
    private final TestRecord<Long, String> expectedFinalMultiJoinResult = new TestRecord((Object)0L, (Object)"F-f-f", null, Long.valueOf(4L));
    private final String storeName = appID + "-store";
    private final Materialized<Long, String, KeyValueStore<Bytes, byte[]>> materialized = Materialized.as((String)this.storeName).withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()).withCachingDisabled().withLoggingDisabled();

    public TableTableJoinIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "table-table-join-integration-test";
        this.builder = new StreamsBuilder();
    }

    @Test
    public void testInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-null", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultUnversioned, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-null", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"F-f", null, Long.valueOf(4L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerWithVersionedStores() {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
    }

    @Test
    public void testLeftWithVersionedStores() {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
    }

    @Test
    public void testOuterWithVersionedStores() {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, null, null, null);
        this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
    }

    @Test
    public void testInnerWithLeftVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftWithLeftVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-null", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterWithLeftVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"left", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultLeftVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-null", null, Long.valueOf(15L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-f", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerWithRightVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftWithRightVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-null", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(2L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterWithRightVersionedOnly() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentVersionedKeyValueStore((String)"right", (Duration)Duration.ofMinutes(5L))).withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalJoinResultRightVersionedOnly, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"A-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-null", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(2L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"E-e", null, Long.valueOf(15L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-e", null, Long.valueOf(14L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"F-e", null, Long.valueOf(14L))), null);
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.join(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, null, null, Long.valueOf(11L)), new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(7L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.leftJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"null-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(11L))), null, null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
        this.leftTable.outerJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
        if (this.cacheEnabled) {
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.input, this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null-null", null, Long.valueOf(3L))), Arrays.asList(new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L)), new TestRecord((Object)0L, (Object)"A-a-a", null, Long.valueOf(4L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a-a", null, Long.valueOf(5L))), Arrays.asList(new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L)), new TestRecord((Object)0L, (Object)"B-b-b", null, Long.valueOf(6L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"null-b-b", null, Long.valueOf(7L))), Arrays.asList(new TestRecord((Object)0L, null, null, Long.valueOf(8L)), new TestRecord((Object)0L, null, null, Long.valueOf(8L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(9L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L)), new TestRecord((Object)0L, (Object)"C-c-c", null, Long.valueOf(10L))), Arrays.asList(new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L)), new TestRecord((Object)0L, (Object)"C-null-null", null, Long.valueOf(11L))), Collections.singletonList(new TestRecord((Object)0L, null, null, Long.valueOf(12L))), null, Arrays.asList(new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L)), new TestRecord((Object)0L, (Object)"null-d-d", null, Long.valueOf(14L))), Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d-d", null, Long.valueOf(15L))));
            this.runTestWithDriver((List<AbstractJoinIntegrationTest.Input<String>>)this.inputWithoutOutOfOrderData, expectedResult, this.storeName);
        }
    }
}

