/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class TimestampedTupleForwarder<K, V> {
    private final InternalProcessorContext<K, Change<V>> context;
    private final boolean sendOldValues;
    private final boolean cachingEnabled;

    TimestampedTupleForwarder(StateStore store, ProcessorContext<K, Change<V>> context, TimestampedCacheFlushListener<K, V> flushListener, boolean sendOldValues) {
        this.context = (InternalProcessorContext)context;
        this.sendOldValues = sendOldValues;
        this.cachingEnabled = ((WrappedStateStore)store).setFlushListener(flushListener, sendOldValues);
    }

    public void maybeForward(Record<K, Change<V>> record) {
        if (!this.cachingEnabled) {
            if (this.sendOldValues) {
                this.context.forward(record);
            } else {
                this.context.forward(record.withValue(new Change<Object>(record.value().newValue, null)));
            }
        }
    }
}

