/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.CommitCallback;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StateManagerStub;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class NoOpProcessorContext
extends AbstractProcessorContext<Object, Object> {
    public boolean initialized;
    public Map<Object, Object> forwardedValues = new HashMap<Object, Object>();

    public NoOpProcessorContext() {
        super(new TaskId(1, 1), NoOpProcessorContext.streamsConfig(), (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()), null);
    }

    private static StreamsConfig streamsConfig() {
        Properties props = new Properties();
        props.put("application.id", "appId");
        props.put("bootstrap.servers", "boot");
        return new StreamsConfig((Map)props);
    }

    protected StateManager stateManager() {
        return new StateManagerStub();
    }

    public <S extends StateStore> S getStateStore(String name) {
        return null;
    }

    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        return null;
    }

    public <K, V> void forward(Record<K, V> record) {
        this.forward(record.key(), record.value());
    }

    public <K, V> void forward(Record<K, V> record, String childName) {
        this.forward(record.key(), record.value());
    }

    public <K, V> void forward(K key, V value) {
        this.forwardedValues.put(key, value);
    }

    public <K, V> void forward(K key, V value, To to) {
        this.forward(key, value);
    }

    public void commit() {
    }

    public long currentSystemTimeMs() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long currentStreamTimeMs() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void initialize() {
        this.initialized = true;
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallback, CommitCallback checkpoint) {
    }

    public Task.TaskType taskType() {
        return Task.TaskType.ACTIVE;
    }

    public void logChange(String storeName, Bytes key, byte[] value, long timestamp, Position position) {
    }

    public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
    }

    public void transitionToStandby(ThreadCache newCache) {
    }

    public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
        this.cache.addDirtyEntryFlushListener(namespace, listener);
    }

    public String changelogFor(String storeName) {
        return ProcessorStateManager.storeChangelogTopic((String)this.applicationId(), (String)storeName, (String)this.taskId().topologyName());
    }
}

