/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetrics;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.rocksdb.Cache;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TickerType;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RocksDBMetrics.class, Sensor.class})
public class RocksDBMetricsRecorderTest {
    private static final String METRICS_SCOPE = "metrics-scope";
    private static final TaskId TASK_ID1 = new TaskId(0, 0);
    private static final TaskId TASK_ID2 = new TaskId(0, 1);
    private static final String STORE_NAME = "store-name";
    private static final String SEGMENT_STORE_NAME_1 = "segment-store-name-1";
    private static final String SEGMENT_STORE_NAME_2 = "segment-store-name-2";
    private static final String SEGMENT_STORE_NAME_3 = "segment-store-name-3";
    private final RocksDB dbToAdd1 = (RocksDB)EasyMock.mock(RocksDB.class);
    private final RocksDB dbToAdd2 = (RocksDB)EasyMock.mock(RocksDB.class);
    private final RocksDB dbToAdd3 = (RocksDB)EasyMock.mock(RocksDB.class);
    private final Cache cacheToAdd1 = (Cache)EasyMock.mock(Cache.class);
    private final Cache cacheToAdd2 = (Cache)EasyMock.mock(Cache.class);
    private final Statistics statisticsToAdd1 = (Statistics)EasyMock.mock(Statistics.class);
    private final Statistics statisticsToAdd2 = (Statistics)EasyMock.mock(Statistics.class);
    private final Statistics statisticsToAdd3 = (Statistics)EasyMock.mock(Statistics.class);
    private final Sensor bytesWrittenToDatabaseSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesReadFromDatabaseSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableBytesFlushedSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableAvgFlushTimeSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableMinFlushTimeSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableMaxFlushTimeSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor writeStallDurationSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheDataHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheIndexHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheFilterHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesReadDuringCompactionSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesWrittenDuringCompactionSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor compactionTimeAvgSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor compactionTimeMinSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor compactionTimeMaxSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor numberOfOpenFilesSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor numberOfFileErrorsSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)EasyMock.niceMock(StreamsMetricsImpl.class);
    private final RocksDBMetricsRecordingTrigger recordingTrigger = (RocksDBMetricsRecordingTrigger)EasyMock.mock(RocksDBMetricsRecordingTrigger.class);
    private final RocksDBMetricsRecorder recorder = new RocksDBMetricsRecorder("metrics-scope", "store-name");

    @Before
    public void setUp() {
        this.setUpMetricsStubMock();
        EasyMock.expect((Object)this.streamsMetrics.rocksDBMetricsRecordingTrigger()).andStubReturn((Object)this.recordingTrigger);
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        this.recorder.init(this.streamsMetrics, TASK_ID1);
    }

    @Test
    public void shouldInitMetricsRecorder() {
        this.setUpMetricsMock();
        this.recorder.init(this.streamsMetrics, TASK_ID1);
        PowerMock.verify((Object[])new Object[]{RocksDBMetrics.class});
        MatcherAssert.assertThat((Object)this.recorder.taskId(), (Matcher)CoreMatchers.is((Object)TASK_ID1));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentTask() {
        this.setUpMetricsStubMock();
        this.recorder.init(this.streamsMetrics, TASK_ID1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.init(this.streamsMetrics, TASK_ID2));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentStreamsMetrics() {
        this.setUpMetricsStubMock();
        this.recorder.init(this.streamsMetrics, TASK_ID1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.init(new StreamsMetricsImpl(new Metrics(), "test-client", "latest", (Time)new MockTime()), TASK_ID1));
    }

    @Test
    public void shouldSetStatsLevelToExceptDetailedTimersWhenValueProvidersWithStatisticsAreAdded() {
        this.statisticsToAdd1.setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldNotSetStatsLevelToExceptDetailedTimersWhenValueProvidersWithoutStatisticsAreAdded() {
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldThrowIfValueProvidersForASegmentHasBeenAlreadyAdded() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Value providers for store segment-store-name-1 of task " + TASK_ID1 + " has been already added. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfStatisticsToAddIsNotNullButExistingStatisticsAreNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Statistics for segment segment-store-name-2 of task " + TASK_ID1 + " is not null although the statistics of another segment in this metrics recorder is null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfStatisticsToAddIsNullButExistingStatisticsAreNotNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Statistics for segment segment-store-name-2 of task " + TASK_ID1 + " is null although the statistics of another segment in this metrics recorder is not null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNullButExistingCacheIsNotNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, null, this.statisticsToAdd1);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd1, this.statisticsToAdd1));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Cache for segment segment-store-name-2 of task " + TASK_ID1 + " is not null although the cache of another segment in this metrics recorder is null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNotNullButExistingCacheIsNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, null, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Cache for segment segment-store-name-2 of task " + TASK_ID1 + " is null although the cache of another segment in this metrics recorder is not null. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsNotSameAsAllExistingCaches() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd1, this.statisticsToAdd2);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_3, this.dbToAdd3, this.cacheToAdd2, this.statisticsToAdd3));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Caches for store store-name of task " + TASK_ID1 + " are either not all distinct or do not all refer to the same cache. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfCacheToAddIsSameAsOnlyOneOfMultipleCaches() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_3, this.dbToAdd3, this.cacheToAdd1, this.statisticsToAdd3));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("Caches for store store-name of task " + TASK_ID1 + " are either not all distinct or do not all refer to the same cache. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldThrowIfDbToAddWasAlreadyAddedForOtherSegment() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd1, this.cacheToAdd2, this.statisticsToAdd2));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)("DB instance for store segment-store-name-2 of task " + TASK_ID1 + " was already added for another segment as a value provider. This is a bug in Kafka Streams. Please open a bug report under https://issues.apache.org/jira/projects/KAFKA/issues")));
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstValueProvidersAreAddedToNewlyCreatedRecorder() {
        this.recordingTrigger.addMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstValueProvidersAreAddedAfterLastValueProvidersWereRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        this.recordingTrigger.addMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldNotAddItselfToRecordingTriggerWhenNotEmpty2() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldCloseStatisticsWhenValueProvidersAreRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        this.statisticsToAdd1.close();
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldNotCloseStatisticsWhenValueProvidersWithoutStatisticsAreRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldRemoveItselfFromRecordingTriggerWhenLastValueProvidersAreRemoved() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_1);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        this.recordingTrigger.removeMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.removeValueProviders(SEGMENT_STORE_NAME_2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldThrowIfValueProvidersToRemoveNotFound() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.removeValueProviders(SEGMENT_STORE_NAME_2));
    }

    @Test
    public void shouldRecordStatisticsBasedMetrics() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd2});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).andReturn((Object)1L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).andReturn((Object)2L);
        this.bytesWrittenToDatabaseSensor.record(3.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesWrittenToDatabaseSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_READ)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_READ)).andReturn((Object)3L);
        this.bytesReadFromDatabaseSensor.record(5.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesReadFromDatabaseSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).andReturn((Object)4L);
        this.memtableBytesFlushedSensor.record(7.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableBytesFlushedSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).andReturn((Object)1L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).andReturn((Object)4L);
        this.memtableHitRatioSensor.record(0.4, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableHitRatioSensor});
        HistogramData memtableFlushTimeData1 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 2L, 10L, 3.0);
        HistogramData memtableFlushTimeData2 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 20.0, 4L, 8L, 10.0);
        EasyMock.expect((Object)this.statisticsToAdd1.getHistogramData(HistogramType.FLUSH_TIME)).andReturn((Object)memtableFlushTimeData1);
        EasyMock.expect((Object)this.statisticsToAdd2.getHistogramData(HistogramType.FLUSH_TIME)).andReturn((Object)memtableFlushTimeData2);
        this.memtableAvgFlushTimeSensor.record(3.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableAvgFlushTimeSensor});
        this.memtableMinFlushTimeSensor.record(3.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableMinFlushTimeSensor});
        this.memtableMaxFlushTimeSensor.record(20.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableMaxFlushTimeSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.STALL_MICROS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.STALL_MICROS)).andReturn((Object)5L);
        this.writeStallDurationSensor.record(9.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.writeStallDurationSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).andReturn((Object)2L);
        this.blockCacheDataHitRatioSensor.record(0.5714285714285714, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).andReturn((Object)4L);
        this.blockCacheIndexHitRatioSensor.record(0.5, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).andReturn((Object)5L);
        this.blockCacheFilterHitRatioSensor.record(0.35714285714285715, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).andReturn((Object)4L);
        this.bytesWrittenDuringCompactionSensor.record(6.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesWrittenDuringCompactionSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).andReturn((Object)6L);
        this.bytesReadDuringCompactionSensor.record(11.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesReadDuringCompactionSensor});
        HistogramData compactionTimeData1 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 2L, 8L, 6.0);
        HistogramData compactionTimeData2 = new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 24.0, 2L, 8L, 4.0);
        EasyMock.expect((Object)this.statisticsToAdd1.getHistogramData(HistogramType.COMPACTION_TIME)).andReturn((Object)compactionTimeData1);
        EasyMock.expect((Object)this.statisticsToAdd2.getHistogramData(HistogramType.COMPACTION_TIME)).andReturn((Object)compactionTimeData2);
        this.compactionTimeAvgSensor.record(4.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.compactionTimeAvgSensor});
        this.compactionTimeMinSensor.record(4.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.compactionTimeMinSensor});
        this.compactionTimeMaxSensor.record(24.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.compactionTimeMaxSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).andReturn((Object)7L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).andReturn((Object)4L);
        this.numberOfOpenFilesSensor.record(5.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.numberOfOpenFilesSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).andReturn((Object)34L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).andReturn((Object)11L);
        this.numberOfFileErrorsSensor.record(45.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.numberOfFileErrorsSensor});
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd2});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd2});
        PowerMock.verify((Object[])new Object[]{this.bytesWrittenToDatabaseSensor, this.bytesReadFromDatabaseSensor, this.memtableBytesFlushedSensor, this.memtableHitRatioSensor, this.memtableAvgFlushTimeSensor, this.memtableMinFlushTimeSensor, this.memtableMaxFlushTimeSensor, this.writeStallDurationSensor, this.blockCacheDataHitRatioSensor, this.blockCacheIndexHitRatioSensor, this.blockCacheFilterHitRatioSensor, this.bytesWrittenDuringCompactionSensor, this.bytesReadDuringCompactionSensor, this.compactionTimeAvgSensor, this.compactionTimeMinSensor, this.compactionTimeMaxSensor, this.numberOfOpenFilesSensor, this.numberOfFileErrorsSensor});
    }

    @Test
    public void shouldNotRecordStatisticsBasedMetricsIfStatisticsIsNull() {
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, null);
        PowerMock.replay((Object[])new Object[]{this.bytesWrittenToDatabaseSensor, this.bytesReadFromDatabaseSensor, this.memtableBytesFlushedSensor, this.memtableHitRatioSensor, this.memtableAvgFlushTimeSensor, this.memtableMinFlushTimeSensor, this.memtableMaxFlushTimeSensor, this.writeStallDurationSensor, this.blockCacheDataHitRatioSensor, this.blockCacheIndexHitRatioSensor, this.blockCacheFilterHitRatioSensor, this.bytesWrittenDuringCompactionSensor, this.bytesReadDuringCompactionSensor, this.compactionTimeAvgSensor, this.compactionTimeMinSensor, this.compactionTimeMaxSensor, this.numberOfOpenFilesSensor, this.numberOfFileErrorsSensor});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.bytesWrittenToDatabaseSensor, this.bytesReadFromDatabaseSensor, this.memtableBytesFlushedSensor, this.memtableHitRatioSensor, this.memtableAvgFlushTimeSensor, this.memtableMinFlushTimeSensor, this.memtableMaxFlushTimeSensor, this.writeStallDurationSensor, this.blockCacheDataHitRatioSensor, this.blockCacheIndexHitRatioSensor, this.blockCacheFilterHitRatioSensor, this.bytesWrittenDuringCompactionSensor, this.bytesReadDuringCompactionSensor, this.compactionTimeAvgSensor, this.compactionTimeMinSensor, this.compactionTimeMaxSensor, this.numberOfOpenFilesSensor, this.numberOfFileErrorsSensor});
    }

    @Test
    public void shouldCorrectlyHandleHitRatioRecordingsWithZeroHitsAndMisses() {
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        EasyMock.expect((Object)this.statisticsToAdd1.getHistogramData((HistogramType)EasyMock.anyObject())).andStubReturn((Object)new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0L, 0.0));
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount((TickerType)EasyMock.anyObject())).andStubReturn((Object)0L);
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.memtableHitRatioSensor.record(0.0, 0L);
        this.blockCacheDataHitRatioSensor.record(0.0, 0L);
        this.blockCacheIndexHitRatioSensor.record(0.0, 0L);
        this.blockCacheFilterHitRatioSensor.record(0.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.memtableHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
    }

    @Test
    public void shouldCorrectlyHandleAvgRecordingsWithZeroSumAndCount() {
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        EasyMock.expect((Object)this.statisticsToAdd1.getHistogramData((HistogramType)EasyMock.anyObject())).andStubReturn((Object)new HistogramData(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0L, 0.0));
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount((TickerType)EasyMock.anyObject())).andStubReturn((Object)0L);
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.memtableAvgFlushTimeSensor.record(0.0, 0L);
        this.compactionTimeAvgSensor.record(0.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableAvgFlushTimeSensor});
        PowerMock.replay((Object[])new Object[]{this.compactionTimeAvgSensor});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.memtableAvgFlushTimeSensor});
        PowerMock.verify((Object[])new Object[]{this.compactionTimeAvgSensor});
    }

    private void setUpMetricsMock() {
        PowerMock.mockStatic(RocksDBMetrics.class);
        RocksDBMetrics.RocksDBMetricContext metricsContext = new RocksDBMetrics.RocksDBMetricContext(TASK_ID1.toString(), METRICS_SCOPE, STORE_NAME);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesWrittenToDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesReadFromDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableBytesFlushedSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableAvgFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableAvgFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableMinFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableMinFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableMaxFlushTimeSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableMaxFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.writeStallDurationSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheDataHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheIndexHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheFilterHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesWrittenDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesReadDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeAvgSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.compactionTimeAvgSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeMinSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.compactionTimeMinSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeMaxSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.compactionTimeMaxSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.numberOfOpenFilesSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.numberOfFileErrorsSensor);
        RocksDBMetrics.addNumImmutableMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCurSizeActiveMemTable((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCurSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumEntriesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumEntriesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumDeletesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumDeletesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addMemTableFlushPending((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumRunningFlushesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCompactionPendingMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumRunningCompactionsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimatePendingCompactionBytesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addTotalSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addLiveSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumLiveVersionMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCacheCapacityMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCacheUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCachePinnedUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimateNumKeysMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimateTableReadersMemMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBackgroundErrorsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        PowerMock.replay((Object[])new Object[]{RocksDBMetrics.class});
    }

    private void setUpMetricsStubMock() {
        PowerMock.mockStatic(RocksDBMetrics.class);
        RocksDBMetrics.RocksDBMetricContext metricsContext = new RocksDBMetrics.RocksDBMetricContext(TASK_ID1.toString(), METRICS_SCOPE, STORE_NAME);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesWrittenToDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesReadFromDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableBytesFlushedSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableAvgFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableAvgFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableMinFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableMinFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableMaxFlushTimeSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableMaxFlushTimeSensor);
        EasyMock.expect((Object)RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.writeStallDurationSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheDataHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheIndexHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheFilterHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesWrittenDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesReadDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeAvgSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.compactionTimeAvgSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeMinSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.compactionTimeMinSensor);
        EasyMock.expect((Object)RocksDBMetrics.compactionTimeMaxSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.compactionTimeMaxSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.numberOfOpenFilesSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.numberOfFileErrorsSensor);
        RocksDBMetrics.addNumImmutableMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCurSizeActiveMemTable((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCurSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addSizeAllMemTables((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumEntriesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumEntriesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumDeletesActiveMemTableMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumDeletesImmMemTablesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addMemTableFlushPending((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumRunningFlushesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addCompactionPendingMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumRunningCompactionsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimatePendingCompactionBytesMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addTotalSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addLiveSstFilesSizeMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addNumLiveVersionMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCacheCapacityMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCacheUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBlockCachePinnedUsageMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimateNumKeysMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addEstimateTableReadersMemMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        RocksDBMetrics.addBackgroundErrorsMetric((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)), (Gauge)((Gauge)EasyMock.anyObject()));
        PowerMock.replay((Object[])new Object[]{RocksDBMetrics.class});
    }
}

