/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WindowKeySchemaTest {
    private static final Map<SchemaType, SegmentedBytesStore.KeySchema> SCHEMA_TYPE_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), (Object)new WindowKeySchema()), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), (Object)new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema()), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), (Object)new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema())});
    private static final Map<SchemaType, Function<byte[], byte[]>> EXTRACT_STORE_KEY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::extractStoreKeyBytes), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreKeyBytes), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreKeyBytes)});
    private static final Map<SchemaType, BiFunction<byte[], Long, Windowed<Bytes>>> FROM_STORAGE_BYTES_KEY = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::fromStoreBytesKey), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::fromStoreBytesKey), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreBytesKey)});
    private static final Map<SchemaType, BiFunction<Windowed<Bytes>, Integer, Bytes>> WINDOW_TO_STORE_BINARY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary)});
    private static final Map<SchemaType, BiFunction<byte[], Long, Window>> EXTRACT_STORE_WINDOW_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::extractStoreWindow), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreWindow), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreWindow)});
    private static final Map<SchemaType, TriFunction<byte[], Long, Integer, Bytes>> BYTES_TO_STORE_BINARY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary)});
    private static final Map<SchemaType, TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes>> SERDE_TO_STORE_BINARY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary)});
    private static final Map<SchemaType, Function<byte[], Long>> EXTRACT_TS_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::extractStoreTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreTimestamp), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreTimestamp)});
    private static final Map<SchemaType, Function<byte[], Integer>> EXTRACT_SEQ_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.WindowKeySchema), WindowKeySchema::extractStoreSequence), Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::extractStoreSequence), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::extractStoreSequence)});
    private static final Map<SchemaType, Function<byte[], byte[]>> FROM_WINDOW_KEY_MAP = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)((Object)SchemaType.PrefixedKeyFirstSchema), PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::fromNonPrefixWindowKey), Utils.mkEntry((Object)((Object)SchemaType.PrefixedTimeFirstSchema), PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromNonPrefixWindowKey)});
    private final String key = "key";
    private final String topic = "topic";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Serde<String> serde = Serdes.String();
    private final Window window = new TimeWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed((Object)"key", this.window);
    private final SegmentedBytesStore.KeySchema keySchema;
    private final Serde<Windowed<String>> keySerde = new WindowedSerdes.TimeWindowedSerde(this.serde, Long.MAX_VALUE);
    private final StateSerdes<String, byte[]> stateSerdes = new StateSerdes("dummy", this.serde, Serdes.ByteArray());
    private final SchemaType schemaType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"WindowKeySchema", SchemaType.WindowKeySchema}, {"PrefixedTimeFirstSchema", SchemaType.PrefixedTimeFirstSchema}, {"PrefixedKeyFirstSchema", SchemaType.PrefixedKeyFirstSchema});
    }

    public WindowKeySchemaTest(String name, SchemaType type) {
        this.schemaType = type;
        this.keySchema = SCHEMA_TYPE_MAP.get((Object)type);
    }

    private BiFunction<byte[], Long, Windowed<Bytes>> getFromStorageKey() {
        return FROM_STORAGE_BYTES_KEY.get((Object)this.schemaType);
    }

    private BiFunction<byte[], Long, Window> getExtractStoreWindow() {
        return EXTRACT_STORE_WINDOW_MAP.get((Object)this.schemaType);
    }

    private Function<byte[], byte[]> getExtractStorageKey() {
        return EXTRACT_STORE_KEY_MAP.get((Object)this.schemaType);
    }

    private BiFunction<Windowed<Bytes>, Integer, Bytes> getToStoreKeyBinaryWindowParam() {
        return WINDOW_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
    }

    private TriFunction<byte[], Long, Integer, Bytes> getToStoreKeyBinaryBytesParam() {
        return BYTES_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
    }

    private Function<byte[], Long> getExtractTimestampFunc() {
        return EXTRACT_TS_MAP.get((Object)this.schemaType);
    }

    private Function<byte[], Integer> getExtractSeqFunc() {
        return EXTRACT_SEQ_MAP.get((Object)this.schemaType);
    }

    private TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> getSerdeToStoreKey() {
        return SERDE_TO_STORE_BINARY_MAP.get((Object)this.schemaType);
    }

    @Test
    public void testHasNextConditionUsingNullKeys() {
        BiFunction<Windowed<Bytes>, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryWindowParam();
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new TimeWindow(0L, 1L)), 0), (Object)1), KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new TimeWindow(0L, 1L)), 0), (Object)2), KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new TimeWindow(0L, 1L)), 0), (Object)3), KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new TimeWindow(10L, 20L)), 4), (Object)4), KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new TimeWindow(10L, 20L)), 5), (Object)5), KeyValue.pair((Object)toStoreKeyBinary.apply((Windowed<Bytes>)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new TimeWindow(10L, 20L)), 6), (Object)6));
        try (DelegatingPeekingKeyValueIterator iterator = new DelegatingPeekingKeyValueIterator("foo", new KeyValueIteratorStub(keys.iterator()));){
            HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(null, null, 0L, Long.MAX_VALUE, true);
            ArrayList<Object> results = new ArrayList<Object>();
            while (hasNextCondition.hasNext((KeyValueIterator)iterator)) {
                results.add(iterator.next().value);
            }
            MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
        }
    }

    @Test
    public void testUpperBoundWithLargeTimestamps() {
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), Long.MAX_VALUE);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(toStoreKeyBinary.apply(new byte[]{10}, Long.MAX_VALUE, Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(toStoreKeyBinary.apply(new byte[]{10, 11}, Long.MAX_VALUE, Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{-1, -1, -1}, Long.MAX_VALUE, Integer.MAX_VALUE)));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10}, Long.MAX_VALUE, Integer.MAX_VALUE)));
        }
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerThanFirstTimestampByte() {
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, -113, -97}), Long.MAX_VALUE);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"shorter key with max timestamp should be in range", (upper.compareTo(toStoreKeyBinary.apply(new byte[]{10, -113}, Long.MAX_VALUE, Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{-1, -1, -1}, Long.MAX_VALUE, Integer.MAX_VALUE)));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10, -113, -97}, Long.MAX_VALUE, Integer.MAX_VALUE)));
        }
    }

    @Test
    public void testUpperBoundWithKeyBytesLargerAndSmallerThanFirstTimestampByte() {
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{12, 12, 9}), 0xAFFFFFFFFFFFFFFL);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"shorter key with customized timestamp should be in range", (upper.compareTo(toStoreKeyBinary.apply(new byte[]{12, 12}, 0xAFFFFFFFFFFFFFFL, Integer.MAX_VALUE)) >= 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{-1, -1, -1}, 0xAFFFFFFFFFFFFFFL, Integer.MAX_VALUE)));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{12, 12}, 0xAFFFFFFFFFFFFFFL, Integer.MAX_VALUE)));
        }
    }

    @Test
    public void testUpperBoundWithZeroTimestamp() {
        Bytes upper = this.keySchema.upperRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{-1, -1, -1}, 0L, Integer.MAX_VALUE)));
        } else {
            MatcherAssert.assertThat((Object)upper, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10, 11, 12}, 0L, Integer.MAX_VALUE)));
        }
    }

    @Test
    public void testLowerBoundWithZeroTimestamp() {
        Bytes lower = this.keySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0L);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"Larger key prefix should be in range.", (lower.compareTo(toStoreKeyBinary.apply(new byte[]{10, 11, 12, 0}, 0L, 0)) < 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            Bytes expected = Bytes.wrap((byte[])ByteBuffer.allocate(12).put((byte)0).putLong(0L).put(new byte[]{10, 11, 12}).array());
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)expected));
        } else {
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10, 11, 12}, 0L, 0)));
        }
    }

    @Test
    public void testLowerBoundWithNonZeroTimestamp() {
        Bytes lower = this.keySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 42L);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"Larger timestamp should be in range", (lower.compareTo(toStoreKeyBinary.apply(new byte[]{10, 11, 12, 0}, 43L, 0)) < 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            Bytes expected = Bytes.wrap((byte[])ByteBuffer.allocate(12).put((byte)0).putLong(42L).put(new byte[]{10, 11, 12}).array());
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)expected));
        } else {
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10, 11, 12}, 0L, 0)));
        }
    }

    @Test
    public void testLowerBoundMatchesTrailingZeros() {
        Bytes lower = this.keySchema.lowerRange(Bytes.wrap((byte[])new byte[]{10, 11, 12}), 0x7FFFFFFFFFFFFFFEL);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryBytesParam();
        MatcherAssert.assertThat((String)"appending zeros to key should still be in range", (lower.compareTo(toStoreKeyBinary.apply(new byte[]{10, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0x7FFFFFFFFFFFFFFEL, 0)) < 0 ? 1 : 0) != 0);
        if (this.schemaType == SchemaType.PrefixedTimeFirstSchema) {
            Bytes expected = Bytes.wrap((byte[])ByteBuffer.allocate(12).put((byte)0).putLong(0x7FFFFFFFFFFFFFFEL).put(new byte[]{10, 11, 12}).array());
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)expected));
        } else {
            MatcherAssert.assertThat((Object)lower, (Matcher)IsEqual.equalTo((Object)toStoreKeyBinary.apply(new byte[]{10, 11, 12}, 0L, 0)));
        }
    }

    @Test
    public void shouldSerializeDeserialize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = (Windowed)this.keySerde.deserializer().deserialize("topic", bytes);
        Assert.assertEquals((Object)new Windowed((Object)"key", (Window)new TimeWindow(50L, Long.MAX_VALUE)), (Object)result);
    }

    @Test
    public void testSerializeDeserializeOverflowWindowSize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = new TimeWindowedDeserializer(this.serde.deserializer(), Long.valueOf(0x7FFFFFFFFFFFFFFEL)).deserialize("topic", bytes);
        Assert.assertEquals((Object)new Windowed((Object)"key", (Window)new TimeWindow(50L, Long.MAX_VALUE)), (Object)result);
    }

    @Test
    public void shouldSerializeDeserializeExpectedWindowSize() {
        byte[] bytes = this.keySerde.serializer().serialize("topic", this.windowedKey);
        Windowed result = new TimeWindowedDeserializer(this.serde.deserializer(), Long.valueOf(50L)).deserialize("topic", bytes);
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldSerializeDeserializeExpectedChangelogWindowSize() {
        if (this.schemaType != SchemaType.WindowKeySchema) {
            return;
        }
        List<KeyValue> keys = Arrays.asList(KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0}), (Window)new TimeWindow(0L, 1L)), (int)0), (Object)1), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0}), (Window)new TimeWindow(0L, 10L)), (int)0), (Object)10), KeyValue.pair((Object)WindowKeySchema.toStoreKeyBinary((Windowed)new Windowed((Object)Bytes.wrap((byte[])new byte[]{0, 0, 0}), (Window)new TimeWindow(10L, 30L)), (int)6), (Object)20));
        ArrayList<Long> results = new ArrayList<Long>();
        for (KeyValue keyValue : keys) {
            WindowedSerdes.TimeWindowedSerde keySerde = new WindowedSerdes.TimeWindowedSerde(this.serde, (long)((Integer)keyValue.value).intValue()).forChangelog(true);
            Windowed result = (Windowed)keySerde.deserializer().deserialize("topic", ((Bytes)keyValue.key).get());
            Window resultWindow = result.window();
            results.add(resultWindow.end() - resultWindow.start());
        }
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(1L, 10L, 20L)));
    }

    @Test
    public void shouldSerializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.serializer().serialize("topic", null));
    }

    @Test
    public void shouldDeserializeEmptyByteArrayToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @Test
    public void shouldDeserializeNullToNull() {
        Assert.assertNull((Object)this.keySerde.deserializer().deserialize("topic", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() {
        TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> toStoreKeyBinary = this.getSerdeToStoreKey();
        Bytes serialized = toStoreKeyBinary.apply(this.windowedKey, 0, this.stateSerdes);
        Windowed result = this.schemaType == SchemaType.WindowKeySchema ? WindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, (Deserializer)this.stateSerdes.keyDeserializer(), (String)this.stateSerdes.topic()) : (this.schemaType == SchemaType.PrefixedTimeFirstSchema ? PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, (Deserializer)this.stateSerdes.keyDeserializer(), (String)this.stateSerdes.topic()) : PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.fromStoreKey((byte[])serialized.get(), (long)50L, (Deserializer)this.stateSerdes.keyDeserializer(), (String)this.stateSerdes.topic()));
        Assert.assertEquals(this.windowedKey, (Object)result);
    }

    @Test
    public void shouldExtractSequenceFromBinary() {
        TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> toStoreKeyBinary = this.getSerdeToStoreKey();
        Bytes serialized = toStoreKeyBinary.apply(this.windowedKey, 0, this.stateSerdes);
        Function<byte[], Integer> extractStoreSequence = this.getExtractSeqFunc();
        Assert.assertEquals((long)0L, (long)extractStoreSequence.apply(serialized.get()).intValue());
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> toStoreKeyBinary = this.getSerdeToStoreKey();
        Bytes serialized = toStoreKeyBinary.apply(this.windowedKey, 0, this.stateSerdes);
        Function<byte[], Long> extractStoreTimestamp = this.getExtractTimestampFunc();
        Assert.assertEquals((long)50L, (long)extractStoreTimestamp.apply(serialized.get()));
    }

    @Test
    public void shouldExtractWindowFromBinary() {
        TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> toStoreKeyBinary = this.getSerdeToStoreKey();
        Bytes serialized = toStoreKeyBinary.apply(this.windowedKey, 0, this.stateSerdes);
        BiFunction<byte[], Long, Window> extractStoreWindow = this.getExtractStoreWindow();
        Assert.assertEquals((Object)this.window, (Object)extractStoreWindow.apply(serialized.get(), 50L));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        TriFunction<Windowed<String>, Integer, StateSerdes<String, byte[]>, Bytes> toStoreKeyBinary = this.getSerdeToStoreKey();
        Bytes serialized = toStoreKeyBinary.apply(this.windowedKey, 0, this.stateSerdes);
        Function<byte[], byte[]> extractStoreKeyBytes = this.getExtractStorageKey();
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])extractStoreKeyBytes.apply(serialized.get()));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Windowed windowedBytesKey = new Windowed((Object)Bytes.wrap((byte[])"key".getBytes()), this.window);
        BiFunction<Windowed<Bytes>, Integer, Bytes> toStoreKeyBinary = this.getToStoreKeyBinaryWindowParam();
        Bytes serialized = toStoreKeyBinary.apply((Windowed<Bytes>)windowedBytesKey, 0);
        BiFunction<byte[], Long, Windowed<Bytes>> fromStoreBytesKey = this.getFromStorageKey();
        Assert.assertEquals((Object)windowedBytesKey, fromStoreBytesKey.apply(serialized.get(), 50L));
    }

    @Test
    public void shouldConvertFromNonPrefixWindowKey() {
        Function<byte[], byte[]> fromWindowKey = FROM_WINDOW_KEY_MAP.get((Object)this.schemaType);
        TriFunction<byte[], Long, Integer, Bytes> toStoreKeyBinary = BYTES_TO_STORE_BINARY_MAP.get((Object)SchemaType.WindowKeySchema);
        if (fromWindowKey != null) {
            Bytes windowKeyBytes = toStoreKeyBinary.apply("key".getBytes(), 50L, 0);
            byte[] convertedBytes = fromWindowKey.apply(windowKeyBytes.get());
            Function<byte[], Long> extractStoreTimestamp = this.getExtractTimestampFunc();
            Function<byte[], Integer> extractStoreSequence = this.getExtractSeqFunc();
            Function<byte[], byte[]> extractStoreKeyBytes = this.getExtractStorageKey();
            byte[] rawkey = extractStoreKeyBytes.apply(convertedBytes);
            long timestamp = extractStoreTimestamp.apply(convertedBytes);
            int seq = extractStoreSequence.apply(convertedBytes);
            Assert.assertEquals((long)0L, (long)seq);
            Assert.assertEquals((long)50L, (long)timestamp);
            Assert.assertEquals((Object)Bytes.wrap((byte[])"key".getBytes()), (Object)Bytes.wrap((byte[])rawkey));
        }
    }

    private static enum SchemaType {
        WindowKeySchema,
        PrefixedTimeFirstSchema,
        PrefixedKeyFirstSchema;

    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

