/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.AbstractDualSchemaRocksDBSegmentedBytesStoreTest;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RocksDBTimeOrderedSegmentedBytesStoreTest
extends AbstractDualSchemaRocksDBSegmentedBytesStoreTest<KeyValueSegment> {
    private static final String METRICS_SCOPE = "metrics-scope";
    @Parameterized.Parameter
    public String name;
    @Parameterized.Parameter(value=1)
    public boolean hasIndex;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getKeySchema() {
        return Arrays.asList({"WindowSchemaWithIndex", true}, {"WindowSchemaWithoutIndex", false});
    }

    @Override
    AbstractDualSchemaRocksDBSegmentedBytesStore<KeyValueSegment> getBytesStore() {
        return new RocksDBTimeOrderedSegmentedBytesStore("bytes-store", METRICS_SCOPE, 1000L, 60000L, this.hasIndex);
    }

    KeyValueSegments newSegments() {
        return new KeyValueSegments("bytes-store", METRICS_SCOPE, 1000L, 60000L);
    }

    @Override
    SegmentedBytesStore.KeySchema getBaseSchema() {
        return new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema();
    }

    @Override
    SegmentedBytesStore.KeySchema getIndexSchema() {
        return this.hasIndex ? new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema() : null;
    }
}

