/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFlatMapValuesTest {
    private final String topicName = "topic";
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapper mapper = value -> {
            ArrayList<String> result = new ArrayList<String>();
            result.add("v" + value);
            result.add("V" + value);
            return result;
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        stream.flatMapValues(mapper).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            for (int expectedKey : expectedKeys) {
                inputTopic.pipeInput((Object)expectedKey, (Object)expectedKey, 0L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, String>(0, "v0", 0L), new KeyValueTimestamp<Integer, String>(0, "V0", 0L), new KeyValueTimestamp<Integer, String>(1, "v1", 0L), new KeyValueTimestamp<Integer, String>(1, "V1", 0L), new KeyValueTimestamp<Integer, String>(2, "v2", 0L), new KeyValueTimestamp<Integer, String>(2, "V2", 0L), new KeyValueTimestamp<Integer, String>(3, "v3", 0L), new KeyValueTimestamp<Integer, String>(3, "V3", 0L)};
        Assert.assertArrayEquals((Object[])expected, (Object[])supplier.theCapturedProcessor().processed().toArray());
    }

    @Test
    public void testFlatMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey mapper = (readOnlyKey, value) -> {
            ArrayList<String> result = new ArrayList<String>();
            result.add("v" + value);
            result.add("k" + readOnlyKey);
            return result;
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        stream.flatMapValues(mapper).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            for (int expectedKey : expectedKeys) {
                inputTopic.pipeInput((Object)expectedKey, (Object)expectedKey, 0L);
            }
        }
        Object[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<Integer, String>(0, "v0", 0L), new KeyValueTimestamp<Integer, String>(0, "k0", 0L), new KeyValueTimestamp<Integer, String>(1, "v1", 0L), new KeyValueTimestamp<Integer, String>(1, "k1", 0L), new KeyValueTimestamp<Integer, String>(2, "v2", 0L), new KeyValueTimestamp<Integer, String>(2, "k2", 0L), new KeyValueTimestamp<Integer, String>(3, "v3", 0L), new KeyValueTimestamp<Integer, String>(3, "k3", 0L)};
        Assert.assertArrayEquals((Object[])expected, (Object[])supplier.theCapturedProcessor().processed().toArray());
    }
}

