/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.junit.Assert;
import org.junit.Test;

public class MaterializedTest {
    @Test
    public void shouldAllowValidTopicNamesAsStoreName() {
        Materialized.as((String)"valid-name");
        Materialized.as((String)"valid.name");
        Materialized.as((String)"valid_name");
    }

    @Test
    public void shouldNotAllowInvalidTopicNames() {
        String invalidName = "not:valid";
        TopologyException e = (TopologyException)Assert.assertThrows(TopologyException.class, () -> Materialized.as((String)"not:valid"));
        Assert.assertEquals((Object)e.getMessage(), (Object)"Invalid topology: Name \"not:valid\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
    }

    @Test
    public void shouldThrowNullPointerIfWindowBytesStoreSupplierIsNull() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> Materialized.as((WindowBytesStoreSupplier)null));
        Assert.assertEquals((Object)e.getMessage(), (Object)"supplier can't be null");
    }

    @Test
    public void shouldThrowNullPointerIfKeyValueBytesStoreSupplierIsNull() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> Materialized.as((KeyValueBytesStoreSupplier)null));
        Assert.assertEquals((Object)e.getMessage(), (Object)"supplier can't be null");
    }

    @Test
    public void shouldThrowNullPointerIfStoreTypeIsNull() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> Materialized.as((Materialized.StoreType)null));
        Assert.assertEquals((Object)e.getMessage(), (Object)"store type can't be null");
    }

    @Test
    public void shouldThrowNullPointerIfSessionBytesStoreSupplierIsNull() {
        NullPointerException e = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> Materialized.as((SessionBytesStoreSupplier)null));
        Assert.assertEquals((Object)e.getMessage(), (Object)"supplier can't be null");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionIfRetentionIsNegative() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Materialized.as((String)"valid-name").withRetention(Duration.of(-1L, ChronoUnit.DAYS)));
        Assert.assertEquals((Object)e.getMessage(), (Object)"Retention must not be negative.");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionIfStoreSupplierAndStoreTypeBothSet() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Materialized.as((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"test")).withStoreType(Materialized.StoreType.ROCKS_DB));
        Assert.assertEquals((Object)e.getMessage(), (Object)"Cannot set store type when store supplier is pre-configured.");
    }

    @Test
    public void shouldThrowTopologyExceptionIfStoreNameExceedsMaxAllowedLength() {
        StringBuffer invalidStoreNameBuffer = new StringBuffer();
        int maxNameLength = 249;
        for (int i = 0; i < 250; ++i) {
            invalidStoreNameBuffer.append('a');
        }
        String invalidStoreName = invalidStoreNameBuffer.toString();
        TopologyException e = (TopologyException)Assert.assertThrows(TopologyException.class, () -> Materialized.as((String)invalidStoreName));
        Assert.assertEquals((Object)e.getMessage(), (Object)("Invalid topology: Name is illegal, it can't be longer than 249 characters, name: " + invalidStoreName));
    }
}

