/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.StoreToProcessorContextAdapter;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class StoreToProcessorContextAdapterTest {
    @Mock(value=MockType.NICE)
    private StateStoreContext delegate;
    private ProcessorContext context;
    @Mock(value=MockType.NICE)
    private Punctuator punctuator;

    @Before
    public void setUp() {
        this.context = StoreToProcessorContextAdapter.adapt((StateStoreContext)this.delegate);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnCurrentSystemTime() {
        this.context.currentSystemTimeMs();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnCurrentStreamTime() {
        this.context.currentStreamTimeMs();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnGetStateStore() {
        this.context.getStateStore("store");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnScheduleWithDuration() {
        this.context.schedule(Duration.ZERO, PunctuationType.WALL_CLOCK_TIME, this.punctuator);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnForward() {
        this.context.forward((Object)"key", (Object)"value");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnForwardWithTo() {
        this.context.forward((Object)"key", (Object)"value", To.all());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnCommit() {
        this.context.commit();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnTopic() {
        this.context.topic();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnPartition() {
        this.context.partition();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnOffset() {
        this.context.offset();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnHeaders() {
        this.context.headers();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowOnTimestamp() {
        this.context.timestamp();
    }
}

