/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StateManagerStub;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockKeyValueStore;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractProcessorContextTest {
    private final MockStreamsMetrics metrics = new MockStreamsMetrics(new Metrics());
    private final AbstractProcessorContext context = new TestProcessorContext(this.metrics);
    private final MockKeyValueStore stateStore = new MockKeyValueStore("store", false);
    private final Headers headers = new RecordHeaders(new Header[]{new RecordHeader("key", "value".getBytes())});
    private final ProcessorRecordContext recordContext = new ProcessorRecordContext(10L, System.currentTimeMillis(), 1, "foo", this.headers);

    @Before
    public void before() {
        this.context.setRecordContext(this.recordContext);
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnRegisterWhenContextIsInitialized() {
        this.context.initialize();
        try {
            this.context.register((StateStore)this.stateStore, null);
            Assert.fail((String)"should throw illegal state exception when context already initialized");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotThrowIllegalStateExceptionOnRegisterWhenContextIsNotInitialized() {
        this.context.register((StateStore)this.stateStore, null);
    }

    @Test
    public void shouldThrowNullPointerOnRegisterIfStateStoreIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.context.register(null, null));
    }

    @Test
    public void shouldReturnNullTopicIfNoRecordContext() {
        this.context.setRecordContext(null);
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnTopicIfRecordContextTopicIsNull() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, null, (Headers)new RecordHeaders()));
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnTopicFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.topic()));
    }

    @Test
    public void shouldReturnNullIfTopicEqualsNonExistTopic() {
        this.context.setRecordContext(null);
        MatcherAssert.assertThat((Object)this.context.topic(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnDummyPartitionIfNoRecordContext() {
        this.context.setRecordContext(null);
        MatcherAssert.assertThat((Object)this.context.partition(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void shouldReturnPartitionFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.partition(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.partition()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionOnOffsetIfNoRecordContext() {
        this.context.setRecordContext(null);
        try {
            this.context.offset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnOffsetFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.offset(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.offset()));
    }

    @Test
    public void shouldReturnDummyTimestampIfNoRecordContext() {
        this.context.setRecordContext(null);
        MatcherAssert.assertThat((Object)this.context.timestamp(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void shouldReturnTimestampFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.timestamp()));
    }

    @Test
    public void shouldReturnHeadersFromRecordContext() {
        MatcherAssert.assertThat((Object)this.context.headers(), (Matcher)CoreMatchers.equalTo((Object)this.recordContext.headers()));
    }

    @Test
    public void shouldReturnEmptyHeadersIfHeadersAreNotSet() {
        this.context.setRecordContext(null);
        MatcherAssert.assertThat((Object)this.context.headers(), (Matcher)Matchers.is((Matcher)Matchers.emptyIterable()));
    }

    @Test
    public void appConfigsShouldReturnParsedValues() {
        MatcherAssert.assertThat(this.context.appConfigs().get("rocksdb.config.setter"), (Matcher)CoreMatchers.equalTo(RocksDBConfigSetter.class));
    }

    @Test
    public void appConfigsShouldReturnUnrecognizedValues() {
        MatcherAssert.assertThat(this.context.appConfigs().get("user.supplied.config"), (Matcher)CoreMatchers.equalTo((Object)"user-supplied-value"));
    }

    @Test
    public void shouldThrowErrorIfSerdeDefaultNotSet() {
        Properties config = StreamsTestUtils.getStreamsConfig();
        config.put("rocksdb.config.setter", RocksDBConfigSetter.class.getName());
        config.put("user.supplied.config", "user-supplied-value");
        TestProcessorContext pc = new TestProcessorContext(this.metrics, config);
        Assert.assertThrows(ConfigException.class, () -> ((TestProcessorContext)pc).keySerde());
        Assert.assertThrows(ConfigException.class, () -> ((TestProcessorContext)pc).valueSerde());
    }

    private static class TestProcessorContext
    extends AbstractProcessorContext<Object, Object> {
        static Properties config = StreamsTestUtils.getStreamsConfig();

        TestProcessorContext(MockStreamsMetrics metrics) {
            super(new TaskId(0, 0), new StreamsConfig((Map)config), (StreamsMetricsImpl)metrics, new ThreadCache(new LogContext("name "), 0L, (StreamsMetricsImpl)metrics));
        }

        TestProcessorContext(MockStreamsMetrics metrics, Properties config) {
            super(new TaskId(0, 0), new StreamsConfig((Map)config), (StreamsMetricsImpl)metrics, new ThreadCache(new LogContext("name "), 0L, (StreamsMetricsImpl)metrics));
        }

        protected StateManager stateManager() {
            return new StateManagerStub();
        }

        public <S extends StateStore> S getStateStore(String name) {
            return null;
        }

        public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
            return null;
        }

        public <K, V> void forward(Record<K, V> record) {
        }

        public <K, V> void forward(Record<K, V> record, String childName) {
        }

        public <K, V> void forward(K key, V value) {
        }

        public <K, V> void forward(K key, V value, To to) {
        }

        public void commit() {
        }

        public long currentStreamTimeMs() {
            throw new UnsupportedOperationException("this method is not supported in TestProcessorContext");
        }

        public void logChange(String storeName, Bytes key, byte[] value, long timestamp) {
        }

        public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
        }

        public void transitionToStandby(ThreadCache newCache) {
        }

        public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
        }

        public String changelogFor(String storeName) {
            return ProcessorStateManager.storeChangelogTopic((String)this.applicationId(), (String)storeName, (String)this.taskId().topologyName());
        }

        static {
            config.put("rocksdb.config.setter", RocksDBConfigSetter.class.getName());
            config.put("default.value.serde", Serdes.ByteArraySerde.class);
            config.put("default.key.serde", Serdes.ByteArraySerde.class);
            config.put("user.supplied.config", "user-supplied-value");
        }
    }
}

