/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.TopologyTestDriverWrapper;
import org.apache.kafka.streams.TopologyWrapper;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockApiProcessor;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class KTableMapValuesTest {
    private final Consumed<String, String> consumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    private void doTestKTable(StreamsBuilder builder, String topic1, MockProcessorSupplier<String, Integer> supplier) {
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic(topic1, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            inputTopic1.pipeInput((Object)"A", (Object)"1", 5L);
            inputTopic1.pipeInput((Object)"B", (Object)"2", 25L);
            inputTopic1.pipeInput((Object)"C", (Object)"3", 20L);
            inputTopic1.pipeInput((Object)"D", (Object)"4", 10L);
            Assert.assertEquals(Arrays.asList(new KeyValueTimestamp<String, Integer>("A", 1, 5L), new KeyValueTimestamp<String, Integer>("B", 2, 25L), new KeyValueTimestamp<String, Integer>("C", 3, 20L), new KeyValueTimestamp<String, Integer>("D", 4, 10L)), supplier.theCapturedProcessor().processed());
        }
    }

    @Test
    public void testKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.mapValues(value -> value.charAt(0) - 48);
        MockProcessorSupplier<String, Integer> supplier = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(supplier, new String[0]);
        this.doTestKTable(builder, "topic1", supplier);
    }

    @Test
    public void testQueryableKTable() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTable table1 = builder.table("topic1", this.consumed);
        KTable table2 = table1.mapValues(value -> value.charAt(0) - 48, Materialized.as((String)"anyName").withValueSerde(Serdes.Integer()));
        MockProcessorSupplier<String, Integer> supplier = new MockProcessorSupplier<String, Integer>();
        table2.toStream().process(supplier, new String[0]);
        this.doTestKTable(builder, "topic1", supplier);
    }

    private void doTestValueGetter(StreamsBuilder builder, String topic1, KTableImpl<String, String, Integer> table2, KTableImpl<String, String, Integer> table3) {
        Topology topology = builder.build();
        KTableValueGetterSupplier getterSupplier2 = table2.valueGetterSupplier();
        KTableValueGetterSupplier getterSupplier3 = table3.valueGetterSupplier();
        InternalTopologyBuilder topologyBuilder = TopologyWrapper.getInternalTopologyBuilder(topology);
        topologyBuilder.connectProcessorAndStateStores(table2.name, getterSupplier2.storeNames());
        topologyBuilder.connectProcessorAndStateStores(table3.name, getterSupplier3.storeNames());
        try (TopologyTestDriverWrapper driver = new TopologyTestDriverWrapper(builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic(topic1, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            KTableValueGetter getter2 = getterSupplier2.get();
            KTableValueGetter getter3 = getterSupplier3.get();
            getter2.init(driver.setCurrentNodeForProcessorContext(table2.name));
            getter3.init(driver.setCurrentNodeForProcessorContext(table3.name));
            inputTopic1.pipeInput((Object)"A", (Object)"01", 50L);
            inputTopic1.pipeInput((Object)"B", (Object)"01", 10L);
            inputTopic1.pipeInput((Object)"C", (Object)"01", 30L);
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)50L), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)10L), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)30L), (Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)50L), (Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)10L), (Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)30L), (Object)getter3.get((Object)"C"));
            inputTopic1.pipeInput((Object)"A", (Object)"02", 25L);
            inputTopic1.pipeInput((Object)"B", (Object)"02", 20L);
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)25L), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)20L), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)30L), (Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-2, (long)25L), (Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-2, (long)20L), (Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)30L), (Object)getter3.get((Object)"C"));
            inputTopic1.pipeInput((Object)"A", (Object)"03", 35L);
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)3, (long)35L), (Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)20L), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)30L), (Object)getter2.get((Object)"C"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-3, (long)35L), (Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-2, (long)20L), (Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)30L), (Object)getter3.get((Object)"C"));
            inputTopic1.pipeInput((Object)"A", (Object)null, 1L);
            Assert.assertNull((Object)getter2.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)2, (long)20L), (Object)getter2.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)1, (long)30L), (Object)getter2.get((Object)"C"));
            Assert.assertNull((Object)getter3.get((Object)"A"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-2, (long)20L), (Object)getter3.get((Object)"B"));
            Assert.assertEquals((Object)ValueAndTimestamp.make((Object)-1, (long)30L), (Object)getter3.get((Object)"C"));
        }
    }

    @Test
    public void testQueryableValueGetter() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        String storeName2 = "store2";
        String storeName3 = "store3";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s), Materialized.as((String)"store2").withValueSerde(Serdes.Integer()));
        KTableImpl table3 = (KTableImpl)table1.mapValues(value -> Integer.valueOf(value) * -1, Materialized.as((String)"store3").withValueSerde(Serdes.Integer()));
        KTableImpl table4 = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s));
        Assert.assertEquals((Object)"store2", (Object)table2.queryableStoreName());
        Assert.assertEquals((Object)"store3", (Object)table3.queryableStoreName());
        Assert.assertNull((Object)table4.queryableStoreName());
        this.doTestValueGetter(builder, "topic1", (KTableImpl<String, String, Integer>)table2, (KTableImpl<String, String, Integer>)table3);
    }

    @Test
    public void testNotSendingOldValue() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s));
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        Topology topology = builder.build().addProcessor("proc", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic("topic1", (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor proc = supplier.theCapturedProcessor();
            Assert.assertFalse((boolean)table1.sendingOldValueEnabled());
            Assert.assertFalse((boolean)table2.sendingOldValueEnabled());
            inputTopic1.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic1.pipeInput((Object)"B", (Object)"01", 10L);
            inputTopic1.pipeInput((Object)"C", (Object)"01", 15L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)1, null), 5L), new KeyValueTimestamp<String, Change>("B", new Change((Object)1, null), 10L), new KeyValueTimestamp<String, Change>("C", new Change((Object)1, null), 15L));
            inputTopic1.pipeInput((Object)"A", (Object)"02", 10L);
            inputTopic1.pipeInput((Object)"B", (Object)"02", 8L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)2, null), 10L), new KeyValueTimestamp<String, Change>("B", new Change((Object)2, null), 8L));
            inputTopic1.pipeInput((Object)"A", (Object)"03", 20L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)3, null), 20L));
            inputTopic1.pipeInput((Object)"A", (Object)null, 30L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change(null, null), 30L));
        }
    }

    @Test
    public void shouldEnableSendingOldValuesOnParentIfMapValuesNotMaterialized() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s));
        table2.enableSendingOldValues(true);
        MatcherAssert.assertThat((Object)table1.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)table2.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)true));
        this.testSendingOldValues(builder, "topic1", (KTableImpl<String, String, Integer>)table2);
    }

    @Test
    public void shouldNotEnableSendingOldValuesOnParentIfMapValuesMaterialized() {
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic1";
        KTableImpl table1 = (KTableImpl)builder.table("topic1", this.consumed);
        KTableImpl table2 = (KTableImpl)table1.mapValues(s -> Integer.valueOf(s), Materialized.as((String)"bob").withValueSerde(Serdes.Integer()));
        table2.enableSendingOldValues(true);
        MatcherAssert.assertThat((Object)table1.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)table2.sendingOldValueEnabled(), (Matcher)Matchers.is((Object)true));
        this.testSendingOldValues(builder, "topic1", (KTableImpl<String, String, Integer>)table2);
    }

    private void testSendingOldValues(StreamsBuilder builder, String topic1, KTableImpl<String, String, Integer> table2) {
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        builder.build().addProcessor("proc", supplier, new String[]{table2.name});
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic1 = driver.createInputTopic(topic1, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            MockApiProcessor proc = supplier.theCapturedProcessor();
            inputTopic1.pipeInput((Object)"A", (Object)"01", 5L);
            inputTopic1.pipeInput((Object)"B", (Object)"01", 10L);
            inputTopic1.pipeInput((Object)"C", (Object)"01", 15L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)1, null), 5L), new KeyValueTimestamp<String, Change>("B", new Change((Object)1, null), 10L), new KeyValueTimestamp<String, Change>("C", new Change((Object)1, null), 15L));
            inputTopic1.pipeInput((Object)"A", (Object)"02", 10L);
            inputTopic1.pipeInput((Object)"B", (Object)"02", 8L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)2, (Object)1), 10L), new KeyValueTimestamp<String, Change>("B", new Change((Object)2, (Object)1), 8L));
            inputTopic1.pipeInput((Object)"A", (Object)"03", 20L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change((Object)3, (Object)2), 20L));
            inputTopic1.pipeInput((Object)"A", (Object)null, 30L);
            proc.checkAndClearProcessResult(new KeyValueTimestamp<String, Change>("A", new Change(null, (Object)3), 30L));
        }
    }
}

