/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.Arrays;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDbWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.TimeOrderedWindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBTimeOrderedWindowStoreTest {
    private static final long WINDOW_SIZE = 3L;
    private static final long SEGMENT_INTERVAL = 60000L;
    private static final long RETENTION_PERIOD = 120000L;
    private static final String STORE_NAME = "rocksDB time-ordered window store";
    WindowStore<Integer, String> windowStore;
    InternalMockProcessorContext context;
    MockRecordCollector recordCollector;
    final File baseDir = TestUtils.tempDirectory((String)"test");

    @Before
    public void setup() {
        this.windowStore = this.buildWindowStore(120000L, 3L, true, Serdes.Integer(), Serdes.String());
        this.recordCollector = new MockRecordCollector();
        this.context = new InternalMockProcessorContext(this.baseDir, Serdes.String(), Serdes.Integer(), this.recordCollector, new ThreadCache(new LogContext("testCache"), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.context.setTime(1L);
        this.windowStore.init((StateStoreContext)this.context, this.windowStore);
    }

    @After
    public void after() {
        this.windowStore.close();
    }

    <K, V> WindowStore<K, V> buildWindowStore(long retentionPeriod, long windowSize, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde) {
        return new TimeOrderedWindowStoreBuilder((WindowBytesStoreSupplier)new RocksDbWindowBytesStoreSupplier(STORE_NAME, retentionPeriod, Math.max(retentionPeriod / 2L, 60000L), windowSize, retainDuplicates, RocksDbWindowBytesStoreSupplier.WindowStoreTypes.TIME_ORDERED_WINDOW_STORE), keySerde, valueSerde, Time.SYSTEM).build();
    }

    @Test
    public void shouldGetAll() {
        long startTime = 59996L;
        this.windowStore.put((Object)0, (Object)"zero", 59996L);
        this.windowStore.put((Object)1, (Object)"one", 59997L);
        this.windowStore.put((Object)2, (Object)"two", 59998L);
        KeyValue<Windowed<Integer>, String> zero = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = RocksDBTimeOrderedWindowStoreTest.windowedPair(1, "one", 59997L);
        KeyValue<Windowed<Integer>, String> two = RocksDBTimeOrderedWindowStoreTest.windowedPair(2, "two", 59998L);
        Assert.assertEquals(Arrays.asList(zero, one, two), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldGetAllDuplicates() {
        long startTime = 59996L;
        this.windowStore.put((Object)0, (Object)"zero1", 59996L);
        this.windowStore.put((Object)0, (Object)"zero2", 59996L);
        this.windowStore.put((Object)0, (Object)"zero3", 59996L);
        KeyValue<Windowed<Integer>, String> zero1 = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero1", 59996L);
        KeyValue<Windowed<Integer>, String> zero2 = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero2", 59996L);
        KeyValue<Windowed<Integer>, String> zero3 = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero3", 59996L);
        Assert.assertEquals(Arrays.asList(zero1, zero2, zero3), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldGetAllNonDeletedRecords() {
        long startTime = 59996L;
        this.windowStore.put((Object)0, (Object)"zero", 59996L);
        this.windowStore.put((Object)1, (Object)"one", 59997L);
        this.windowStore.put((Object)2, (Object)"two", 59998L);
        this.windowStore.put((Object)3, (Object)"three", 59999L);
        this.windowStore.put((Object)4, (Object)"four", 60000L);
        this.windowStore.put((Object)1, null, 59997L);
        this.windowStore.put((Object)3, null, 59999L);
        KeyValue<Windowed<Integer>, String> zero = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> two = RocksDBTimeOrderedWindowStoreTest.windowedPair(2, "two", 59998L);
        KeyValue<Windowed<Integer>, String> four = RocksDBTimeOrderedWindowStoreTest.windowedPair(4, "four", 60000L);
        Assert.assertEquals(Arrays.asList(zero, two, four), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldDeleteAllDuplicates() {
        long startTime = 59996L;
        this.windowStore.put((Object)0, (Object)"zero1", 59996L);
        this.windowStore.put((Object)0, (Object)"zero2", 59996L);
        this.windowStore.put((Object)0, (Object)"zero3", 59996L);
        this.windowStore.put((Object)1, (Object)"one1", 59997L);
        this.windowStore.put((Object)1, (Object)"one2", 59997L);
        this.windowStore.put((Object)0, null, 59996L);
        KeyValue<Windowed<Integer>, String> one1 = RocksDBTimeOrderedWindowStoreTest.windowedPair(1, "one1", 59997L);
        KeyValue<Windowed<Integer>, String> one2 = RocksDBTimeOrderedWindowStoreTest.windowedPair(1, "one2", 59997L);
        Assert.assertEquals(Arrays.asList(one1, one2), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldGetAllReturnTimestampOrderedRecords() {
        long startTime = 59996L;
        this.windowStore.put((Object)4, (Object)"four", 60000L);
        this.windowStore.put((Object)0, (Object)"zero", 59996L);
        this.windowStore.put((Object)2, (Object)"two1", 59998L);
        this.windowStore.put((Object)3, (Object)"three", 59999L);
        this.windowStore.put((Object)1, (Object)"one", 59997L);
        this.windowStore.put((Object)2, (Object)"two2", 59998L);
        KeyValue<Windowed<Integer>, String> zero = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = RocksDBTimeOrderedWindowStoreTest.windowedPair(1, "one", 59997L);
        KeyValue<Windowed<Integer>, String> two1 = RocksDBTimeOrderedWindowStoreTest.windowedPair(2, "two1", 59998L);
        KeyValue<Windowed<Integer>, String> two2 = RocksDBTimeOrderedWindowStoreTest.windowedPair(2, "two2", 59998L);
        KeyValue<Windowed<Integer>, String> three = RocksDBTimeOrderedWindowStoreTest.windowedPair(3, "three", 59999L);
        KeyValue<Windowed<Integer>, String> four = RocksDBTimeOrderedWindowStoreTest.windowedPair(4, "four", 60000L);
        Assert.assertEquals(Arrays.asList(zero, one, two1, two2, three, four), StreamsTestUtils.toList(this.windowStore.all()));
    }

    @Test
    public void shouldEarlyClosedIteratorStillGetAllRecords() {
        long startTime = 59996L;
        this.windowStore.put((Object)0, (Object)"zero", 59996L);
        this.windowStore.put((Object)1, (Object)"one", 59997L);
        KeyValue<Windowed<Integer>, String> zero = RocksDBTimeOrderedWindowStoreTest.windowedPair(0, "zero", 59996L);
        KeyValue<Windowed<Integer>, String> one = RocksDBTimeOrderedWindowStoreTest.windowedPair(1, "one", 59997L);
        KeyValueIterator it = this.windowStore.all();
        Assert.assertEquals(zero, (Object)it.next());
        it.close();
        Assert.assertEquals(Arrays.asList(zero, one), StreamsTestUtils.toList(this.windowStore.all()));
    }

    private static <K, V> KeyValue<Windowed<K>, V> windowedPair(K key, V value, long timestamp) {
        return RocksDBTimeOrderedWindowStoreTest.windowedPair(key, value, timestamp, 3L);
    }

    private static <K, V> KeyValue<Windowed<K>, V> windowedPair(K key, V value, long timestamp, long windowSize) {
        return KeyValue.pair((Object)new Windowed(key, (Window)WindowKeySchema.timeWindowForSize((long)timestamp, (long)windowSize)), value);
    }
}

