/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferConfigInternal;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;

public class EagerBufferConfigImpl
extends BufferConfigInternal<Suppressed.EagerBufferConfig>
implements Suppressed.EagerBufferConfig {
    private final long maxRecords;
    private final long maxBytes;
    private final Map<String, String> logConfig;

    public EagerBufferConfigImpl(long maxRecords, long maxBytes) {
        this.maxRecords = maxRecords;
        this.maxBytes = maxBytes;
        this.logConfig = Collections.emptyMap();
    }

    private EagerBufferConfigImpl(long maxRecords, long maxBytes, Map<String, String> logConfig) {
        this.maxRecords = maxRecords;
        this.maxBytes = maxBytes;
        this.logConfig = logConfig;
    }

    @Override
    public Suppressed.EagerBufferConfig withMaxRecords(long recordLimit) {
        return new EagerBufferConfigImpl(recordLimit, this.maxBytes, this.logConfig);
    }

    @Override
    public Suppressed.EagerBufferConfig withMaxBytes(long byteLimit) {
        return new EagerBufferConfigImpl(this.maxRecords, byteLimit, this.logConfig);
    }

    @Override
    public long maxRecords() {
        return this.maxRecords;
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public BufferFullStrategy bufferFullStrategy() {
        return BufferFullStrategy.EMIT;
    }

    @Override
    public Suppressed.EagerBufferConfig withLoggingDisabled() {
        return new EagerBufferConfigImpl(this.maxRecords, this.maxBytes, null);
    }

    @Override
    public Suppressed.EagerBufferConfig withLoggingEnabled(Map<String, String> config) {
        return new EagerBufferConfigImpl(this.maxRecords, this.maxBytes, config);
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.logConfig != null;
    }

    @Override
    public Map<String, String> getLogConfig() {
        return this.isLoggingEnabled() ? this.logConfig : Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EagerBufferConfigImpl that = (EagerBufferConfigImpl)o;
        return this.maxRecords == that.maxRecords && this.maxBytes == that.maxBytes;
    }

    public int hashCode() {
        return Objects.hash(this.maxRecords, this.maxBytes);
    }

    public String toString() {
        return "EagerBufferConfigImpl{maxRecords=" + this.maxRecords + ", maxBytes=" + this.maxBytes + '}';
    }
}

