/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.WindowStore;

class KStreamJoinWindow<K, V>
implements ProcessorSupplier<K, V> {
    private final String windowName;

    KStreamJoinWindow(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamJoinWindowProcessor();
    }

    private class KStreamJoinWindowProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, V> window;

        private KStreamJoinWindowProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.window = (WindowStore)context.getStateStore(KStreamJoinWindow.this.windowName);
        }

        @Override
        public void process(K key, V value) {
            if (key != null) {
                this.context().forward(key, value);
                this.window.put(key, value, this.context().timestamp());
            }
        }
    }
}

