/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;

public class WindowStoreBuilder<K, V>
extends AbstractStoreBuilder<K, V, WindowStore<K, V>> {
    private final WindowBytesStoreSupplier storeSupplier;

    public WindowStoreBuilder(WindowBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(storeSupplier.name(), keySerde, valueSerde, time);
        this.storeSupplier = storeSupplier;
    }

    @Override
    public WindowStore<K, V> build() {
        return new MeteredWindowStore(this.maybeWrapCaching(this.maybeWrapLogging((WindowStore)this.storeSupplier.get())), this.storeSupplier.windowSize(), this.storeSupplier.metricsScope(), this.time, this.keySerde, this.valueSerde);
    }

    private WindowStore<Bytes, byte[]> maybeWrapCaching(WindowStore<Bytes, byte[]> inner) {
        if (!this.enableCaching) {
            return inner;
        }
        return new CachingWindowStore(inner, this.storeSupplier.windowSize(), this.storeSupplier.segmentIntervalMs());
    }

    private WindowStore<Bytes, byte[]> maybeWrapLogging(WindowStore<Bytes, byte[]> inner) {
        if (!this.enableLogging) {
            return inner;
        }
        return new ChangeLoggingWindowBytesStore(inner, this.storeSupplier.retainDuplicates());
    }

    public long retentionPeriod() {
        return this.storeSupplier.retentionPeriod();
    }
}

