/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferConfigInternal;
import org.apache.kafka.streams.kstream.internals.suppress.NamedSuppressed;
import org.apache.kafka.streams.kstream.internals.suppress.StrictBufferConfigImpl;
import org.apache.kafka.streams.kstream.internals.suppress.TimeDefinitions;

public class SuppressedInternal<K>
implements Suppressed<K>,
NamedSuppressed<K> {
    private static final Duration DEFAULT_SUPPRESSION_TIME = Duration.ofMillis(Long.MAX_VALUE);
    private static final StrictBufferConfigImpl DEFAULT_BUFFER_CONFIG = (StrictBufferConfigImpl)Suppressed.BufferConfig.unbounded();
    private final String name;
    private final BufferConfigInternal bufferConfig;
    private final Duration timeToWaitForMoreEvents;
    private final TimeDefinitions.TimeDefinition<K> timeDefinition;
    private final boolean safeToDropTombstones;

    public SuppressedInternal(String name, Duration suppressionTime, Suppressed.BufferConfig bufferConfig, TimeDefinitions.TimeDefinition<K> timeDefinition, boolean safeToDropTombstones) {
        this.name = name;
        this.timeToWaitForMoreEvents = suppressionTime == null ? DEFAULT_SUPPRESSION_TIME : suppressionTime;
        this.timeDefinition = timeDefinition == null ? TimeDefinitions.RecordTimeDefintion.instance() : timeDefinition;
        this.bufferConfig = bufferConfig == null ? DEFAULT_BUFFER_CONFIG : (BufferConfigInternal)bufferConfig;
        this.safeToDropTombstones = safeToDropTombstones;
    }

    @Override
    public Suppressed<K> withName(String name) {
        return new SuppressedInternal<K>(name, this.timeToWaitForMoreEvents, this.bufferConfig, this.timeDefinition, this.safeToDropTombstones);
    }

    @Override
    public String name() {
        return this.name;
    }

    BufferConfigInternal bufferConfig() {
        return this.bufferConfig;
    }

    TimeDefinitions.TimeDefinition<K> timeDefinition() {
        return this.timeDefinition;
    }

    Duration timeToWaitForMoreEvents() {
        return this.timeToWaitForMoreEvents == null ? Duration.ZERO : this.timeToWaitForMoreEvents;
    }

    boolean safeToDropTombstones() {
        return this.safeToDropTombstones;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuppressedInternal that = (SuppressedInternal)o;
        return this.safeToDropTombstones == that.safeToDropTombstones && Objects.equals(this.name, that.name) && Objects.equals(this.bufferConfig, that.bufferConfig) && Objects.equals(this.timeToWaitForMoreEvents, that.timeToWaitForMoreEvents) && Objects.equals(this.timeDefinition, that.timeDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bufferConfig, this.timeToWaitForMoreEvents, this.timeDefinition, this.safeToDropTombstones);
    }

    public String toString() {
        return "SuppressedInternal{name='" + this.name + '\'' + ", bufferConfig=" + this.bufferConfig + ", timeToWaitForMoreEvents=" + this.timeToWaitForMoreEvents + ", timeDefinition=" + this.timeDefinition + ", safeToDropTombstones=" + this.safeToDropTombstones + '}';
    }
}

