/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class StatefulProcessorNode<K, V>
extends ProcessorGraphNode<K, V> {
    private final String[] storeNames;
    private final StoreBuilder<? extends StateStore> storeBuilder;

    public StatefulProcessorNode(String nodeName, ProcessorParameters<K, V> processorParameters, String[] storeNames) {
        super(nodeName, processorParameters);
        this.storeNames = storeNames;
        this.storeBuilder = null;
    }

    public StatefulProcessorNode(String nodeName, ProcessorParameters<K, V> processorParameters, StoreBuilder<? extends StateStore> materializedKTableStoreBuilder) {
        super(nodeName, processorParameters);
        this.storeNames = null;
        this.storeBuilder = materializedKTableStoreBuilder;
    }

    @Override
    public String toString() {
        return "StatefulProcessorNode{storeNames=" + Arrays.toString(this.storeNames) + ", storeBuilder=" + this.storeBuilder + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String processorName = this.processorParameters().processorName();
        ProcessorSupplier processorSupplier = this.processorParameters().processorSupplier();
        topologyBuilder.addProcessor(processorName, processorSupplier, this.parentNodeNames());
        if (this.storeNames != null && this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
        if (this.storeBuilder != null) {
            topologyBuilder.addStateStore(this.storeBuilder, processorName);
        }
    }
}

