/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;

public abstract class BaseRepartitionNode<K, V>
extends StreamsGraphNode {
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final String sinkName;
    protected final String sourceName;
    protected final String repartitionTopic;
    protected final ProcessorParameters processorParameters;

    BaseRepartitionNode(String nodeName, String sourceName, ProcessorParameters processorParameters, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic) {
        super(nodeName);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.repartitionTopic = repartitionTopic;
        this.processorParameters = processorParameters;
    }

    abstract Serializer<V> getValueSerializer();

    abstract Deserializer<V> getValueDeserializer();

    @Override
    public String toString() {
        return "BaseRepartitionNode{keySerde=" + this.keySerde + ", valueSerde=" + this.valueSerde + ", sinkName='" + this.sinkName + '\'' + ", sourceName='" + this.sourceName + '\'' + ", repartitionTopic='" + this.repartitionTopic + '\'' + ", processorParameters=" + this.processorParameters + "} " + super.toString();
    }
}

