/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;

public class TransformerSupplierAdapter<KIn, VIn, KOut, VOut>
implements TransformerSupplier<KIn, VIn, Iterable<KeyValue<KOut, VOut>>> {
    private TransformerSupplier<KIn, VIn, KeyValue<KOut, VOut>> transformerSupplier;

    public TransformerSupplierAdapter(TransformerSupplier<KIn, VIn, KeyValue<KOut, VOut>> transformerSupplier) {
        this.transformerSupplier = transformerSupplier;
    }

    @Override
    public Transformer<KIn, VIn, Iterable<KeyValue<KOut, VOut>>> get() {
        return new Transformer<KIn, VIn, Iterable<KeyValue<KOut, VOut>>>(){
            private Transformer<KIn, VIn, KeyValue<KOut, VOut>> transformer;
            {
                this.transformer = TransformerSupplierAdapter.this.transformerSupplier.get();
            }

            @Override
            public void init(ProcessorContext context) {
                this.transformer.init(context);
            }

            @Override
            public Iterable<KeyValue<KOut, VOut>> transform(KIn key, VIn value) {
                KeyValue pair = this.transformer.transform(key, value);
                if (pair != null) {
                    return Collections.singletonList(pair);
                }
                return Collections.emptyList();
            }

            @Override
            public void close() {
                this.transformer.close();
            }
        };
    }
}

