/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.testutil;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LogCaptureAppender
extends AppenderSkeleton {
    private final LinkedList<LoggingEvent> events = new LinkedList();

    public static LogCaptureAppender createAndRegister() {
        LogCaptureAppender logCaptureAppender = new LogCaptureAppender();
        Logger.getRootLogger().addAppender((Appender)logCaptureAppender);
        return logCaptureAppender;
    }

    public static void setClassLoggerToDebug(Class<?> clazz) {
        Logger.getLogger(clazz).setLevel(Level.DEBUG);
    }

    public static void unregister(LogCaptureAppender logCaptureAppender) {
        Logger.getRootLogger().removeAppender((Appender)logCaptureAppender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        LinkedList<LoggingEvent> linkedList = this.events;
        synchronized (linkedList) {
            this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages() {
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<LoggingEvent> linkedList = this.events;
        synchronized (linkedList) {
            for (LoggingEvent event : this.events) {
                result.add(event.getRenderedMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getEvents() {
        LinkedList<Event> result = new LinkedList<Event>();
        LinkedList<LoggingEvent> linkedList = this.events;
        synchronized (linkedList) {
            for (LoggingEvent event : this.events) {
                Optional<String> throwableString;
                String[] throwableStrRep = event.getThrowableStrRep();
                if (throwableStrRep == null) {
                    throwableString = Optional.empty();
                } else {
                    StringBuilder throwableStringBuilder = new StringBuilder();
                    for (String s : throwableStrRep) {
                        throwableStringBuilder.append(s);
                    }
                    throwableString = Optional.of(throwableStringBuilder.toString());
                }
                result.add(new Event(event.getLevel().toString(), event.getRenderedMessage(), throwableString));
            }
        }
        return result;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public static class Event {
        private String level;
        private String message;
        private Optional<String> throwableInfo;

        Event(String level, String message, Optional<String> throwableInfo) {
            this.level = level;
            this.message = message;
            this.throwableInfo = throwableInfo;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Optional<String> getThrowableInfo() {
            return this.throwableInfo;
        }
    }
}

