/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.File;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;

public class SmokeTestUtil {
    static final int END = Integer.MAX_VALUE;
    public static Serde<String> stringSerde = Serdes.String();
    public static Serde<Integer> intSerde = Serdes.Integer();
    static Serde<Long> longSerde = Serdes.Long();
    static Serde<Double> doubleSerde = Serdes.Double();

    static ProcessorSupplier<Object, Object> printProcessorSupplier(String topic) {
        return SmokeTestUtil.printProcessorSupplier(topic, false);
    }

    private static ProcessorSupplier<Object, Object> printProcessorSupplier(final String topic, boolean printOffset) {
        return new ProcessorSupplier<Object, Object>(){

            public Processor<Object, Object> get() {
                return new AbstractProcessor<Object, Object>(){
                    private int numRecordsProcessed = 0;

                    public void init(ProcessorContext context) {
                        super.init(context);
                        System.out.println("initializing processor: topic=" + topic + " taskId=" + context.taskId());
                        this.numRecordsProcessed = 0;
                    }

                    public void process(Object key, Object value) {
                        ++this.numRecordsProcessed;
                        if (this.numRecordsProcessed % 100 == 0) {
                            System.out.println(System.currentTimeMillis());
                            System.out.println("processed " + this.numRecordsProcessed + " records from topic=" + topic);
                        }
                    }
                };
            }
        };
    }

    static File createDir(File parent, String child) {
        File dir = new File(parent, child);
        dir.mkdir();
        return dir;
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Agg {
        KeyValueMapper<String, Long, KeyValue<String, Long>> selector() {
            return new KeyValueMapper<String, Long, KeyValue<String, Long>>(){

                public KeyValue<String, Long> apply(String key, Long value) {
                    return new KeyValue((Object)(value == null ? null : Long.toString(value)), (Object)1L);
                }
            };
        }

        public Initializer<Long> init() {
            return new Initializer<Long>(){

                public Long apply() {
                    return 0L;
                }
            };
        }

        Aggregator<String, Long, Long> adder() {
            return new Aggregator<String, Long, Long>(){

                public Long apply(String aggKey, Long value, Long aggregate) {
                    return aggregate + value;
                }
            };
        }

        Aggregator<String, Long, Long> remover() {
            return new Aggregator<String, Long, Long>(){

                public Long apply(String aggKey, Long value, Long aggregate) {
                    return aggregate - value;
                }
            };
        }
    }

    public static final class Unwindow<K, V>
    implements KeyValueMapper<Windowed<K>, V, K> {
        public K apply(Windowed<K> winKey, V value) {
            return (K)winKey.key();
        }
    }
}

