/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.state.KeyValueStore;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalProcessorContextImplTest {
    private static final String GLOBAL_STORE_NAME = "global-store";
    private static final String UNKNOWN_STORE = "unknown-store";
    private static final String CHILD_PROCESSOR = "child";
    private GlobalProcessorContextImpl globalContext;
    private ProcessorNode child;
    private ProcessorRecordContext recordContext;

    @Before
    public void setup() {
        StreamsConfig streamsConfig = (StreamsConfig)EasyMock.mock(StreamsConfig.class);
        EasyMock.expect((Object)streamsConfig.getString("application.id")).andReturn((Object)"dummy-id");
        EasyMock.expect((Object)streamsConfig.defaultValueSerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.expect((Object)streamsConfig.defaultKeySerde()).andReturn((Object)Serdes.ByteArray());
        EasyMock.replay((Object[])new Object[]{streamsConfig});
        StateManager stateManager = (StateManager)EasyMock.mock(StateManager.class);
        EasyMock.expect((Object)stateManager.getGlobalStore(GLOBAL_STORE_NAME)).andReturn(EasyMock.mock(KeyValueStore.class));
        EasyMock.expect((Object)stateManager.getGlobalStore(UNKNOWN_STORE)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{stateManager});
        this.globalContext = new GlobalProcessorContextImpl(streamsConfig, stateManager, null, null);
        ProcessorNode processorNode = (ProcessorNode)EasyMock.mock(ProcessorNode.class);
        this.globalContext.setCurrentNode(processorNode);
        this.child = (ProcessorNode)EasyMock.mock(ProcessorNode.class);
        EasyMock.expect((Object)processorNode.children()).andReturn(Collections.singletonList(this.child)).anyTimes();
        EasyMock.expect((Object)processorNode.getChild(CHILD_PROCESSOR)).andReturn((Object)this.child);
        EasyMock.expect((Object)processorNode.getChild(EasyMock.anyString())).andReturn(null);
        EasyMock.replay((Object[])new Object[]{processorNode});
        this.recordContext = (ProcessorRecordContext)EasyMock.mock(ProcessorRecordContext.class);
        this.globalContext.setRecordContext(this.recordContext);
    }

    @Test
    public void shouldReturnGlobalOrNullStore() {
        Assert.assertThat((Object)this.globalContext.getStateStore(GLOBAL_STORE_NAME), (Matcher)new IsInstanceOf(KeyValueStore.class));
        Assert.assertNull((Object)this.globalContext.getStateStore(UNKNOWN_STORE));
    }

    @Test
    public void shouldForwardToSingleChild() {
        this.child.process(null, null);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.child, this.recordContext});
        this.globalContext.forward(null, null);
        EasyMock.verify((Object[])new Object[]{this.child, this.recordContext});
    }

    @Test(expected=IllegalStateException.class)
    public void shouldFailToForwardUsingToParameter() {
        this.globalContext.forward(null, null, To.all());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotSupportForwardingViaChildIndex() {
        this.globalContext.forward(null, null, 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotSupportForwardingViaChildName() {
        this.globalContext.forward(null, null, "processorName");
    }

    @Test
    public void shouldNotFailOnNoOpCommit() {
        this.globalContext.commit();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowToSchedulePunctuationsUsingDeprecatedApi() {
        this.globalContext.schedule(0L, null, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowToSchedulePunctuations() {
        this.globalContext.schedule(null, null, null);
    }
}

