/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreIteratorWrapper;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBWindowStore<K, V>
extends WrappedStateStore<SegmentedBytesStore>
implements WindowStore<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final boolean retainDuplicates;
    private final long windowSize;
    private ProcessorContext context;
    private StateSerdes<K, V> serdes;
    private int seqnum = 0;

    RocksDBWindowStore(SegmentedBytesStore bytesStore, Serde<K> keySerde, Serde<V> valueSerde, boolean retainDuplicates, long windowSize) {
        super(bytesStore);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.retainDuplicates = retainDuplicates;
        this.windowSize = windowSize;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.context = context;
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        super.init(context, root);
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public void put(K key, V value, long windowStartTimestamp) {
        this.maybeUpdateSeqnumForDups();
        ((SegmentedBytesStore)this.wrapped()).put(WindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, this.seqnum, this.serdes), this.serdes.rawValue(value));
    }

    @Override
    public V fetch(K key, long timestamp) {
        byte[] bytesValue = ((SegmentedBytesStore)this.wrapped()).get(WindowKeySchema.toStoreKeyBinary(key, timestamp, this.seqnum, this.serdes));
        if (bytesValue == null) {
            return null;
        }
        return this.serdes.valueFrom(bytesValue);
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(Bytes.wrap((byte[])this.serdes.rawKey(key)), timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).valuesIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(Bytes.wrap((byte[])this.serdes.rawKey(from)), Bytes.wrap((byte[])this.serdes.rawKey(to)), timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).all();
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        return new WindowStoreIteratorWrapper<K, V>(bytesIterator, this.serdes, this.windowSize).keyValueIterator();
    }

    private void maybeUpdateSeqnumForDups() {
        if (this.retainDuplicates) {
            this.seqnum = this.seqnum + 1 & Integer.MAX_VALUE;
        }
    }
}

