/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class GroupedTableOperationRepartitionNode<K, V>
extends BaseRepartitionNode<K, V> {
    private GroupedTableOperationRepartitionNode(String nodeName, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String sourceName, String repartitionTopic, ProcessorParameters processorParameters) {
        super(nodeName, sourceName, processorParameters, keySerde, valueSerde, sinkName, repartitionTopic);
    }

    @Override
    Serializer<V> getValueSerializer() {
        Serializer valueSerializer = this.valueSerde == null ? null : this.valueSerde.serializer();
        return this.unsafeCastChangedToValueSerializer(valueSerializer);
    }

    private Serializer<V> unsafeCastChangedToValueSerializer(Serializer<V> valueSerializer) {
        return new ChangedSerializer<V>(valueSerializer);
    }

    @Override
    Deserializer<V> getValueDeserializer() {
        Deserializer valueDeserializer = this.valueSerde == null ? null : this.valueSerde.deserializer();
        return this.unsafeCastChangedToValueDeserializer(valueDeserializer);
    }

    private Deserializer<V> unsafeCastChangedToValueDeserializer(Deserializer<? extends V> valueDeserializer) {
        return new ChangedDeserializer<V>(valueDeserializer);
    }

    @Override
    public String toString() {
        return "GroupedTableOperationRepartitionNode{} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        Serializer keySerializer = this.keySerde != null ? this.keySerde.serializer() : null;
        Deserializer keyDeserializer = this.keySerde != null ? this.keySerde.deserializer() : null;
        topologyBuilder.addInternalTopic(this.repartitionTopic);
        topologyBuilder.addSink(this.sinkName, this.repartitionTopic, keySerializer, this.getValueSerializer(), null, this.parentNodeNames());
        topologyBuilder.addSource(null, this.sourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), keyDeserializer, this.getValueDeserializer(), this.repartitionTopic);
    }

    public static <K1, V1> GroupedTableOperationRepartitionNodeBuilder<K1, V1> groupedTableOperationNodeBuilder() {
        return new GroupedTableOperationRepartitionNodeBuilder();
    }

    public static final class GroupedTableOperationRepartitionNodeBuilder<K, V> {
        private Serde<K> keySerde;
        private Serde<V> valueSerde;
        private String sinkName;
        private String nodeName;
        private String sourceName;
        private String repartitionTopic;
        private ProcessorParameters processorParameters;

        private GroupedTableOperationRepartitionNodeBuilder() {
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withKeySerde(Serde<K> keySerde) {
            this.keySerde = keySerde;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withValueSerde(Serde<V> valueSerde) {
            this.valueSerde = valueSerde;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withSinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withRepartitionTopic(String repartitionTopic) {
            this.repartitionTopic = repartitionTopic;
            return this;
        }

        public GroupedTableOperationRepartitionNodeBuilder<K, V> withProcessorParameters(ProcessorParameters processorParameters) {
            this.processorParameters = processorParameters;
            return this;
        }

        public GroupedTableOperationRepartitionNode<K, V> build() {
            return new GroupedTableOperationRepartitionNode(this.nodeName, this.keySerde, this.valueSerde, this.sinkName, this.sourceName, this.repartitionTopic, this.processorParameters);
        }
    }
}

