/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBStoreTest;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;

public class RocksDBTimestampedStoreTest
extends RocksDBStoreTest {
    @Override
    RocksDBStore getRocksDBStore() {
        return new RocksDBTimestampedStore("db-name");
    }

    @Test
    public void shouldMigrateDataFromDefaultToTimestampColumnFamily() throws Exception {
        this.prepareOldStore();
        LogCaptureAppender.setClassLoggerToDebug(RocksDBTimestampedStore.class);
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in upgrade mode"));
        LogCaptureAppender.unregister(appender);
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)this.rocksDBStore.get(new Bytes("unknown".getBytes())), (Matcher)new IsNull());
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        Assert.assertThat((Object)this.rocksDBStore.get(new Bytes("key1".getBytes())).length, (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        this.rocksDBStore.put(new Bytes("key2".getBytes()), "timestamp+22".getBytes());
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        this.rocksDBStore.put(new Bytes("key3".getBytes()), null);
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        this.rocksDBStore.put(new Bytes("key8".getBytes()), "timestamp+88888888".getBytes());
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key4".getBytes()), "timestamp+4444".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key11".getBytes()), "timestamp+11111111111".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key5".getBytes()), null).length, (Matcher)CoreMatchers.is((Object)13));
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key12".getBytes()), null), (Matcher)new IsNull());
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertThat((Object)this.rocksDBStore.delete(new Bytes("key6".getBytes())).length, (Matcher)CoreMatchers.is((Object)14));
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)3L));
        this.iteratorsShouldNotMigrateData();
        Assert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)3L));
        this.rocksDBStore.close();
        this.verifyOldAndNewColumnFamily();
    }

    private void iteratorsShouldNotMigrateData() {
        KeyValueIterator itAll = this.rocksDBStore.all();
        KeyValue keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key1".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 49}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key11".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key2".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 50, 50}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key4".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 52, 52, 52, 52}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key5".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 53, 53, 53, 53, 53}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key7".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 55, 55, 55, 55, 55, 55, 55}, (byte[])((byte[])keyValue.value));
        keyValue = (KeyValue)itAll.next();
        Assert.assertArrayEquals((byte[])"key8".getBytes(), (byte[])((Bytes)keyValue.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 56, 56, 56, 56, 56, 56, 56, 56}, (byte[])((byte[])keyValue.value));
        Assert.assertFalse((boolean)itAll.hasNext());
        itAll.close();
        KeyValueIterator it = this.rocksDBStore.range(new Bytes("key2".getBytes()), new Bytes("key5".getBytes()));
        KeyValue keyValue2 = (KeyValue)it.next();
        Assert.assertArrayEquals((byte[])"key2".getBytes(), (byte[])((Bytes)keyValue2.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 50, 50}, (byte[])((byte[])keyValue2.value));
        keyValue2 = (KeyValue)it.next();
        Assert.assertArrayEquals((byte[])"key4".getBytes(), (byte[])((Bytes)keyValue2.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 52, 52, 52, 52}, (byte[])((byte[])keyValue2.value));
        keyValue2 = (KeyValue)it.next();
        Assert.assertArrayEquals((byte[])"key5".getBytes(), (byte[])((Bytes)keyValue2.key).get());
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 53, 53, 53, 53, 53}, (byte[])((byte[])keyValue2.value));
        Assert.assertFalse((boolean)it.hasNext());
        it.close();
    }

    private void verifyOldAndNewColumnFamily() throws Exception {
        DBOptions dbOptions = new DBOptions();
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions), new ColumnFamilyDescriptor("keyValueWithTimestamp".getBytes(StandardCharsets.UTF_8), columnFamilyOptions));
        ArrayList columnFamilies = new ArrayList(columnFamilyDescriptors.size());
        RocksDB db = RocksDB.open((DBOptions)dbOptions, (String)new File(new File(this.context.stateDir(), "rocksdb"), "db-name").getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
        ColumnFamilyHandle noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
        ColumnFamilyHandle withTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(1);
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "unknown".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key1".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key2".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key3".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key4".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key5".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key6".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key7".getBytes()).length, (Matcher)CoreMatchers.is((Object)7));
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key8".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key11".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(noTimestampColumnFamily, "key12".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "unknown".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key1".getBytes()).length, (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key2".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key3".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key4".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key5".getBytes()).length, (Matcher)CoreMatchers.is((Object)13));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key6".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key7".getBytes()), (Matcher)new IsNull());
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key8".getBytes()).length, (Matcher)CoreMatchers.is((Object)18));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key11".getBytes()).length, (Matcher)CoreMatchers.is((Object)21));
        Assert.assertThat((Object)db.get(withTimestampColumnFamily, "key12".getBytes()), (Matcher)new IsNull());
        db.close();
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in upgrade mode"));
        LogCaptureAppender.unregister(appender);
        this.rocksDBStore.close();
        columnFamilies.clear();
        db = RocksDB.open((DBOptions)dbOptions, (String)new File(new File(this.context.stateDir(), "rocksdb"), "db-name").getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
        noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
        db.delete(noTimestampColumnFamily, "key7".getBytes());
        db.close();
        appender = LogCaptureAppender.createAndRegister();
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in regular mode"));
        LogCaptureAppender.unregister(appender);
    }

    private void prepareOldStore() {
        RocksDBStore keyValueStore = new RocksDBStore("db-name");
        keyValueStore.init((ProcessorContext)this.context, (StateStore)keyValueStore);
        keyValueStore.put(new Bytes("key1".getBytes()), "1".getBytes());
        keyValueStore.put(new Bytes("key2".getBytes()), "22".getBytes());
        keyValueStore.put(new Bytes("key3".getBytes()), "333".getBytes());
        keyValueStore.put(new Bytes("key4".getBytes()), "4444".getBytes());
        keyValueStore.put(new Bytes("key5".getBytes()), "55555".getBytes());
        keyValueStore.put(new Bytes("key6".getBytes()), "666666".getBytes());
        keyValueStore.put(new Bytes("key7".getBytes()), "7777777".getBytes());
        keyValueStore.close();
    }
}

