/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.kafka.streams.state.internals.RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Logger;
import org.rocksdb.Options;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.RateLimiter;
import org.rocksdb.SstFileManager;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.VectorMemTableConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.util.BytewiseComparator;

@RunWith(value=EasyMockRunner.class)
public class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapterTest {
    private final List<String> ignoreMethods = new LinkedList<String>(){
        {
            this.add("isOwningHandle");
            this.add("dispose");
            this.add("wait");
            this.add("equals");
            this.add("getClass");
            this.add("hashCode");
            this.add("notify");
            this.add("notifyAll");
            this.add("toString");
        }
    };
    @Mock
    private DBOptions dbOptions;
    @Mock
    private ColumnFamilyOptions columnFamilyOptions;

    @Test
    public void shouldOverwriteAllOptionsMethods() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
    }

    @Test
    public void shouldForwardAllDbOptionsCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                DBOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyDBOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void verifyDBOptionsMethodCall(Method method) throws Exception {
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeDbOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(this.dbOptions, new ColumnFamilyOptions());
        Object[] parameters = this.getDBOptionsParameters(method.getParameterTypes());
        try {
            EasyMock.reset((Object[])new Object[]{this.dbOptions});
            EasyMock.replay((Object[])new Object[]{this.dbOptions});
            method.invoke((Object)optionsFacadeDbOptions, parameters);
            EasyMock.verify((Object[])new Object[0]);
            Assert.fail((String)("Should have called DBOptions." + method.getName() + "()"));
        }
        catch (InvocationTargetException undeclaredMockMethodCall) {
            Assert.assertThat((Object)undeclaredMockMethodCall.getCause(), (Matcher)Matchers.instanceOf(AssertionError.class));
            Assert.assertThat((Object)undeclaredMockMethodCall.getCause().getMessage().trim(), (Matcher)Matchers.matchesPattern((String)("Unexpected method call DBOptions\\." + method.getName() + "((.*\n*)*):")));
        }
    }

    private Object[] getDBOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block28: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block28;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block28;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block28;
                }
                case "java.util.Collection": {
                    parameters[i] = new ArrayList();
                    continue block28;
                }
                case "org.rocksdb.AccessHint": {
                    parameters[i] = AccessHint.NONE;
                    continue block28;
                }
                case "org.rocksdb.Cache": {
                    parameters[i] = new LRUCache(1L);
                    continue block28;
                }
                case "org.rocksdb.Env": {
                    parameters[i] = Env.getDefault();
                    continue block28;
                }
                case "org.rocksdb.InfoLogLevel": {
                    parameters[i] = InfoLogLevel.FATAL_LEVEL;
                    continue block28;
                }
                case "org.rocksdb.Logger": {
                    parameters[i] = new Logger(new Options()){

                        protected void log(InfoLogLevel infoLogLevel, String logMsg) {
                        }
                    };
                    continue block28;
                }
                case "org.rocksdb.RateLimiter": {
                    parameters[i] = new RateLimiter(1L);
                    continue block28;
                }
                case "org.rocksdb.SstFileManager": {
                    parameters[i] = new SstFileManager(Env.getDefault());
                    continue block28;
                }
                case "org.rocksdb.WALRecoveryMode": {
                    parameters[i] = WALRecoveryMode.AbsoluteConsistency;
                    continue block28;
                }
                default: {
                    parameters[i] = parameterTypes[i].newInstance();
                }
            }
        }
        return parameters;
    }

    @Test
    public void shouldForwardAllColumnFamilyCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                ColumnFamilyOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyColumnFamilyOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void verifyColumnFamilyOptionsMethodCall(Method method) throws Exception {
        RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeColumnFamilyOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(new DBOptions(), this.columnFamilyOptions);
        Object[] parameters = this.getColumnFamilyOptionsParameters(method.getParameterTypes());
        try {
            EasyMock.reset((Object[])new Object[]{this.columnFamilyOptions});
            EasyMock.replay((Object[])new Object[]{this.columnFamilyOptions});
            method.invoke((Object)optionsFacadeColumnFamilyOptions, parameters);
            EasyMock.verify((Object[])new Object[0]);
            Assert.fail((String)("Should have called ColumnFamilyOptions." + method.getName() + "()"));
        }
        catch (InvocationTargetException undeclaredMockMethodCall) {
            Assert.assertThat((Object)undeclaredMockMethodCall.getCause(), (Matcher)Matchers.instanceOf(AssertionError.class));
            Assert.assertThat((Object)undeclaredMockMethodCall.getCause().getMessage().trim(), (Matcher)Matchers.matchesPattern((String)("Unexpected method call ColumnFamilyOptions\\." + method.getName() + "(.*)")));
        }
    }

    private Object[] getColumnFamilyOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block32: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block32;
                }
                case "double": {
                    parameters[i] = 0.0;
                    continue block32;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block32;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block32;
                }
                case "[I": {
                    parameters[i] = new int[0];
                    continue block32;
                }
                case "java.util.List": {
                    parameters[i] = new ArrayList();
                    continue block32;
                }
                case "org.rocksdb.AbstractComparator": {
                    parameters[i] = new BytewiseComparator(new ComparatorOptions());
                    continue block32;
                }
                case "org.rocksdb.BuiltinComparator": {
                    parameters[i] = BuiltinComparator.BYTEWISE_COMPARATOR;
                    continue block32;
                }
                case "org.rocksdb.CompactionPriority": {
                    parameters[i] = CompactionPriority.ByCompensatedSize;
                    continue block32;
                }
                case "org.rocksdb.CompactionStyle": {
                    parameters[i] = CompactionStyle.UNIVERSAL;
                    continue block32;
                }
                case "org.rocksdb.CompressionType": {
                    parameters[i] = CompressionType.NO_COMPRESSION;
                    continue block32;
                }
                case "org.rocksdb.MemTableConfig": {
                    parameters[i] = new VectorMemTableConfig();
                    continue block32;
                }
                case "org.rocksdb.MergeOperator": {
                    parameters[i] = new StringAppendOperator();
                    continue block32;
                }
                case "org.rocksdb.TableFormatConfig": {
                    parameters[i] = new PlainTableConfig();
                    continue block32;
                }
                default: {
                    parameters[i] = parameterTypes[i].newInstance();
                }
            }
        }
        return parameters;
    }
}

