/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class KeyValueStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private KeyValueBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private KeyValueStore<Bytes, byte[]> inner;
    private KeyValueStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.supplier.get()).andReturn(this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        this.builder = new KeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        KeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        KeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        KeyValueStore store = (KeyValueStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        KeyValueStore store = (KeyValueStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        KeyValueStore store = (KeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        KeyValueStore store = (KeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfInnerIsNull() {
        new KeyValueStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        new KeyValueStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        new KeyValueStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfTimeIsNull() {
        new KeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        new KeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }
}

