/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.UnwindowedChangelogTopicConfig;
import org.apache.kafka.streams.processor.internals.WindowedChangelogTopicConfig;
import org.junit.Assert;
import org.junit.Test;

public class InternalTopicConfigTest {
    @Test(expected=NullPointerException.class)
    public void shouldThrowIfNameIsNull() {
        new RepartitionTopicConfig(null, Collections.emptyMap());
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldThrowIfNameIsInvalid() {
        new RepartitionTopicConfig("foo bar baz", Collections.emptyMap());
    }

    @Test
    public void shouldAugmentRetentionMsWithWindowedChangelog() {
        WindowedChangelogTopicConfig topicConfig = new WindowedChangelogTopicConfig("name", Collections.emptyMap());
        topicConfig.setRetentionMs(10L);
        Assert.assertEquals((Object)"30", topicConfig.getProperties(Collections.emptyMap(), 20L).get("retention.ms"));
    }

    @Test
    public void shouldUseSuppliedConfigs() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        configs.put("retention.bytes", "10000");
        UnwindowedChangelogTopicConfig topicConfig = new UnwindowedChangelogTopicConfig("name", configs);
        Map properties = topicConfig.getProperties(Collections.emptyMap(), 0L);
        Assert.assertEquals((Object)"1000", properties.get("retention.ms"));
        Assert.assertEquals((Object)"10000", properties.get("retention.bytes"));
    }

    @Test
    public void shouldUseSuppliedConfigsForRepartitionConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("retention.ms", "1000");
        RepartitionTopicConfig topicConfig = new RepartitionTopicConfig("name", configs);
        Assert.assertEquals((Object)"1000", topicConfig.getProperties(Collections.emptyMap(), 0L).get("retention.ms"));
    }
}

