/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamFlatTransform;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class KStreamFlatTransformTest
extends EasyMockSupport {
    private Number inputKey;
    private Number inputValue;
    private Transformer<Number, Number, Iterable<KeyValue<Integer, Integer>>> transformer;
    private ProcessorContext context;
    private KStreamFlatTransform.KStreamFlatTransformProcessor<Number, Number, Integer, Integer> processor;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        this.inputKey = 1;
        this.inputValue = 10;
        this.transformer = (Transformer)this.mock(Transformer.class);
        this.context = (ProcessorContext)this.strictMock(ProcessorContext.class);
        this.processor = new KStreamFlatTransform.KStreamFlatTransformProcessor(this.transformer);
    }

    @Test
    public void shouldInitialiseFlatTransformProcessor() {
        this.transformer.init(this.context);
        this.replayAll();
        this.processor.init(this.context);
        this.verifyAll();
    }

    @Test
    public void shouldTransformInputRecordToMultipleOutputRecords() {
        List<KeyValue> outputRecords = Arrays.asList(KeyValue.pair((Object)2, (Object)20), KeyValue.pair((Object)3, (Object)30), KeyValue.pair((Object)4, (Object)40));
        this.processor.init(this.context);
        EasyMock.reset((Object[])new Object[]{this.transformer});
        EasyMock.expect((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).andReturn(outputRecords);
        for (KeyValue outputRecord : outputRecords) {
            this.context.forward(outputRecord.key, outputRecord.value);
        }
        this.replayAll();
        this.processor.process((Object)this.inputKey, (Object)this.inputValue);
        this.verifyAll();
    }

    @Test
    public void shouldAllowEmptyListAsResultOfTransform() {
        this.processor.init(this.context);
        EasyMock.reset((Object[])new Object[]{this.transformer});
        EasyMock.expect((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).andReturn(Collections.emptyList());
        this.replayAll();
        this.processor.process((Object)this.inputKey, (Object)this.inputValue);
        this.verifyAll();
    }

    @Test
    public void shouldAllowNullAsResultOfTransform() {
        this.processor.init(this.context);
        EasyMock.reset((Object[])new Object[]{this.transformer});
        EasyMock.expect((Object)this.transformer.transform((Object)this.inputKey, (Object)this.inputValue)).andReturn(null);
        this.replayAll();
        this.processor.process((Object)this.inputKey, (Object)this.inputValue);
        this.verifyAll();
    }

    @Test
    public void shouldCloseFlatTransformProcessor() {
        this.transformer.close();
        this.replayAll();
        this.processor.close();
        this.verifyAll();
    }

    @Test
    public void shouldGetFlatTransformProcessor() {
        TransformerSupplier transformerSupplier = (TransformerSupplier)this.mock(TransformerSupplier.class);
        KStreamFlatTransform processorSupplier = new KStreamFlatTransform(transformerSupplier);
        EasyMock.expect((Object)transformerSupplier.get()).andReturn(this.transformer);
        this.replayAll();
        Processor processor = processorSupplier.get();
        this.verifyAll();
        Assert.assertTrue((boolean)(processor instanceof KStreamFlatTransform.KStreamFlatTransformProcessor));
    }
}

