/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class KTableKTableJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, Change<V1>, Change<V2>, Change<VR>> {
    private final String[] joinThisStoreNames;
    private final String[] joinOtherStoreNames;
    private final MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal;

    KTableKTableJoinNode(String nodeName, ValueJoiner<? super Change<V1>, ? super Change<V2>, ? extends Change<VR>> valueJoiner, ProcessorParameters<K, Change<V1>> joinThisProcessorParameters, ProcessorParameters<K, Change<V2>> joinOtherProcessorParameters, ProcessorParameters<K, Change<VR>> joinMergeProcessorParameters, MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal, String thisJoinSide, String otherJoinSide, String[] joinThisStoreNames, String[] joinOtherStoreNames) {
        super(nodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessorParameters, joinMergeProcessorParameters, thisJoinSide, otherJoinSide);
        this.joinThisStoreNames = joinThisStoreNames;
        this.joinOtherStoreNames = joinOtherStoreNames;
        this.materializedInternal = materializedInternal;
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String thisProcessorName = this.thisProcessorParameters().processorName();
        String otherProcessorName = this.otherProcessorParameters().processorName();
        String mergeProcessorName = this.mergeProcessorParameters().processorName();
        topologyBuilder.addProcessor(thisProcessorName, this.thisProcessorParameters().processorSupplier(), this.thisJoinSideNodeName());
        topologyBuilder.addProcessor(otherProcessorName, this.otherProcessorParameters().processorSupplier(), this.otherJoinSideNodeName());
        topologyBuilder.addProcessor(mergeProcessorName, this.mergeProcessorParameters().processorSupplier(), thisProcessorName, otherProcessorName);
        topologyBuilder.connectProcessorAndStateStores(thisProcessorName, this.joinOtherStoreNames);
        topologyBuilder.connectProcessorAndStateStores(otherProcessorName, this.joinThisStoreNames);
        if (this.materializedInternal != null) {
            StoreBuilder<KeyValueStore<K, VR>> storeBuilder = new KeyValueStoreMaterializer<K, VR>(this.materializedInternal).materialize();
            topologyBuilder.addStateStore(storeBuilder, mergeProcessorName);
        }
    }

    @Override
    public String toString() {
        return "KTableKTableJoinNode{joinThisStoreNames=" + Arrays.toString(this.joinThisStoreNames) + ", joinOtherStoreNames=" + Arrays.toString(this.joinOtherStoreNames) + ", materializedInternal=" + this.materializedInternal + "} " + super.toString();
    }

    public static <K, V1, V2, VR> KTableKTableJoinNodeBuilder<K, V1, V2, VR> kTableKTableJoinNodeBuilder() {
        return new KTableKTableJoinNodeBuilder();
    }

    public static final class KTableKTableJoinNodeBuilder<K, V1, V2, VR> {
        private String nodeName;
        private String[] joinThisStoreNames;
        private ProcessorParameters<K, Change<V1>> joinThisProcessorParameters;
        private String[] joinOtherStoreNames;
        private MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal;
        private ProcessorParameters<K, Change<V2>> joinOtherProcessorParameters;
        private ProcessorParameters<K, Change<VR>> joinMergeProcessorParameters;
        private ValueJoiner<? super Change<V1>, ? super Change<V2>, ? extends Change<VR>> valueJoiner;
        private String thisJoinSide;
        private String otherJoinSide;

        private KTableKTableJoinNodeBuilder() {
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinThisStoreNames(String[] joinThisStoreNames) {
            this.joinThisStoreNames = joinThisStoreNames;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, Change<V1>> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinOtherStoreNames(String[] joinOtherStoreNames) {
            this.joinOtherStoreNames = joinOtherStoreNames;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, Change<V2>> joinOtherProcessorParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessorParameters;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, Change<VR>> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoiner<? super Change<V1>, ? super Change<V2>, ? extends Change<VR>> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withThisJoinSideNodeName(String thisJoinSide) {
            this.thisJoinSide = thisJoinSide;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withOtherJoinSideNodeName(String otherJoinSide) {
            this.otherJoinSide = otherJoinSide;
            return this;
        }

        public KTableKTableJoinNodeBuilder<K, V1, V2, VR> withMaterializedInternal(MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal) {
            this.materializedInternal = materializedInternal;
            return this;
        }

        public KTableKTableJoinNode<K, V1, V2, VR> build() {
            return new KTableKTableJoinNode<K, V1, V2, VR>(this.nodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.materializedInternal, this.thisJoinSide, this.otherJoinSide, this.joinThisStoreNames, this.joinOtherStoreNames);
        }
    }
}

