/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.Task;

public class TaskMigratedException
extends StreamsException {
    private static final long serialVersionUID = 1L;
    private final Task task;

    public TaskMigratedException() {
        super("A task has been migrated unexpectedly", null);
        this.task = null;
    }

    public TaskMigratedException(Task task, TopicPartition topicPartition, long endOffset, long pos) {
        super(String.format("Log end offset of %s should not change while restoring: old end offset %d, current offset %d", topicPartition, endOffset, pos), null);
        this.task = task;
    }

    public TaskMigratedException(Task task) {
        super(String.format("Task %s is unexpectedly closed during processing", task.id()), null);
        this.task = task;
    }

    public TaskMigratedException(Task task, Throwable throwable) {
        super(String.format("Client request for task %s has been fenced due to a rebalance", task.id()), throwable);
        this.task = task;
    }

    public Task migratedTask() {
        return this.task;
    }
}

