/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.CompositeRestoreListener;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StateRestoreCallbackAdapter;
import org.apache.kafka.streams.processor.internals.ToInternal;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.StreamsTestUtils;

public class InternalMockProcessorContext
extends AbstractProcessorContext
implements RecordCollector.Supplier {
    private final File stateDir;
    private final RecordCollector.Supplier recordCollectorSupplier;
    private final Map<String, StateStore> storeMap = new LinkedHashMap<String, StateStore>();
    private final Map<String, StateRestoreCallback> restoreFuncs = new HashMap<String, StateRestoreCallback>();
    private final ToInternal toInternal = new ToInternal();
    private Serde<?> keySerde;
    private Serde<?> valSerde;
    private long timestamp = -1L;

    public InternalMockProcessorContext() {
        this(null, null, null, new StreamsMetricsImpl(new Metrics(), "mock"), new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()), null, null);
    }

    public InternalMockProcessorContext(File stateDir, StreamsConfig config) {
        this(stateDir, null, null, new StreamsMetricsImpl(new Metrics(), "mock"), config, null, null);
    }

    public InternalMockProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, StreamsConfig config) {
        this(stateDir, keySerde, valSerde, new StreamsMetricsImpl(new Metrics(), "mock"), config, null, null);
    }

    public InternalMockProcessorContext(StateSerdes<?, ?> serdes, RecordCollector collector) {
        this(null, serdes.keySerde(), serdes.valueSerde(), collector, null);
    }

    public InternalMockProcessorContext(StateSerdes<?, ?> serdes, RecordCollector collector, Metrics metrics) {
        this(null, serdes.keySerde(), serdes.valueSerde(), new StreamsMetricsImpl(metrics, "mock"), new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()), () -> collector, null);
    }

    public InternalMockProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, RecordCollector collector, ThreadCache cache) {
        this(stateDir, keySerde, valSerde, new StreamsMetricsImpl(new Metrics(), "mock"), new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()), () -> collector, cache);
    }

    public InternalMockProcessorContext(File stateDir, Serde<?> keySerde, Serde<?> valSerde, StreamsMetricsImpl metrics, StreamsConfig config, RecordCollector.Supplier collectorSupplier, ThreadCache cache) {
        super(new TaskId(0, 0), config, metrics, null, cache);
        super.setCurrentNode(new ProcessorNode("TESTING_NODE"));
        this.stateDir = stateDir;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.recordCollectorSupplier = collectorSupplier;
    }

    public RecordCollector recordCollector() {
        RecordCollector recordCollector = this.recordCollectorSupplier.recordCollector();
        if (recordCollector == null) {
            throw new UnsupportedOperationException("No RecordCollector specified");
        }
        return recordCollector;
    }

    public void setKeySerde(Serde<?> keySerde) {
        this.keySerde = keySerde;
    }

    public void setValueSerde(Serde<?> valSerde) {
        this.valSerde = valSerde;
    }

    public Serde<?> keySerde() {
        return this.keySerde;
    }

    public Serde<?> valueSerde() {
        return this.valSerde;
    }

    public void initialize() {
    }

    public File stateDir() {
        if (this.stateDir == null) {
            throw new UnsupportedOperationException("State directory not specified");
        }
        return this.stateDir;
    }

    public void register(StateStore store, StateRestoreCallback func) {
        this.storeMap.put(store.name(), store);
        this.restoreFuncs.put(store.name(), func);
    }

    public StateStore getStateStore(String name) {
        return this.storeMap.get(name);
    }

    public Cancellable schedule(long interval, PunctuationType type, Punctuator callback) {
        throw new UnsupportedOperationException("schedule() not supported.");
    }

    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        throw new UnsupportedOperationException("schedule() not supported.");
    }

    public void commit() {
    }

    public <K, V> void forward(K key, V value) {
        this.forward(key, value, To.all());
    }

    public <K, V> void forward(K key, V value, int childIndex) {
        this.forward(key, value, To.child((String)((ProcessorNode)this.currentNode().children().get(childIndex)).name()));
    }

    public <K, V> void forward(K key, V value, String childName) {
        this.forward(key, value, To.child((String)childName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void forward(K key, V value, To to) {
        this.toInternal.update(to);
        if (this.toInternal.hasTimestamp()) {
            this.setTime(this.toInternal.timestamp());
        }
        ProcessorNode thisNode = this.currentNode;
        try {
            for (ProcessorNode childNode : thisNode.children()) {
                if (this.toInternal.child() != null && !this.toInternal.child().equals(childNode.name())) continue;
                this.currentNode = childNode;
                childNode.process(key, value);
                this.toInternal.update(to);
            }
        }
        finally {
            this.currentNode = thisNode;
        }
    }

    public void setTime(long timestamp) {
        if (this.recordContext != null) {
            this.recordContext = new ProcessorRecordContext(timestamp, this.recordContext.offset(), this.recordContext.partition(), this.recordContext.topic(), this.recordContext.headers());
        }
        this.timestamp = timestamp;
    }

    public long timestamp() {
        if (this.recordContext == null) {
            return this.timestamp;
        }
        return this.recordContext.timestamp();
    }

    public String topic() {
        if (this.recordContext == null) {
            return null;
        }
        return this.recordContext.topic();
    }

    public int partition() {
        if (this.recordContext == null) {
            return -1;
        }
        return this.recordContext.partition();
    }

    public long offset() {
        if (this.recordContext == null) {
            return -1L;
        }
        return this.recordContext.offset();
    }

    public Headers headers() {
        if (this.recordContext == null) {
            return new RecordHeaders();
        }
        return this.recordContext.headers();
    }

    Map<String, StateStore> allStateStores() {
        return Collections.unmodifiableMap(this.storeMap);
    }

    public StateRestoreListener getRestoreListener(String storeName) {
        return this.getStateRestoreListener(this.restoreFuncs.get(storeName));
    }

    public void restore(String storeName, Iterable<KeyValue<byte[], byte[]>> changeLog) {
        RecordBatchingStateRestoreCallback restoreCallback = StateRestoreCallbackAdapter.adapt((StateRestoreCallback)this.restoreFuncs.get(storeName));
        StateRestoreListener restoreListener = this.getRestoreListener(storeName);
        restoreListener.onRestoreStart(null, storeName, 0L, 0L);
        ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>();
        for (KeyValue<byte[], byte[]> keyValue : changeLog) {
            records.add(new ConsumerRecord("", 0, 0L, keyValue.key, keyValue.value));
        }
        restoreCallback.restoreBatch(records);
        restoreListener.onRestoreEnd(null, storeName, 0L);
    }

    private StateRestoreListener getStateRestoreListener(StateRestoreCallback restoreCallback) {
        if (restoreCallback instanceof StateRestoreListener) {
            return (StateRestoreListener)restoreCallback;
        }
        return CompositeRestoreListener.NO_OP_STATE_RESTORE_LISTENER;
    }
}

