/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.kstream.internals.WindowedStreamPartitioner;
import org.junit.Assert;
import org.junit.Test;

public class WindowedStreamPartitionerTest {
    private String topicName = "topic";
    private IntegerSerializer intSerializer = new IntegerSerializer();
    private StringSerializer stringSerializer = new StringSerializer();
    private List<PartitionInfo> infos = Arrays.asList(new PartitionInfo(this.topicName, 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 3, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 4, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo(this.topicName, 5, Node.noNode(), new Node[0], new Node[0]));
    private Cluster cluster = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());

    @Test
    public void testCopartitioning() {
        Random rand = new Random();
        DefaultPartitioner defaultPartitioner = new DefaultPartitioner();
        TimeWindowedSerializer timeWindowedSerializer = new TimeWindowedSerializer((Serializer)this.intSerializer);
        WindowedStreamPartitioner streamPartitioner = new WindowedStreamPartitioner((WindowedSerializer)timeWindowedSerializer);
        for (int k = 0; k < 10; ++k) {
            Integer key = rand.nextInt();
            byte[] keyBytes = this.intSerializer.serialize(this.topicName, key);
            String value = key.toString();
            byte[] valueBytes = this.stringSerializer.serialize(this.topicName, value);
            Integer expected = defaultPartitioner.partition("topic", (Object)key, keyBytes, (Object)value, valueBytes, this.cluster);
            for (int w = 1; w < 10; ++w) {
                TimeWindow window = new TimeWindow((long)(10 * w), (long)(20 * w));
                Windowed windowedKey = new Windowed((Object)key, (Window)window);
                Integer actual = streamPartitioner.partition(this.topicName, windowedKey, (Object)value, this.infos.size());
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
        defaultPartitioner.close();
    }
}

