/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ProducerIdsBlockTest {
    ProducerIdsBlockTest() {
    }

    @Test
    public void testEmptyBlock() {
        Assertions.assertEquals((long)-1L, (long)ProducerIdsBlock.EMPTY.lastProducerId());
        Assertions.assertEquals((long)0L, (long)ProducerIdsBlock.EMPTY.nextBlockFirstId());
        Assertions.assertEquals((int)0, (int)ProducerIdsBlock.EMPTY.size());
    }

    @Test
    public void testDynamicBlock() {
        long firstId = 1309418324L;
        int blockSize = 5391;
        int brokerId = 5;
        ProducerIdsBlock block = new ProducerIdsBlock(brokerId, firstId, blockSize);
        Assertions.assertEquals((long)firstId, (long)block.firstProducerId());
        Assertions.assertEquals((long)(firstId + (long)blockSize - 1L), (long)block.lastProducerId());
        Assertions.assertEquals((long)(firstId + (long)blockSize), (long)block.nextBlockFirstId());
        Assertions.assertEquals((int)blockSize, (int)block.size());
        Assertions.assertEquals((int)brokerId, (int)block.assignedBrokerId());
    }

    @Test
    public void testClaimNextId() throws Exception {
        for (int i = 0; i < 50; ++i) {
            ProducerIdsBlock block = new ProducerIdsBlock(0, 1L, 1);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicLong counter = new AtomicLong(0L);
            CompletableFuture.runAsync(() -> {
                Optional pid = block.claimNextId();
                counter.addAndGet(pid.orElse(0L));
                latch.countDown();
            });
            Optional pid = block.claimNextId();
            counter.addAndGet(pid.orElse(0L));
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)1L, (long)counter.get());
        }
    }
}

