/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.metadata;

import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.raft.RecordSerde;

public class MetadataRecordSerde
implements RecordSerde<ApiMessageAndVersion> {
    private static final short DEFAULT_FRAME_VERSION = 0;
    private static final int DEFAULT_FRAME_VERSION_SIZE = ByteUtils.sizeOfUnsignedVarint((int)0);

    @Override
    public int recordSize(ApiMessageAndVersion data, ObjectSerializationCache serializationCache) {
        int size = DEFAULT_FRAME_VERSION_SIZE;
        size += ByteUtils.sizeOfUnsignedVarint((int)data.message().apiKey());
        size += ByteUtils.sizeOfUnsignedVarint((int)data.version());
        return size += data.message().size(serializationCache, data.version());
    }

    @Override
    public void write(ApiMessageAndVersion data, ObjectSerializationCache serializationCache, Writable out) {
        out.writeUnsignedVarint(0);
        out.writeUnsignedVarint((int)data.message().apiKey());
        out.writeUnsignedVarint((int)data.version());
        data.message().write(out, serializationCache, data.version());
    }

    @Override
    public ApiMessageAndVersion read(Readable input, int size) {
        short frameVersion = (short)input.readUnsignedVarint();
        if (frameVersion != 0) {
            throw new SerializationException("Could not deserialize metadata record due to unknown frame version " + frameVersion + "(only frame version " + 0 + " is supported)");
        }
        short apiKey = (short)input.readUnsignedVarint();
        short version = (short)input.readUnsignedVarint();
        MetadataRecordType recordType = MetadataRecordType.fromId((short)apiKey);
        ApiMessage record = recordType.newMetadataRecord();
        record.read(input, version);
        return new ApiMessageAndVersion(record, version);
    }
}

