/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndTransactionMarkerTest {
    @Test
    public void testUnknownControlTypeNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EndTransactionMarker(ControlRecordType.UNKNOWN, 24));
    }

    @Test
    public void testCannotDeserializeUnknownControlType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.UNKNOWN, (ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }

    @Test
    public void testIllegalNegativeVersion() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort((short)-1);
        buffer.flip();
        Assertions.assertThrows(InvalidRecordException.class, () -> EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.ABORT, (ByteBuffer)buffer));
    }

    @Test
    public void testNotEnoughBytes() {
        Assertions.assertThrows(InvalidRecordException.class, () -> EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }

    @Test
    public void testSerde() {
        int coordinatorEpoch = 79;
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        ByteBuffer buffer = marker.serializeValue();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assertions.assertEquals((int)coordinatorEpoch, (int)deserialized.coordinatorEpoch());
    }

    @Test
    public void testDeserializeNewerVersion() {
        int coordinatorEpoch = 79;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putShort((short)5);
        buffer.putInt(coordinatorEpoch);
        buffer.putShort((short)0);
        buffer.flip();
        EndTransactionMarker deserialized = EndTransactionMarker.deserializeValue((ControlRecordType)ControlRecordType.COMMIT, (ByteBuffer)buffer);
        Assertions.assertEquals((int)coordinatorEpoch, (int)deserialized.coordinatorEpoch());
    }
}

