/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Random;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.UnretryableException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HttpAccessTokenRetrieverTest
extends OAuthBearerTest {
    @Test
    public void test() throws IOException {
        String expectedResponse = "Hiya, buddy";
        HttpURLConnection mockedCon = this.createHttpURLConnection(expectedResponse);
        String response = HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null);
        Assertions.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testEmptyResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("");
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testErrorReadingResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testErrorResponseUnretryableCode() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"error\":\"some_arg\", \"error_description\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)400);
        UnretryableException ioe = (UnretryableException)Assertions.assertThrows(UnretryableException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
    }

    @Test
    public void testErrorResponseRetryableCode() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"error\":\"some_arg\", \"error_description\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)500);
        IOException ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"errorCode\":\"some_arg\", \"errorSummary\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"err\":\"some_arg\", \"err_des\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"err\":\"some_arg\", \"err_des\":\"some problem with arg\"}"));
    }

    @Test
    public void testErrorResponseIsInvalidJson() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("non json error output".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)500);
        IOException ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{non json error output}"));
    }

    @Test
    public void testCopy() throws IOException {
        byte[] expected = new byte[4097];
        Random r = new Random();
        r.nextBytes(expected);
        ByteArrayInputStream in = new ByteArrayInputStream(expected);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpAccessTokenRetriever.copy((InputStream)in, (OutputStream)out);
        Assertions.assertArrayEquals((byte[])expected, (byte[])out.toByteArray());
    }

    @Test
    public void testCopyError() throws IOException {
        InputStream mockedIn = (InputStream)Mockito.mock(InputStream.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Mockito.when((Object)mockedIn.read((byte[])ArgumentMatchers.any(byte[].class))).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.copy((InputStream)mockedIn, (OutputStream)out));
    }

    @Test
    public void testParseAccessToken() throws IOException {
        String expected = "abc";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", expected);
        String actual = HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testParseAccessTokenEmptyAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("access_token", "");
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseAccessTokenMissingAccessToken() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("sub", "jdoe");
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)mapper.writeValueAsString((Object)node)));
    }

    @Test
    public void testParseAccessTokenInvalidJson() {
        Assertions.assertThrows(IOException.class, () -> HttpAccessTokenRetriever.parseAccessToken((String)"not valid JSON"));
    }

    @Test
    public void testFormatAuthorizationHeader() throws IOException {
        this.assertAuthorizationHeader("id", "secret");
    }

    @Test
    public void testFormatAuthorizationHeaderEncoding() throws IOException {
        this.assertAuthorizationHeader("SOME_RANDOM_LONG_USER_01234", "9Q|0`8i~ute-n9ksjLWb\\50\"AX@UUED5E");
    }

    private void assertAuthorizationHeader(String clientId, String clientSecret) throws IOException {
        String expected = "Basic " + Base64.getEncoder().encodeToString(Utils.utf8((String)(clientId + ":" + clientSecret)));
        String actual = HttpAccessTokenRetriever.formatAuthorizationHeader((String)clientId, (String)clientSecret);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)String.format("Expected the HTTP Authorization header generated for client ID \"%s\" and client secret \"%s\" to match", clientId, clientSecret));
    }

    @Test
    public void testFormatAuthorizationHeaderMissingValues() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader(null, (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"", (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"", (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"  ", (String)"secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"id", (String)"  "));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpAccessTokenRetriever.formatAuthorizationHeader((String)"  ", (String)"  "));
    }

    @Test
    public void testFormatRequestBody() throws IOException {
        String expected = "grant_type=client_credentials&scope=scope";
        String actual = HttpAccessTokenRetriever.formatRequestBody((String)"scope");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatRequestBodyWithEscaped() throws IOException {
        String questionMark = "%3F";
        String exclamationMark = "%21";
        String expected = String.format("grant_type=client_credentials&scope=earth+is+great%s", exclamationMark);
        String actual = HttpAccessTokenRetriever.formatRequestBody((String)"earth is great!");
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected = String.format("grant_type=client_credentials&scope=what+on+earth%s%s%s%s%s", questionMark, exclamationMark, questionMark, exclamationMark, questionMark);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"what on earth?!?!?");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatRequestBodyMissingValues() throws IOException {
        String expected = "grant_type=client_credentials";
        String actual = HttpAccessTokenRetriever.formatRequestBody(null);
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"");
        Assertions.assertEquals((Object)expected, (Object)actual);
        actual = HttpAccessTokenRetriever.formatRequestBody((String)"  ");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

