/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.RequestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProduceRequestTest {
    private final SimpleRecord simpleRecord = new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());

    @Test
    public void shouldBeFlaggedAsTransactionalWhenTransactionalRecords() {
        MemoryRecords memoryRecords = MemoryRecords.withTransactionalRecords((long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(10)).build();
        Assertions.assertTrue((boolean)RequestUtils.hasTransactionalRecords((ProduceRequest)request));
    }

    @Test
    public void shouldNotBeFlaggedAsTransactionalWhenNoRecords() {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assertions.assertFalse((boolean)RequestUtils.hasTransactionalRecords((ProduceRequest)request));
    }

    @Test
    public void shouldNotBeFlaggedAsIdempotentWhenRecordsNotIdempotent() {
        ProduceRequest request = this.createNonIdempotentNonTransactionalRecords();
        Assertions.assertFalse((boolean)RequestUtils.hasTransactionalRecords((ProduceRequest)request));
    }

    @Test
    public void shouldBeFlaggedAsIdempotentWhenIdempotentRecords() {
        MemoryRecords memoryRecords = MemoryRecords.withIdempotentRecords((long)1L, (CompressionType)CompressionType.NONE, (long)1L, (short)1, (int)1, (int)1, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord});
        ProduceRequest request = (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(10)).build();
        Assertions.assertTrue((boolean)RequestTestUtils.hasIdempotentRecords(request));
    }

    @Test
    public void testBuildWithOldMessageFormat() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forMagic((byte)1, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(9).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        Assertions.assertEquals((int)2, (int)requestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((int)2, (int)requestBuilder.latestAllowedVersion());
    }

    @Test
    public void testBuildWithCurrentMessageFormat() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(9).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        Assertions.assertEquals((int)3, (int)requestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.PRODUCE.latestVersion(), (short)requestBuilder.latestAllowedVersion());
    }

    @Test
    public void testV3AndAboveShouldContainOnlyOneRecordBatch() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "1".getBytes(), "b".getBytes());
        builder.append(12L, null, "c".getBytes());
        builder.close();
        buffer.flip();
        ProduceRequest.Builder requestBuilder = ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.readableRecords((ByteBuffer)buffer))))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        ProduceRequestTest.assertThrowsForAllVersions(requestBuilder, InvalidRecordException.class);
    }

    @Test
    public void testV3AndAboveCannotHaveNoRecordBatches() {
        ProduceRequest.Builder requestBuilder = ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.EMPTY)))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        ProduceRequestTest.assertThrowsForAllVersions(requestBuilder, InvalidRecordException.class);
    }

    @Test
    public void testV3AndAboveCannotUseMagicV0() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)0, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.NO_TIMESTAMP_TYPE, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        ProduceRequestTest.assertThrowsForAllVersions(requestBuilder, InvalidRecordException.class);
    }

    @Test
    public void testV3AndAboveCannotUseMagicV1() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        ProduceRequestTest.assertThrowsForAllVersions(requestBuilder, InvalidRecordException.class);
    }

    @Test
    public void testV6AndBelowCannotUseZStdCompression() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.ZSTD, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequestData produceData = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(1000);
        for (short version = 3; version < 7; version = (short)(version + 1)) {
            ProduceRequest.Builder requestBuilder = new ProduceRequest.Builder(version, version, produceData);
            ProduceRequestTest.assertThrowsForAllVersions(requestBuilder, UnsupportedCompressionTypeException.class);
        }
        ProduceRequest.forCurrentMagic((ProduceRequestData)produceData);
    }

    @Test
    public void testMixedTransactionalData() {
        long producerId = 15L;
        int producerEpoch = 5;
        int sequence = 10;
        MemoryRecords nonTxnRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())});
        MemoryRecords txnRecords = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)15L, (short)5, (int)10, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())});
        ProduceRequest.Builder builder = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Arrays.asList(new ProduceRequestData.TopicProduceData().setName("foo").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)txnRecords))), new ProduceRequestData.TopicProduceData().setName("foo").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)nonTxnRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(5000));
        ProduceRequest request = (ProduceRequest)builder.build();
        Assertions.assertTrue((boolean)RequestUtils.hasTransactionalRecords((ProduceRequest)request));
        Assertions.assertTrue((boolean)RequestTestUtils.hasIdempotentRecords(request));
    }

    @Test
    public void testMixedIdempotentData() {
        long producerId = 15L;
        int producerEpoch = 5;
        int sequence = 10;
        MemoryRecords nonTxnRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())});
        MemoryRecords txnRecords = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)15L, (short)5, (int)10, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())});
        ProduceRequest.Builder builder = ProduceRequest.forMagic((byte)RecordVersion.current().value, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Arrays.asList(new ProduceRequestData.TopicProduceData().setName("foo").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)txnRecords))), new ProduceRequestData.TopicProduceData().setName("foo").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)nonTxnRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(5000));
        ProduceRequest request = (ProduceRequest)builder.build();
        Assertions.assertFalse((boolean)RequestUtils.hasTransactionalRecords((ProduceRequest)request));
        Assertions.assertTrue((boolean)RequestTestUtils.hasIdempotentRecords(request));
    }

    private static <T extends Throwable> void assertThrowsForAllVersions(ProduceRequest.Builder builder, Class<T> expectedType) {
        IntStream.range(builder.oldestAllowedVersion(), builder.latestAllowedVersion() + 1).forEach(version -> Assertions.assertThrows((Class)expectedType, () -> builder.build((short)version).serialize()));
    }

    private ProduceRequest createNonIdempotentNonTransactionalRecords() {
        return (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(1).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{this.simpleRecord}))))).iterator())).setAcks((short)-1).setTimeoutMs(10)).build();
    }
}

