/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestHeaderTest {
    @Test
    public void testSerdeControlledShutdownV0() {
        short apiVersion = 0;
        int correlationId = 2342;
        ByteBuffer rawBuffer = ByteBuffer.allocate(32);
        rawBuffer.putShort(ApiKeys.CONTROLLED_SHUTDOWN.id);
        rawBuffer.putShort(apiVersion);
        rawBuffer.putInt(correlationId);
        rawBuffer.flip();
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)rawBuffer);
        Assertions.assertEquals((Object)ApiKeys.CONTROLLED_SHUTDOWN, (Object)deserialized.apiKey());
        Assertions.assertEquals((int)0, (int)deserialized.apiVersion());
        Assertions.assertEquals((int)correlationId, (int)deserialized.correlationId());
        Assertions.assertEquals((Object)"", (Object)deserialized.clientId());
        Assertions.assertEquals((int)0, (int)deserialized.headerVersion());
        ByteBuffer serializedBuffer = RequestTestUtils.serializeRequestHeader(deserialized);
        Assertions.assertEquals((short)ApiKeys.CONTROLLED_SHUTDOWN.id, (short)serializedBuffer.getShort(0));
        Assertions.assertEquals((int)0, (int)serializedBuffer.getShort(2));
        Assertions.assertEquals((int)correlationId, (int)serializedBuffer.getInt(4));
        Assertions.assertEquals((int)8, (int)serializedBuffer.limit());
    }

    @Test
    public void testRequestHeaderV1() {
        short apiVersion = 1;
        RequestHeader header = new RequestHeader(ApiKeys.FIND_COORDINATOR, apiVersion, "", 10);
        Assertions.assertEquals((int)1, (int)header.headerVersion());
        ByteBuffer buffer = RequestTestUtils.serializeRequestHeader(header);
        Assertions.assertEquals((int)10, (int)buffer.remaining());
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assertions.assertEquals((Object)header, (Object)deserialized);
    }

    @Test
    public void testRequestHeaderV2() {
        short apiVersion = 2;
        RequestHeader header = new RequestHeader(ApiKeys.CREATE_DELEGATION_TOKEN, apiVersion, "", 10);
        Assertions.assertEquals((int)2, (int)header.headerVersion());
        ByteBuffer buffer = RequestTestUtils.serializeRequestHeader(header);
        Assertions.assertEquals((int)11, (int)buffer.remaining());
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assertions.assertEquals((Object)header, (Object)deserialized);
    }

    @Test
    public void parseHeaderFromBufferWithNonZeroPosition() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.position(10);
        RequestHeader header = new RequestHeader(ApiKeys.FIND_COORDINATOR, 1, "", 10);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        header.size(serializationCache);
        header.write(buffer, serializationCache);
        int limit = buffer.position();
        buffer.position(10);
        buffer.limit(limit);
        RequestHeader parsed = RequestHeader.parse((ByteBuffer)buffer);
        Assertions.assertEquals((Object)header, (Object)parsed);
    }

    @Test
    public void parseHeaderWithNullClientId() {
        RequestHeaderData headerData = new RequestHeaderData().setClientId(null).setCorrelationId(123).setRequestApiKey(ApiKeys.FIND_COORDINATOR.id).setRequestApiVersion((short)10);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(headerData.size(serializationCache, (short)2));
        headerData.write((Writable)new ByteBufferAccessor(buffer), serializationCache, (short)2);
        buffer.flip();
        RequestHeader parsed = RequestHeader.parse((ByteBuffer)buffer);
        Assertions.assertEquals((Object)"", (Object)parsed.clientId());
        Assertions.assertEquals((int)123, (int)parsed.correlationId());
        Assertions.assertEquals((Object)ApiKeys.FIND_COORDINATOR, (Object)parsed.apiKey());
        Assertions.assertEquals((short)10, (short)parsed.apiVersion());
    }
}

